/*
 * Java-Gnome Bindings Library
 * 
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 * 
 * The Java-Gnome bindings library is free software distributed under the terms
 * of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Handle;

/**
 * This class implements the native methods that are common with both
 * FileChooserDialog and FileChooserWidget.
 */
class FileChooserHelper {


	native static final void gtk_file_chooser_set_action(Handle chooser, int action);
	native static final int gtk_file_chooser_get_action(Handle chooser);
	native static final void gtk_file_chooser_set_local_only(Handle chooser, boolean localOnly);
	native static final boolean gtk_file_chooser_get_local_only(Handle chooser);
	native static final void gtk_file_chooser_set_select_multiple(Handle chooser, boolean selectMultiple);
	native static final boolean gtk_file_chooser_get_select_multiple(Handle chooser);
	native static final void gtk_file_chooser_set_current_name(Handle chooser, String name);
	native static final String gtk_file_chooser_get_filename(Handle chooser);
	native static final boolean gtk_file_chooser_set_filename(Handle chooser, String filename);
	native static final boolean gtk_file_chooser_select_filename(Handle chooser, String filename);
	native static final void gtk_file_chooser_unselect_filename(Handle chooser, String filename);
	native static final void gtk_file_chooser_select_all(Handle chooser);
	native static final void gtk_file_chooser_unselect_all(Handle chooser);
	native static final String[] gtk_file_chooser_get_filenames(Handle chooser);
	native static final boolean gtk_file_chooser_set_current_folder(Handle chooser, String folder);
	native static final String gtk_file_chooser_get_current_folder(Handle chooser);
	native static final String gtk_file_chooser_get_uri(Handle chooser);
	native static final boolean gtk_file_chooser_set_uri(Handle chooser, String uri);
	native static final boolean gtk_file_chooser_select_uri(Handle chooser, String uri);
	native static final void gtk_file_chooser_unselect_uri(Handle chooser, String uri);
	native static final String[] gtk_file_chooser_get_uris(Handle chooser);
	native static final boolean gtk_file_chooser_set_current_folder_uri(Handle chooser, String uri);
	native static final String gtk_file_chooser_get_current_folder_uri(Handle chooser);
	native static final void gtk_file_chooser_set_preview_widget(Handle chooser, Handle previewWidget);
	native static final Handle gtk_file_chooser_get_preview_widget(Handle chooser);
	native static final void gtk_file_chooser_set_preview_widget_active(Handle chooser, boolean active);
	native static final boolean gtk_file_chooser_get_preview_widget_active(Handle chooser);
	native static final void gtk_file_chooser_set_use_preview_label(Handle chooser, boolean useLabel);
	native static final boolean gtk_file_chooser_get_use_preview_label(Handle chooser);
	native static final String gtk_file_chooser_get_preview_filename(Handle chooser);
	native static final String gtk_file_chooser_get_preview_uri(Handle chooser);
	native static final void gtk_file_chooser_set_extra_widget(Handle chooser, Handle extraWidget);
	native static final Handle gtk_file_chooser_get_extra_widget(Handle chooser);
	native static final void gtk_file_chooser_add_filter(Handle chooser, Handle filter);
	native static final void gtk_file_chooser_remove_filter(Handle chooser, Handle filter);
	native static final Handle[] gtk_file_chooser_list_filters(Handle chooser);
	native static final void gtk_file_chooser_set_filter(Handle chooser, Handle filter);
	native static final Handle gtk_file_chooser_get_filter(Handle chooser);
	native static final boolean gtk_file_chooser_add_shortcut_folder(Handle chooser, String folder, int[] error);
	native static final boolean gtk_file_chooser_remove_shortcut_folder(Handle chooser, String folder, int[] error);
	native static final String[] gtk_file_chooser_list_shortcut_folders(Handle chooser);
	native static final boolean gtk_file_chooser_add_shortcut_folder_uri(Handle chooser, String uri, int[] error);
	native static final boolean gtk_file_chooser_remove_shortcut_folder_uri(Handle chooser, String uri, int[] error);
	native static final String[] gtk_file_chooser_list_shortcut_folder_uris(Handle chooser);

}
