/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif


GdkEventType GdkEventAny_get_type (GdkEventAny * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventAny
 * Method:    getType
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventAny_getType (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventAny *obj_g = (GdkEventAny *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventAny_get_type (obj_g));
}

GdkWindow * GdkEventAny_get_window (GdkEventAny * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventAny
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventAny_getWindow (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventAny *obj_g = (GdkEventAny *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventAny_get_window (obj_g));
}

gboolean GdkEventAny_get_send_event (GdkEventAny * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventAny
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventAny_getSendEvent (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventAny *obj_g = (GdkEventAny *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventAny_get_send_event (obj_g));
}


#ifdef __cplusplus
}

#endif
