/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:27:56 EDT
 */

package org.gnu.gnome;
import org.gnu.glib.Type;
import org.gnu.gtk.VBox;
/**
 *
 */
public class IconSelection extends VBox {
	
	/**
	 * Construct a new IconSelection object.
	 */
	public IconSelection() {
		noopInit();
	}
	
	/**
	 * Construct a new IconSelection from a handle to a native resource.
	 */
	public IconSelection(int handle) {
	    setHandle(handle);
	}
	
	protected void noopInit() {
		if (-1 == getHandle()) {
			setHandle(gnome_icon_selection_new());
			initializeEventHandlers();
		}
	}

	/**
	 * Add the default Gnome icon directories.
	 */
	public void addDefaults() {
		gnome_icon_selection_add_defaults(getHandle());
	}
	
	/**
	 * Add icons from the specified directory.
	 * @param dir The director to add.
	 */
	public void addDirectory(String dir) {
		gnome_icon_selection_add_directory(getHandle(), dir);
	}
	
	/**
	 * Load and display the icons.
	 */
	public void showIcons() {
		gnome_icon_selection_show_icons(getHandle());
	}
	
	/**
	 * Clear all icons (even the icons that are not shown if <i>notShown</i>
	 * is true.
	 */
	public void clear(boolean notShown) {
		gnome_icon_selection_clear(getHandle(), notShown);
	}
	
	/**
	 * Get the filename of the selected icon.  If <i>fullPath</i> is true
	 * the full path of the filename is returned.
	 */
	public String getIcon(boolean fullPath) {
		return gnome_icon_selection_get_icon(getHandle(), fullPath);
	}
	
	/**
	 * Select the icon specified by the filename provided.  The filename
	 * is not the full path, just the last component.
	 */
	public void selectIcon(String filename) {
		gnome_icon_selection_select_icon(getHandle(), filename);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_icon_selection_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gnome_icon_selection_get_type();
	native static final protected int gnome_icon_selection_new();
	native static final protected void gnome_icon_selection_add_defaults(int gis);
	native static final protected void gnome_icon_selection_add_directory(int gis, String dir);
	native static final protected void gnome_icon_selection_show_icons(int gis);
	native static final protected void gnome_icon_selection_clear(int gis, boolean notShown);
	native static final protected String gnome_icon_selection_get_icon(int gis, boolean fullPath);
	native static final protected void gnome_icon_selection_select_icon(int gis, String filename);
	native static final protected void gnome_icon_selection_stop_loading(int gis);
	native static final protected int gnome_icon_selection_get_gil(int gis);
	native static final protected int gnome_icon_selection_get_box(int gis);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
