/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk.event;

import org.gnu.gtk.DeleteType;
import org.gnu.gtk.MovementStep;

/**
 * This event is used to identify when an entry receives an event
 * 
 * @see EntryListener
 */
public class EntryEvent extends GtkEvent {
	public static class Type extends GtkEventType{
		private Type(int id, String name){
			super(id, name);
		}
		
		/**
		 * Indicates that the user has pressed the enter key while in the widget
		 */
		public static final Type ACTIVATE = new Type(1, "ACTIVATE");
		
		/**
		 * Indicates that the user has moved the cursor in the widget.
		 */
		public static final Type MOVE_CURSOR = new Type(2, "MOVE_CURSOR");

		/**
		 * Indicates that the user has inserted text at the cursor.
		 */
		public static final Type INSERT_AT_CURSOR = new Type(3, "INSERT_AT_CURSOR");

		/**
		 * Indicates that the user has deleted text starting at the cursor.
		 */
		public static final Type DELETE_FROM_CURSOR = new Type(4, "DELETE_FROM_CURSOR");

		/**
		 * Clipboard related events
		 */
		public static final Type CUT_CLIPBOARD = new Type(5, "CUT_CLIPBOARD");
		public static final Type COPY_CLIPBOARD = new Type(6, "COPY_CLIPBOARD");
		public static final Type PASTE_CLIPBOARD = new Type(7, "PASTE_CLIPBOARD");
		
	}
	
	/**
	 * Constructor for EditableEvent.
	 * @param source
	 * @param type
	 */
	public EntryEvent(Object source, GtkEventType type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(EntryEvent.Type aType){
		return ( type.getID() == aType.getID());
	}
	
	/**
	 * text is set when the INSERT_AT_CURSOR event is invoked.
	 */
	private String text;
	
	/**
	 * deleteType is set when the DELETE_FROM_CURSOR event is invoked.
	 */
	private DeleteType deleteType;
	/**
	 * count is set when the DELETE_FROM_CURSOR or MOVE_CURSOR events 
	 * are invoked.
	 */
	private int count;
	
	/**
	 * movementStep is set when the MOVE_CURSOR event is invoked.
	 */
	private MovementStep movementStep;
	/**
	 * extendedSelection is set when the MOVE_CURSOR event is invoked.
	 */
	private boolean extendedSelection;
	
	public void setText(String text) {
		this.text = text;
	}
	
	public String getText() {
		return text;
	}
	
	public void setDeleteType(DeleteType type) {
		deleteType = type;
	}
	
	public DeleteType getDeleteType() {
		return deleteType;
	}
	
	public void setCount(int count) {
		this.count = count;
	}
	
	public int getCount() {
		return count;
	}
	
	public void setMovementStep(MovementStep step) {
		movementStep = step;
	}
	
	public MovementStep getMovementStep() {
		return movementStep;
	}
	
	public void setExtendedSelection(boolean extendedSelection) {
		this.extendedSelection = extendedSelection;
	}
	
	public boolean getExtendedSelection() {
		return extendedSelection;
	}
}
