/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * This event is used to identify when an editable receives an event
 * 
 * @see EditableListener
 */
public class EditableEvent extends GtkEvent {

	public static class Type extends GtkEventType{
		private Type(int id, String name){
			super(id, name);
		}

		/**
		 * Indicates that the user has changed the contents of the widget.
		 */
		public static final Type CHANGED = new Type(1, "CHANGED");

		/**
		 * This type of event is emitted when the user deletes text from the
		 * widget
		 */	
		public static final Type DELETE_TEXT = new Type(2, "DELETE_TEXT");
		/**
		 * This type of event is emitted when the user inserts text into the
		 * widget.
		 */	
		public static final Type INSERT_TEXT = new Type(2, "INSERT_TEXT");
	}
	
	/**
	 * The starting position of the deleted text.  Applies to the DELETE_TEXT
	 * type of event.
	 */
	private int startPosition;
	
	/**
	 * The ending position of the deleted text.  Applies to the DELETE_TEXT
	 * type of event.
	 */
	private int endPosition;
	
	/**
	 * The text that was inserted into the widget.  Applies to the INSERT_TEXT
	 * type of event.
	 */
	private String text;
	
	/**
	 * The position at which the next text was inserted.  Applies to the
	 * INSERT_TEXT type of event.
	 */
	private int insertPosition;

	/**
	 * Constructor for EditableEvent.
	 * @param source
	 * @param type
	 */
	public EditableEvent(Object source, GtkEventType type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(EditableEvent.Type aType){
		return ( type.getID() == aType.getID());
	}
	/**
	 * Returns the endPosition.
	 * @return int
	 */
	public int getEndPosition() {
		return endPosition;
	}

	/**
	 * Returns the insertPosition.
	 * @return int
	 */
	public int getInsertPosition() {
		return insertPosition;
	}

	/**
	 * Returns the startPosition.
	 * @return int
	 */
	public int getStartPosition() {
		return startPosition;
	}

	/**
	 * Returns the text.
	 * @return String
	 */
	public String getText() {
		return text;
	}

	/**
	 * Sets the endPosition.
	 * @param endPosition The endPosition to set
	 */
	public void setEndPosition(int endPosition) {
		this.endPosition = endPosition;
	}

	/**
	 * Sets the insertPosition.
	 * @param insertPosition The insertPosition to set
	 */
	public void setInsertPosition(int insertPosition) {
		this.insertPosition = insertPosition;
	}

	/**
	 * Sets the startPosition.
	 * @param startPosition The startPosition to set
	 */
	public void setStartPosition(int startPosition) {
		this.startPosition = startPosition;
	}

	/**
	 * Sets the text.
	 * @param text The text to set
	 */
	public void setText(String text) {
		this.text = text;
	}

}
