/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:35 EDT
 */

package org.gnu.gtk;
import java.util.Vector;

import org.gnu.glib.EventMap;
import org.gnu.glib.Type;
import org.gnu.gtk.event.EditableEvent;
import org.gnu.gtk.event.EditableListener;
import org.gnu.gtk.event.GtkEventType;

/**
 * The Editable class is the base class for widgets for editing text,
 * such as Entry.  It cannot be instantiated by itself.
 * The editable class contains functions for generically manipulating
 * an editable widget, a large number of action events used for key
 * bindings, and several events that an application can connect to to
 * modify the behavior of a widget.
 */
public class Editable extends Widget {
	protected Editable() {
	}

	protected Editable(int handle) {
		super(handle);
	}

	protected void noopInit() {
	}

	/**
	 * Select a region of text.  The characters that are selected are
	 * those characters at positions from <i>start</i> up to, but not
	 * including <i>end</i>.  If <i>end</i> is negative, then the
	 * characters selected will be those characters from <i>start</i>
	 * to the end of the text
	 */
	public void selectRegion(int start, int end) {
		gtk_editable_select_region(handle, start, end);
	}

	// REDTAG: getSelectionBounds

	/**
	 * Insert text at a given point
	 * @param text The text to insert.
	 * @param offset The offset into the buffer to begin the insert.
	 * @return The current offset after the text has been inserted.
	 */
	public int insertText(String text, int offset) {
		int[] ptr = new int[1];
		ptr[0] = offset;
		gtk_editable_insert_text(handle, text, text.length(), ptr);
		return ptr[0];
	}

	/**
	 * Delete a sequence of characters.  The characters that are deleted are 
	 * those characters from position <i>start</i> up to, but not including
	 * <i>end</i>.  If <i>end</i> is a negative number then the characters
	 * to be deleted are from <i>start</i> until the end of the text.
	 */
	public void deleteText(int start, int end) {
		gtk_editable_delete_text(handle, start, end);
	}

	/**
	 * Retrieve a sequence of characters.  The characters that are retrieved
	 * are those characters from position <i>start</i> up to, but not including
	 * <i>end</i>.  If <i>end</i> is negative, then the characters retrieved
	 * will be those characters from <i>start</i> until the end of the text.
	 */
	public String getCharacters(int start, int end) {
		return gtk_editable_get_chars(handle, start, end);
	}

	/**
	 * Causes the characters in the current selection to be copied to the
	 * clipboard and then deleted from the widget.
	 */
	public void cutClipboard() {
		gtk_editable_cut_clipboard(handle);
	}

	/**
	 * Causes the characters in the current selection to be copied to the
	 * clipboard.
	 */
	public void copyClipboard() {
		gtk_editable_copy_clipboard(handle);
	}

	/**
	 * Causes the contents of the clipboard to be pasted into this widget
	 * at the current cursor position.
	 */
	public void pasteClipboard() {
		gtk_editable_paste_clipboard(handle);
	}

	/**
	 * Deletes the contents of the current selection.
	 */
	public void deleteSelection() {
		gtk_editable_delete_selection(handle);
	}

	/**
	 * Sets the cursor position
	 * @param position The position of the cursor.  The cursor is displayed
	 * before the character with the given (base 0) index in the widget.  The
	 * value must be less than or equal to the number of characters in the widget.
	 */
	public void setCursorPosition(int position) {
		gtk_editable_set_position(handle, position);
	}

	/**
	 * Retrieves the current cursor position.
	 * @return A 0 based integer that identifies the offset position of the
	 * cursor from the beginning of the text.
	 */
	public int getCursorPosition() {
		return gtk_editable_get_position(handle);
	}

	/**
	 * Determines if the user can edit the text contained in the widget.
	 * @param isEditable true if the user can edit the text.
	 */
	public void setEditable(boolean isEditable) {
		gtk_editable_set_editable(handle, isEditable);
	}

	/**
	 * Retrieves whether the text contained in the widget is editable.
	 * @return true if the text is editable.
	 */
	public boolean getEditable() {
		return gtk_editable_get_editable(handle);
	}

	/****************************************
	 * Event Handling
	 ****************************************/
	/** Listeners for handling Editable events */
	private Vector editableListeners = null;

	/**
	 * Register an object to handle spin events.
	 * @see org.gnu.gtk.event.EditableListener
	 */
	public void addListener(EditableListener listener) {
		// Don't add the listener a second time if it is in the Vector.
		int i = findListener(editableListeners, listener);
		if (i == -1) {
			if (null == editableListeners)
				editableListeners = new Vector();
			editableListeners.addElement(listener);
		}
	}
	/**
	 * Removes a listener
	 * @see #addListener(EditableListener)
	 */
	public void removeListener(EditableListener listener) {
		int i = findListener(editableListeners, listener);
		if (i > -1)
			editableListeners.remove(i);
		if (0 == editableListeners.size())
			editableListeners = null;
	}

	protected void fireEditableEvent(EditableEvent event) {
		if (null == editableListeners)
			return;
		int size = editableListeners.size();
		int i = 0;
		while (i < size) {
			EditableListener el = (EditableListener)editableListeners.elementAt(i);
			el.editableEvent(event);
			i++;
		}
	}

	private void handleChanged() {
		fireEditableEvent(new EditableEvent(this, EditableEvent.Type.CHANGED));
	}

	private void handleDeleteText(int start, int end) {
		EditableEvent ee = new EditableEvent(this, EditableEvent.Type.DELETE_TEXT);
		ee.setStartPosition(start);
		ee.setEndPosition(end);
		fireEditableEvent(ee);
	}

	private void handleInsertText(String text, int length, int position) {
		EditableEvent ee = new EditableEvent(this, EditableEvent.Type.INSERT_TEXT);
		ee.setText(text);
		ee.setInsertPosition(position);
		fireEditableEvent(ee);
	}

	protected void initializeEventHandlers() {
		super.initializeEventHandlers();
		evtMap.initialize(this);
	}

	public Class getEventListenerClass(String signal) {
		return evtMap.getListenerClass(signal);
	}

	public GtkEventType getEventType(String signal) {
		return evtMap.getEventType(signal);
	}

	private static EventMap evtMap = new EventMap();
	static {
		addEvents(evtMap);
	}

	/**
	* Implementation method to build an EventMap for this widget class.
	* Not useful (or supported) for application use.
	*/
	private static void addEvents(EventMap anEvtMap) {
		anEvtMap.addEvent("changed", "handleChanged", EditableEvent.Type.CHANGED, EditableListener.class);
		anEvtMap.addEvent("delete_text", "handleDeleteText", EditableEvent.Type.DELETE_TEXT, EditableListener.class);
		anEvtMap.addEvent("insert_text", "handleInsertText", EditableEvent.Type.INSERT_TEXT, EditableListener.class);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_editable_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_editable_get_type();
	native static final protected void gtk_editable_select_region(int editable, int start, int end);
	native static final protected boolean gtk_editable_get_selection_bounds(int editable, int[] start, int[] end);
	native static final protected void gtk_editable_insert_text(
		int editable,
		String newText,
		int newTextLength,
		int[] position);
	native static final protected void gtk_editable_delete_text(int editable, int startPos, int endPos);
	native static final protected String gtk_editable_get_chars(int editable, int start, int end);
	native static final protected void gtk_editable_cut_clipboard(int editable);
	native static final protected void gtk_editable_copy_clipboard(int editable);
	native static final protected void gtk_editable_paste_clipboard(int editable);
	native static final protected void gtk_editable_delete_selection(int editable);
	native static final protected void gtk_editable_set_position(int editable, int position);
	native static final protected int gtk_editable_get_position(int editable);
	native static final protected void gtk_editable_set_editable(int editable, boolean isEditable);
	native static final protected boolean gtk_editable_get_editable(int editable);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
