// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_CONTAINER_H
#define _GTKMM_CONTAINER_H

#include <glibmm.h>

/* $Id: container.hg,v 1.4 2003/05/07 05:13:49 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <glibmm/listhandle.h>
#include <gtkmm/widget.h>


/** @defgroup Containers Container Widgets
 * These widgets can be used to group other widgets together.
 */

/* we'll include gtkfeatures because we dont want to include the whole
   gtk/gtk.h - this file is used by almost ALL our widgets, so dependencies
   in minimum - adding things here will increase compile times ALOT */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkContainer GtkContainer;
typedef struct _GtkContainerClass GtkContainerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Container_Class; } // namespace Gtk
namespace Gtk
{

class Adjustment;
class Label;

/** Abstract container class
 *
 * This is the abstract container from which all gtk+ widgets which hold
 * other items derive from.  It mainly houses virtual functions
 * used for inserting and removing children.  Containers in gtk+
 * may hold one item or many items depending on the implementation.
 *
 * This interface is used for all single item holding containers.
 * Multi-item containers provide their own unique interface as their
 * items are generally more complex.  The methods of the derived
 * classes should be prefered over these.
 *
 * @ingroup Widgets
 */

class Container : public Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Container CppObjectType;
  typedef Container_Class CppClassType;
  typedef GtkContainer BaseObjectType;
  typedef GtkContainerClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Container();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Container_Class;
  static CppClassType container_class_;

  // noncopyable
  Container(const Container&);
  Container& operator=(const Container&);

protected:
  explicit Container(const Glib::ConstructParams& construct_params);
  explicit Container(GtkContainer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkContainer*       gobj()       { return reinterpret_cast<GtkContainer*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkContainer* gobj() const { return reinterpret_cast<GtkContainer*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
  virtual GtkType child_type_vfunc();
  virtual void forall_vfunc(gboolean include_internals, GtkCallback callback, gpointer callback_data);
  virtual char* composite_name_vfunc(GtkWidget* child);
  virtual void set_child_property_vfunc(GtkWidget* child, guint property_id, const GValue* value, GParamSpec* pspec);
  virtual void get_child_property_vfunc(GtkWidget* child, guint property_id, GValue* value, GParamSpec* pspec);

  //Default Signal Handlers::
  virtual void on_add(Widget* widget);
  virtual void on_remove(Widget* widget);
  virtual void on_check_resize();
  virtual void on_set_focus_child(Widget* widget);


private:

  
public:

/* Application-level methods */

  
  void set_border_width(guint border_width);

  
  guint get_border_width() const;

  //This is virtual so that we can override it in Gtk::ScrolledWindow:
 virtual void add(Widget& widget);
  

  void remove(Widget& widget);

  
  void set_resize_mode(ResizeMode resize_mode);

  
  ResizeMode get_resize_mode() const;

  /// Request that contained widgets check their size
  
  void check_resize();

  typedef SigC::Slot1<void, Widget&> ForeachSlot;

  /** Operate on contained items
   * This is largely an internal used mainly for things like
   * creating duplicates of internal lists and other such
   * operations.  The result is lossy as it only gets the
   * the main child and not its external pieces.
   *
   * For example notebook pages contain a page, a label, and
   * a menu item.  But this only operates on the pages.
   */
  void foreach(const ForeachSlot& slot);

  /// (internal) Operate on contained items (see foreach())
  //_WRAP_METHOD(void foreach_(GtkCallback callback,gpointer data),gtk_container_foreach)

  /// (internal) Operate on contained items (see foreach())
  //_WRAP_METHOD(void foreach_full_(GtkCallback callback,GtkCallbackMarshal marshal, gpointer data,GtkDestroyNotify notify),gtk_container_foreach_full)

  
  Glib::ListHandle<Widget*> get_children();
  
  Glib::ListHandle<const Widget*> get_children() const;

  
  void propagate_expose(Widget& child, GdkEventExpose* event);

  
  void set_focus_chain(const Glib::ListHandle<Widget*>& focusable_widgets);

  // gtk_container_get_focus_chain() has been split up into two
  // functions in order to make implicit container conversion possible.
  bool has_focus_chain() const;
  Glib::ListHandle<Widget*> get_focus_chain();
  Glib::ListHandle<const Widget*> get_focus_chain() const;

  
  void unset_focus_chain();


/* Widget-level methods */

  
  void set_reallocate_redraws(bool needs_redraws = true);

  /// Sets the focus on a child
  
  void set_focus_child(Widget& widget);

  
  void set_focus_vadjustment(Adjustment& adjustment);

  
  Adjustment* get_focus_vadjustment();
  
  const Adjustment* get_focus_vadjustment() const;

  
  void set_focus_hadjustment(Adjustment& adjustment);

  
  Adjustment* get_focus_hadjustment();
  
  const Adjustment* get_focus_hadjustment() const;


  void resize_children();
  
  
  GType child_type() const;

  // Ignore functions such as gtk_container_class_install_child_property(),  which I think are for themes, like the GtkWidget style properties.
  

  /**
   * @par Prototype:
   * <tt>void %add(Widget* widget)</tt>
   */
  Glib::SignalProxy1< void,Widget* > signal_add();

  
  /**
   * @par Prototype:
   * <tt>void %remove(Widget* widget)</tt>
   */
  Glib::SignalProxy1< void,Widget* > signal_remove();

  
  /**
   * @par Prototype:
   * <tt>void %check_resize()</tt>
   */
  Glib::SignalProxy0< void > signal_check_resize();

  
  /**
   * @par Prototype:
   * <tt>void %set_focus_child(Widget* widget)</tt>
   */
  Glib::SignalProxy1< void,Widget* > signal_set_focus_child();


  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<guint> property_border_width();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<ResizeMode> property_resize_mode();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy_WriteOnly<Widget*> property_child();


  void show_all_children(bool recursive = true);

protected:
  Container();


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Container */
  Gtk::Container* wrap(GtkContainer* object, bool take_copy = false);
}
#endif /* _GTKMM_CONTAINER_H */

