// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_OUTPUTSTREAM_H
#define _GIOMM_OUTPUTSTREAM_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>

#include <glibmm/object.h>
#include <giomm/asyncresult.h>
#include <giomm/cancellable.h>
#include <giomm/inputstream.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GOutputStream GOutputStream;
typedef struct _GOutputStreamClass GOutputStreamClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class OutputStream_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums Enums and Flags */

/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%OutputStreamSpliceFlags operator|(OutputStreamSpliceFlags, OutputStreamSpliceFlags)</tt><br>
 * <tt>%OutputStreamSpliceFlags operator&(OutputStreamSpliceFlags, OutputStreamSpliceFlags)</tt><br>
 * <tt>%OutputStreamSpliceFlags operator^(OutputStreamSpliceFlags, OutputStreamSpliceFlags)</tt><br>
 * <tt>%OutputStreamSpliceFlags operator~(OutputStreamSpliceFlags)</tt><br>
 * <tt>%OutputStreamSpliceFlags& operator|=(OutputStreamSpliceFlags&, OutputStreamSpliceFlags)</tt><br>
 * <tt>%OutputStreamSpliceFlags& operator&=(OutputStreamSpliceFlags&, OutputStreamSpliceFlags)</tt><br>
 * <tt>%OutputStreamSpliceFlags& operator^=(OutputStreamSpliceFlags&, OutputStreamSpliceFlags)</tt><br>
 */
enum OutputStreamSpliceFlags
{
  OUTPUT_STREAM_SPLICE_NONE = 0,
  OUTPUT_STREAM_SPLICE_CLOSE_SOURCE = 1 << 0,
  OUTPUT_STREAM_SPLICE_CLOSE_TARGET = 1 << 1
};

/** @ingroup giommEnums */
inline OutputStreamSpliceFlags operator|(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)
  { return static_cast<OutputStreamSpliceFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline OutputStreamSpliceFlags operator&(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)
  { return static_cast<OutputStreamSpliceFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline OutputStreamSpliceFlags operator^(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)
  { return static_cast<OutputStreamSpliceFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline OutputStreamSpliceFlags operator~(OutputStreamSpliceFlags flags)
  { return static_cast<OutputStreamSpliceFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline OutputStreamSpliceFlags& operator|=(OutputStreamSpliceFlags& lhs, OutputStreamSpliceFlags rhs)
  { return (lhs = static_cast<OutputStreamSpliceFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline OutputStreamSpliceFlags& operator&=(OutputStreamSpliceFlags& lhs, OutputStreamSpliceFlags rhs)
  { return (lhs = static_cast<OutputStreamSpliceFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline OutputStreamSpliceFlags& operator^=(OutputStreamSpliceFlags& lhs, OutputStreamSpliceFlags rhs)
  { return (lhs = static_cast<OutputStreamSpliceFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** Base class for implementing streaming output.
 *
 * @newin2p16
 */

class OutputStream : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef OutputStream CppObjectType;
  typedef OutputStream_Class CppClassType;
  typedef GOutputStream BaseObjectType;
  typedef GOutputStreamClass BaseClassType;

private:  friend class OutputStream_Class;
  static CppClassType outputstream_class_;

private:
  // noncopyable
  OutputStream(const OutputStream&);
  OutputStream& operator=(const OutputStream&);

protected:
  explicit OutputStream(const Glib::ConstructParams& construct_params);
  explicit OutputStream(GOutputStream* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~OutputStream();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GOutputStream*       gobj()       { return reinterpret_cast<GOutputStream*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GOutputStream* gobj() const { return reinterpret_cast<GOutputStream*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GOutputStream* gobj_copy();

private:


public:
  
  /** Tries to write @a count  bytes from @a buffer  into the stream. Will block
   * during the operation.
   * 
   * If count is zero returns zero and does nothing. A value of @a count 
   * larger than G::MAXSSIZE will cause a G::IO_ERROR_INVALID_ARGUMENT error.
   * 
   * On success, the number of bytes written to the stream is returned.
   * It is not an error if this is not the same as the requested size, as it
   * can happen e.g. on a partial i/o error, or if the there is not enough
   * storage in the stream. All writes either block until at least one byte
   * is written, so zero is never returned (unless @a count  is zero).
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G_IO_ERROR_CANCELLED will be returned. If an
   * operation was partially finished when the operation was cancelled the
   * partial result will be returned, without an error.
   * 
   * On error -1 is returned and @a error  is set accordingly.
   * @param buffer The buffer containing the data to write.
   * @param count The number of bytes to write.
   * @param cancellable Optional cancellable object.
   * @param error Location to store the error occuring, or <tt>0</tt> to ignore.
   * @return Number of bytes written, or -1 on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize write(const void* buffer, gsize count, const Glib::RefPtr<Cancellable>& cancellable);
#else
  gssize write(const void* buffer, gsize count, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Tries to write @a count  bytes from @a buffer  into the stream. Will block
   * during the operation.
   * 
   * This function is similar to g_output_stream_write(), except it tries to
   * write as many bytes as requested, only stopping on an error.
   * 
   * On a successful write of @a count  bytes, <tt>true</tt> is returned, and @a bytes_written 
   * is set to @a count .
   * 
   * If there is an error during the operation <tt>false</tt> is returned and @a error 
   * is set to indicate the error status, @a bytes_written  is updated to contain
   * the number of bytes written into the stream before the error occured.
   * @param buffer The buffer containing the data to write.
   * @param count The number of bytes to write.
   * @param bytes_written Location to store the number of bytes that was 
   * written to the stream.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error Location to store the error occuring, or <tt>0</tt> to ignore.
   * @return <tt>true</tt> on success, <tt>false</tt> if there was an error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool write_all(const void* buffer, gsize count, gsize& bytes_written, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool write_all(const void* buffer, gsize count, gsize& bytes_written, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Splices an input stream into an output stream.
   * @param source A G::InputStream.
   * @param flags A set of G::OutputStreamSpliceFlags.
   * @param cancellable Optional G::Cancellable object, <tt>0</tt> to ignore.
   * @param error A G::Error location to store the error occuring, or <tt>0</tt> to 
   * ignore.
   * @return A #gssize containig the size of the data spliced.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize splice(const Glib::RefPtr<InputStream>& source, OutputStreamSpliceFlags flags, const Glib::RefPtr<Cancellable>& cancellable);
#else
  gssize splice(const Glib::RefPtr<InputStream>& source, OutputStreamSpliceFlags flags, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Flushed any outstanding buffers in the stream. Will block during 
   * the operation. Closing the stream will implicitly cause a flush.
   * 
   * This function is optional for inherited classes.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * @param cancellable Optional cancellable object.
   * @param error Location to store the error occuring, or <tt>0</tt> to ignore.
   * @return <tt>true</tt> on success, <tt>false</tt> on error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool flush(const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool flush(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Closes the stream, releasing resources related to it.
   * 
   * Once the stream is closed, all other operations will return G::IO_ERROR_CLOSED.
   * Closing a stream multiple times will not return an error.
   * 
   * Closing a stream will automatically flush any outstanding buffers in the
   * stream.
   * 
   * Streams will be automatically closed when the last reference
   * is dropped, but you might want to call make sure resources
   * are released as early as possible.
   * 
   * Some streams might keep the backing store of the stream (e.g. a file descriptor)
   * open after the stream is closed. See the documentation for the individual
   * stream for details.
   * 
   * On failure the first error that happened will be reported, but the close
   * operation will finish as much as possible. A stream that failed to
   * close will still return G::IO_ERROR_CLOSED all operations. Still, it
   * is important to check and report the error to the user, otherwise
   * there might be a loss of data as all data might not be written.
   * 
   * If @a cancellable  is not <tt>0</tt>, then the operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, the error G::IO_ERROR_CANCELLED will be returned.
   * Cancelling a close will still leave the stream closed, but there some streams
   * can use a faster close that doesn't block to e.g. check errors. On
   * cancellation (as with any error) there is no guarantee that all written
   * data will reach the target.
   * @param cancellable Optional cancellable object.
   * @param error Location to store the error occuring, or <tt>0</tt> to ignore.
   * @return <tt>true</tt> on success, <tt>false</tt> on failure.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool close(const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool close(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  void write_async(const void* buffer, gsize count, int io_priority, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot);

  
  /** Finishes a stream write operation.
   * @param result A G::AsyncResult.
   * @param error A G::Error location to store the error occuring, or <tt>0</tt> to 
   * ignore.
   * @return A #gssize containing the number of bytes written to the stream.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize write_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  gssize write_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  void splice_async(const Glib::RefPtr<InputStream>& source, OutputStreamSpliceFlags flags, int io_priority, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot);

  
  /** Finishes an asynchronous stream splice operation.
   * @param result A G::AsyncResult.
   * @param error A G::Error location to store the error occuring, or <tt>0</tt> to 
   * ignore.
   * @return A #gssize of the number of bytes spliced.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gssize splice_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  gssize splice_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  void flush_async(int io_priority, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot);

  
  /** Finishes flushing an output stream.
   * @param result A GAsyncResult.
   * @param error A G::Error location to store the error occuring, or <tt>0</tt> to 
   * ignore.
   * @return <tt>true</tt> if flush operation suceeded, <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool flush_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  bool flush_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  void close_async(int io_priority, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot);

  
  /** Closes an output stream.
   * @param result A G::AsyncResult.
   * @param error A G::Error location to store the error occuring, or <tt>0</tt> to 
   * ignore.
   * @return <tt>true</tt> if stream was successfully closed, <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool close_finish(const Glib::RefPtr<AsyncResult>& result);
#else
  bool close_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Checks if an output stream has already been closed.
   * @return <tt>true</tt> if @a stream  is closed. <tt>false</tt> otherwise.
   */
  bool is_closed() const;
  
  /** Checks if an ouput stream has pending actions.
   * @return <tt>true</tt> if @a stream  has pending actions.
   */
  bool has_pending() const;

  //TODO: _WRAP_METHOD(bool set_pending(), g_output_stream_set_pending, errthrow)

  //TODO: vfuncs and overloads without Cancellable


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::OutputStream
   */
  Glib::RefPtr<Gio::OutputStream> wrap(GOutputStream* object, bool take_copy = false);
}


#endif /* _GIOMM_OUTPUTSTREAM_H */

