/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.glib.Handle;

/**
 * 
 */
public class EventConfigure extends Event {
    /**
     * Promotion constructor. Construct the specific event object by promoting
     * (sharing the <tt>Handle</tt> object of) the base <tt>Event</tt>.
     */
    public EventConfigure(Event evt) {
        // We share the handle with both instances. This avoids
        // copying the event (via the constructor ( super( evt ) ).
        // It is more of a "promotion" constructor.
        super(evt.getHandle());
    }

    public EventConfigure(Handle handle) {
        super(handle);
    }

    public Window getWindow() {
        return Window.getWindowFromHandle(getWindow(getHandle()));
    }

    public int getX() {
        return getX(getHandle());
    }

    public int getY() {
        return getY(getHandle());
    }

    public int getWidth() {
        return getWidth(getHandle());
    }

    public int getHeight() {
        return getHeight(getHandle());
    }

    public boolean getSendEvent() {
        return getSendEvent(getHandle());
    }

    native static final protected Handle getWindow(Handle obj);

    native static final protected boolean getSendEvent(Handle obj);

    native static final protected int getX(Handle obj);

    native static final protected int getY(Handle obj);

    native static final protected int getWidth(Handle obj);

    native static final protected int getHeight(Handle obj);
}
