/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import java.awt.GridBagLayout;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.junit.jupiter.api.Test;

public class GridBagLayoutConverterTest
extends AbstractGridBagLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_empty() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tsetLayout(null);\n\t}\n}");
        panel.refresh();
        GridBagLayoutConverterTest.setLayout(panel, GridBagLayout.class);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tgridBagLayout.columnWidths = new int[]{0};\n\t\tgridBagLayout.rowHeights = new int[]{0};\n\t\tgridBagLayout.columnWeights = new double[]{Double.MIN_VALUE};\n\t\tgridBagLayout.rowWeights = new double[]{Double.MIN_VALUE};\n\t\tsetLayout(gridBagLayout);\n\t}\n}");
    }

    @Test
    public void test_oneColumn() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tbutton_0.setBounds(4, 10, 100, 30);\n\t\t\tadd(button_0);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tbutton_1.setBounds(10, 50, 80, 20);\n\t\t\tadd(button_1);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutConverterTest.setLayout(panel, GridBagLayout.class);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tgridBagLayout.columnWidths = new int[]{100, 0};\n\t\tgridBagLayout.rowHeights = new int[]{30, 20, 0};\n\t\tgridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\tgridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t}\n}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutConverterTest.assertEquals((int)1, (int)layout.getColumns().size());
        GridBagLayoutConverterTest.assertEquals((int)2, (int)layout.getRows().size());
    }

    @Test
    public void test_oneColumn_left() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tbutton_0.setBounds(4, 10, 100, 30);\n\t\t\tadd(button_0);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tbutton_1.setBounds(5, 50, 60, 20);\n\t\t\tadd(button_1);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutConverterTest.setLayout(panel, GridBagLayout.class);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tgridBagLayout.columnWidths = new int[]{100, 0};\n\t\tgridBagLayout.rowHeights = new int[]{30, 20, 0};\n\t\tgridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\tgridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.anchor = GridBagConstraints.WEST;\n\t\t\tgbc.fill = GridBagConstraints.VERTICAL;\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t}\n}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutConverterTest.assertEquals((int)1, (int)layout.getColumns().size());
        GridBagLayoutConverterTest.assertEquals((int)2, (int)layout.getRows().size());
    }

    @Test
    public void test_oneRow() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tbutton_0.setBounds(4, 10, 100, 30);\n\t\t\tadd(button_0);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tbutton_1.setBounds(120, 13, 80, 15);\n\t\t\tadd(button_1);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutConverterTest.setLayout(panel, GridBagLayout.class);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tgridBagLayout.columnWidths = new int[]{100, 80, 0};\n\t\tgridBagLayout.rowHeights = new int[]{30, 0};\n\t\tgridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};\n\t\tgridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.HORIZONTAL;\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t}\n}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutConverterTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagLayoutConverterTest.assertEquals((int)1, (int)layout.getRows().size());
    }

    @Test
    public void test_oneRow_top() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tbutton_0.setBounds(4, 10, 100, 50);\n\t\t\tadd(button_0);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tbutton_1.setBounds(120, 11, 80, 20);\n\t\t\tadd(button_1);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutConverterTest.setLayout(panel, GridBagLayout.class);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tgridBagLayout.columnWidths = new int[]{100, 80, 0};\n\t\tgridBagLayout.rowHeights = new int[]{50, 0};\n\t\tgridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};\n\t\tgridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.anchor = GridBagConstraints.NORTH;\n\t\t\tgbc.fill = GridBagConstraints.HORIZONTAL;\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t}\n}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutConverterTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagLayoutConverterTest.assertEquals((int)1, (int)layout.getRows().size());
    }

    @Test
    public void test_oneRow_bottom() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tbutton_0.setBounds(4, 10, 100, 50);\n\t\t\tadd(button_0);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tbutton_1.setBounds(120, 38, 80, 20);\n\t\t\tadd(button_1);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutConverterTest.setLayout(panel, GridBagLayout.class);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tgridBagLayout.columnWidths = new int[]{100, 80, 0};\n\t\tgridBagLayout.rowHeights = new int[]{50, 0};\n\t\tgridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};\n\t\tgridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.anchor = GridBagConstraints.SOUTH;\n\t\t\tgbc.fill = GridBagConstraints.HORIZONTAL;\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t}\n}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutConverterTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagLayoutConverterTest.assertEquals((int)1, (int)layout.getRows().size());
    }

    @Test
    public void test_oneRow_reorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tbutton_1.setBounds(120, 13, 80, 18);\n\t\t\tadd(button_1);\n\t\t}\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tbutton_0.setBounds(4, 10, 100, 30);\n\t\t\tadd(button_0);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutConverterTest.setLayout(panel, GridBagLayout.class);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tgridBagLayout.columnWidths = new int[]{100, 80, 0};\n\t\tgridBagLayout.rowHeights = new int[]{30, 0};\n\t\tgridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};\n\t\tgridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.HORIZONTAL;\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t}\n}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutConverterTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagLayoutConverterTest.assertEquals((int)1, (int)layout.getRows().size());
    }

    @Test
    public void test_Switching_fromGridLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout(3, 3, 0, 0));\n\t\t{\n\t\t\tJLabel label = new JLabel(\"New label\");\n\t\t\tadd(label);\n\t\t}\n\t\t{\n\t\t\tJTextField textField = new JTextField();\n\t\t\tadd(textField);\n\t\t\ttextField.setColumns(10);\n\t\t}\n\t\t{\n\t\t\tJTextArea textArea = new JTextArea();\n\t\t\tadd(textArea);\n\t\t}\n\t\t{\n\t\t\tJCheckBox checkBox = new JCheckBox(\"New check box\");\n\t\t\tadd(checkBox);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutConverterTest.setLayout(panel, GridBagLayout.class);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tgridBagLayout.columnWidths = new int[]{225, 225, 0};\n\t\tgridBagLayout.rowHeights = new int[]{100, 100, 100, 0};\n\t\tgridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};\n\t\tgridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJLabel label = new JLabel(\"New label\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(label, gbc);\n\t\t}\n\t\t{\n\t\t\tJTextField textField = new JTextField();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(textField, gbc);\n\t\t\ttextField.setColumns(10);\n\t\t}\n\t\t{\n\t\t\tJTextArea textArea = new JTextArea();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(textArea, gbc);\n\t\t}\n\t\t{\n\t\t\tJCheckBox checkBox = new JCheckBox(\"New check box\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(checkBox, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 2;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_reorderOnConvert_lazy() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tprivate JButton buttonA;\n\tprivate JButton buttonB;\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\tadd(getButtonA());\n\t\tadd(getButtonB());\n\t}\n\tprivate JButton getButtonA() {\n\t\tif (buttonA == null) {\n\t\t\tbuttonA = new JButton();\n\t\t\tbuttonA.setBounds(200, 200, 50, 25);\n\t\t}\n\t\treturn buttonA;\n\t}\n\tprivate JButton getButtonB() {\n\t\tif (buttonB == null) {\n\t\t\tbuttonB = new JButton();\n\t\t\tbuttonB.setBounds(0, 0, 50, 25);\n\t\t}\n\t\treturn buttonB;\n\t}\n}");
        panel.refresh();
        GridBagLayoutConverterTest.setLayout(panel, GridBagLayout.class);
        this.assertEditor("class Test extends JPanel {\n\tprivate JButton buttonA;\n\tprivate JButton buttonB;\n\tpublic Test() {\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tgridBagLayout.columnWidths = new int[]{50, 150, 50, 0};\n\t\tgridBagLayout.rowHeights = new int[]{25, 175, 25, 0};\n\t\tgridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};\n\t\tgridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};\n\t\tsetLayout(gridBagLayout);\n\t\tGridBagConstraints gbc_1 = new GridBagConstraints();\n\t\tgbc_1.fill = GridBagConstraints.BOTH;\n\t\tgbc_1.insets = new Insets(0, 0, 5, 5);\n\t\tgbc_1.gridx = 0;\n\t\tgbc_1.gridy = 0;\n\t\tadd(getButtonB(), gbc_1);\n\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\tgbc.gridx = 2;\n\t\tgbc.gridy = 2;\n\t\tadd(getButtonA(), gbc);\n\t}\n\tprivate JButton getButtonA() {\n\t\tif (buttonA == null) {\n\t\t\tbuttonA = new JButton();\n\t\t}\n\t\treturn buttonA;\n\t}\n\tprivate JButton getButtonB() {\n\t\tif (buttonB == null) {\n\t\t\tbuttonB = new JButton();\n\t\t}\n\t\treturn buttonB;\n\t}\n}");
    }
}

