/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.layout.form;

import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.swt.model.layout.LayoutDataInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormAttachmentInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormDataInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplAutomatic;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class FormLayoutModelsTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_emptyGlobalState() throws Exception {
        this.parseComposite("public class Test {", "  public Test(Composite parent) {", "    FormLayout formLayout = new FormLayout();", "    Composite composite = new Composite(parent, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_attachWidgetSequientially() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    Button button = new Button(this, SWT.NONE);", "    {", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 50);", "      button.setLayoutData(data);", "    }", "    {", "      Button button2 = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.right = new FormAttachment(100, -10);", "      button2.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button2 = (ControlInfo)shell.getChildrenControls().get(1);
        ((FormLayoutInfoImplAutomatic)layout.getImpl()).attachWidgetSequientially((IAbstractComponentInfo)button2, (IAbstractComponentInfo)button, 1, 6);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    Button button = new Button(this, SWT.NONE);", "    {", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 50);", "      button.setLayoutData(data);", "    }", "    {", "      Button button2 = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(button, 6);", "      data.right = new FormAttachment(100, -10);", "      button2.setLayoutData(data);", "    }", "  }", "}");
        FormLayoutModelsTest.assertTrue((((FormLayoutInfoImplAutomatic)layout.getImpl()).getAttachedToWidget((IAbstractComponentInfo)button2, 1) == button ? 1 : 0) != 0);
        FormDataInfo formData = FormLayoutInfo.getFormData((ControlInfo)button2);
        FormAttachmentInfo attachment = formData.getAttachment(1);
        FormLayoutModelsTest.assertSame((Object)button, (Object)attachment.getControl());
        FormLayoutModelsTest.assertEquals((int)6, (int)attachment.getOffset());
        FormLayoutModelsTest.assertEquals((int)131072, (int)attachment.getAlignment());
    }

    @Test
    public void test_attachmentPropertyExists() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 100);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo buttonInfo = (ControlInfo)shell.getChildrenControls().get(0);
        LayoutDataInfo layoutData = LayoutInfo.getLayoutData((ControlInfo)buttonInfo);
        FormLayoutModelsTest.assertInstanceOf(FormDataInfo.class, (Object)layoutData);
        FormDataInfo formDataInfo = (FormDataInfo)layoutData;
        FormLayoutModelsTest.assertNotNull((Object)formDataInfo.getAttachment(1));
        FormLayoutModelsTest.assertNotNull((Object)formDataInfo.getAttachment(4));
        FormLayoutModelsTest.assertNotNull((Object)formDataInfo.getAttachment(8));
        FormLayoutModelsTest.assertNotNull((Object)formDataInfo.getAttachment(32));
    }

    @Test
    public void test_attachmentToParent() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 50);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo buttonInfo = (ControlInfo)shell.getChildrenControls().get(0);
        FormDataInfo formDataInfo = (FormDataInfo)LayoutInfo.getLayoutData((ControlInfo)buttonInfo);
        FormAttachmentInfo leftAttachment = formDataInfo.getAttachment(1);
        FormLayoutModelsTest.assertEquals((int)50, (int)leftAttachment.getOffset());
        FormLayoutModelsTest.assertEquals((int)0, (int)leftAttachment.getNumerator());
        FormLayoutModelsTest.assertEquals((int)100, (int)leftAttachment.getDenominator());
        FormLayoutModelsTest.assertNull((Object)leftAttachment.getControl());
    }

    @Test
    public void test_attachmentToComponent() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    Button button = new Button(this, SWT.NONE);", "    {", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 50);", "      button.setLayoutData(data);", "    }", "    {", "      Button button2 = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(button, 6);", "      button2.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo buttonInfo = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button2Info = (ControlInfo)shell.getChildrenControls().get(1);
        FormDataInfo formData2Info = (FormDataInfo)LayoutInfo.getLayoutData((ControlInfo)button2Info);
        FormAttachmentInfo leftAttachment2 = formData2Info.getAttachment(1);
        FormLayoutModelsTest.assertEquals((int)6, (int)leftAttachment2.getOffset());
        FormLayoutModelsTest.assertSame((Object)buttonInfo, (Object)leftAttachment2.getControl());
    }

    @Test
    public void test_isAttached() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    Button button = new Button(this, SWT.NONE);", "    {", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 50);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo buttonInfo = (ControlInfo)shell.getChildrenControls().get(0);
        FormLayoutInfo layout = (FormLayoutInfo)shell.getLayout();
        FormLayoutModelsTest.assertFalse((boolean)((FormLayoutInfoImplAutomatic)layout.getImpl()).isAttached((IAbstractComponentInfo)buttonInfo, 4));
        FormLayoutModelsTest.assertTrue((boolean)((FormLayoutInfoImplAutomatic)layout.getImpl()).isAttached((IAbstractComponentInfo)buttonInfo, 1));
    }

    @Test
    public void test_isAttachedToComponent() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    Button button = new Button(this, SWT.NONE);", "    {", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 50);", "      button.setLayoutData(data);", "    }", "    {", "      Button button2 = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(button, 6);", "      button2.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo buttonInfo = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button2Info = (ControlInfo)shell.getChildrenControls().get(1);
        FormLayoutInfo layout = (FormLayoutInfo)shell.getLayout();
        FormLayoutModelsTest.assertFalse((((FormLayoutInfoImplAutomatic)layout.getImpl()).getAttachedToWidget((IAbstractComponentInfo)buttonInfo, 1) == button2Info ? 1 : 0) != 0);
        FormLayoutModelsTest.assertTrue((((FormLayoutInfoImplAutomatic)layout.getImpl()).getAttachedToWidget((IAbstractComponentInfo)button2Info, 1) == buttonInfo ? 1 : 0) != 0);
        FormLayoutModelsTest.assertFalse((((FormLayoutInfoImplAutomatic)layout.getImpl()).getAttachedToWidget((IAbstractComponentInfo)button2Info, 4) == buttonInfo ? 1 : 0) != 0);
    }

    @Test
    public void test_delete() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 100);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        FormLayoutModelsTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FormLayout())/ /new Button(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.FormLayout} {empty} {/setLayout(new FormLayout())/}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(this, SWT.NONE)/ /button.setLayoutData(data)/}", "    {new: org.eclipse.swt.layout.FormData} {local-unique: data} {/new FormData()/ /data.left = new FormAttachment(0, 100)/ /button.setLayoutData(data)/}", "      (0, 100)", "      (none)", "      (none)", "      (none)");
        ControlInfo buttonInfo = (ControlInfo)shell.getChildrenControls().get(0);
        buttonInfo.delete();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "  }", "}");
    }

    @Test
    public void test_deleteAttachment() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 100);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)shell.getLayout();
        ControlInfo buttonInfo = (ControlInfo)shell.getChildrenControls().get(0);
        ((FormLayoutInfoImplAutomatic)layout.getImpl()).detach((IAbstractComponentInfo)buttonInfo, 1);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new FormData());", "    }", "  }", "}");
    }

    @Test
    public void test_deleteAttachmentAndAttach() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 100);", "      button.setLayoutData(data);", "    }", "  }", "}");
        shell.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)shell.getLayout();
        ControlInfo buttonInfo = (ControlInfo)shell.getChildrenControls().get(0);
        ((FormLayoutInfoImplAutomatic)layout.getImpl()).detach((IAbstractComponentInfo)buttonInfo, 1);
        ((FormLayoutInfoImplAutomatic)layout.getImpl()).attachAbsolute((IAbstractComponentInfo)buttonInfo, 1, 10);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        formData.left = new FormAttachment(0, 10);", "        button.setLayoutData(formData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_empty() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        this.setFormLayout(shell, new String[]{"// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "  }", "}"});
    }

    @Test
    public void test_changeFromGridEmpty() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "  }", "}");
        this.setFormLayout(shell, new String[]{"public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "  }", "}"});
    }

    @Test
    public void test_changeFromGridWithData() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      GridData data = new GridData();", "      button.setLayoutData(data);", "    }", "  }", "}");
        this.setFormLayout(shell, new String[]{"public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        formData.top = new FormAttachment(0, 5);", "        formData.left = new FormAttachment(0, 5);", "        button.setLayoutData(formData);", "      }", "    }", "  }", "}"});
    }

    @Test
    public void test_changeFromAbsolute() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(15, 20, 50, button.computeSize(-1, -1).y);", "    }", "  }", "}");
        this.setFormLayout(shell, new String[]{"public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        formData.right = new FormAttachment(0, 65);", "        formData.top = new FormAttachment(0, 20);", "        formData.left = new FormAttachment(0, 15);", "        button.setLayoutData(formData);", "      }", "    }", "  }", "}"});
    }

    @Test
    public void test_changeToGridWithData() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 0);", "      button.setLayoutData(data);", "    }", "  }", "}");
        this.setGridLayout(shell, new String[]{"public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}"});
    }

    @Test
    public void test_FormAttachment_getAlignment_returnRealAlignmentForDefault() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button_1;", "  private Button button_2;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      button_2 = new Button(this, SWT.NONE);", "      {", "        FormData data_2 = new FormData();", "        data_2.left = new FormAttachment(button_1, 5);", "        button_2.setLayoutData(data_2);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        FormDataInfo formData = FormLayoutInfo.getFormData((ControlInfo)button_2);
        FormAttachmentInfo attachment = formData.getAttachment(1);
        FormLayoutModelsTest.assertSame((Object)button_1, (Object)attachment.getControl());
        FormLayoutModelsTest.assertEquals((int)5, (int)attachment.getOffset());
        FormLayoutModelsTest.assertEquals((int)131072, (int)attachment.getAlignment());
    }

    @Test
    public void test_setExplicitSize() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button_1;", "  private Button button_2;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button_1 = new Button(this, SWT.NONE);", "      {", "        FormData data_1 = new FormData();", "        data_1.left = new FormAttachment(0, 50);", "        button_1.setLayoutData(data_1);", "      }", "    }", "    {", "      button_2 = new Button(this, SWT.NONE);", "      {", "        FormData data_2 = new FormData();", "        data_2.left = new FormAttachment(button_1, 5);", "        button_2.setLayoutData(data_2);", "      }", "    }", "  }", "}");
        shell.refresh();
        FormLayoutInfo layout = (FormLayoutInfo)shell.getLayout();
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        ((FormLayoutInfoImplAutomatic)layout.getImpl()).setExplicitSize((IAbstractComponentInfo)button_2, 1, 4, 10);
        this.assertEditor("public class Test extends Shell {", "  private Button button_1;", "  private Button button_2;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button_1 = new Button(this, SWT.NONE);", "      {", "        FormData data_1 = new FormData();", "        data_1.left = new FormAttachment(0, 50);", "        button_1.setLayoutData(data_1);", "      }", "    }", "    {", "      button_2 = new Button(this, SWT.NONE);", "      {", "        FormData data_2 = new FormData();", "        data_2.right = new FormAttachment(button_1, 90, SWT.RIGHT);", "        data_2.left = new FormAttachment(button_1, 5);", "        button_2.setLayoutData(data_2);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_clipboard() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Composite inner = new Composite(this, SWT.NONE);", "    inner.setLayout(new FormLayout());", "    {", "      Button button = new Button(inner, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 50);", "      data.top = new FormAttachment(20);", "      button.setLayoutData(data);", "    }", "    {", "      Button button2 = new Button(inner, SWT.NONE);", "      FormData data = new FormData();", "      data.right = new FormAttachment(100, -10);", "      button2.setLayoutData(data);", "    }", "  }", "}");
        composite.refresh();
        ControlInfo inner = (ControlInfo)composite.getChildrenControls().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)inner);
        ControlInfo copy = (ControlInfo)memento.create((JavaInfo)composite);
        composite.getLayout().command_CREATE(copy, null);
        memento.apply();
        String[] lines = new String[]{"public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Composite inner = new Composite(this, SWT.NONE);", "    inner.setLayout(new FormLayout());", "    {", "      Button button = new Button(inner, SWT.NONE);", "      FormData data = new FormData();", "      data.left = new FormAttachment(0, 50);", "      data.top = new FormAttachment(20);", "      button.setLayoutData(data);", "    }", "    {", "      Button button2 = new Button(inner, SWT.NONE);", "      FormData data = new FormData();", "      data.right = new FormAttachment(100, -10);", "      button2.setLayoutData(data);", "    }", "    {", "      Composite inner_1 = new Composite(this, SWT.NONE);", "      inner_1.setLayout(new FormLayout());", "      {", "        Button button = new Button(inner_1, SWT.NONE);", "        {", "          FormData formData = new FormData();", "          formData.top = new FormAttachment(20);", "          formData.left = new FormAttachment(0, 50);", "          button.setLayoutData(formData);", "        }", "      }", "      {", "        Button button2 = new Button(inner_1, SWT.NONE);", "        {", "          FormData formData = new FormData();", "          formData.right = new FormAttachment(100, -10);", "          button2.setLayoutData(formData);", "        }", "      }", "    }", "  }", "}"};
        this.assertEditor(lines);
    }

    private void setFormLayout(CompositeInfo composite, String[] expectedLines) throws Exception {
        composite.getRoot().refresh();
        FormLayoutInfo formLayout = (FormLayoutInfo)BTestUtils.createLayout("org.eclipse.swt.layout.FormLayout");
        composite.setLayout((LayoutInfo)formLayout);
        this.assertEditor(expectedLines);
    }

    private void setGridLayout(CompositeInfo composite, String[] expectedLines) throws Exception {
        composite.getRoot().refresh();
        GridLayoutInfo gridLayout = (GridLayoutInfo)BTestUtils.createLayout("org.eclipse.swt.layout.GridLayout");
        composite.setLayout((LayoutInfo)gridLayout);
        this.assertEditor(expectedLines);
    }

    private void prepareComponent() throws Exception {
        this.prepareComponent(75, 25);
    }

    private void prepareComponent(int width, int height) throws Exception {
        FormLayoutModelsTest.setFileContentSrc("test/Button.java", this.getTestSource("public class Button extends org.eclipse.swt.widgets.Button {", "  public Button(Composite parent, int style) {", "    super(parent, style);", "  }", "  protected void checkSubclass () {", "  }", "  public Point computeSize (int wHint, int hHint, boolean changed) {", "    return new Point(" + width + ", " + height + ");", "  }", "}"));
        FormLayoutModelsTest.waitForAutoBuild();
    }
}

