/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.execution;

import java.beans.Beans;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.tests.designer.core.model.TestObjectInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ExecutionUtilsTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_sleep() throws Exception {
        long begin = System.currentTimeMillis();
        ExecutionUtils.sleep((int)60);
        long end = System.currentTimeMillis();
        Assertions.assertThat((long)(end - begin)).isGreaterThanOrEqualTo(60L);
    }

    @Test
    public void test_waitEventLoop() throws Exception {
        final AtomicBoolean executed = new AtomicBoolean();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                executed.set(true);
            }
        });
        ExecutionUtilsTest.assertEquals((Object)false, (Object)executed.get());
        long begin = System.nanoTime();
        ExecutionUtils.waitEventLoop((int)60);
        long end = System.nanoTime();
        Assertions.assertThat((long)(end - begin)).isGreaterThanOrEqualTo(60000000L);
        ExecutionUtilsTest.assertEquals((Object)true, (Object)executed.get());
    }

    @Test
    public void test_waitEventLoop_notThreadSWT() throws Exception {
        long begin = System.nanoTime();
        Thread thread = new Thread(){

            @Override
            public void run() {
                ExecutionUtils.waitEventLoop((int)60);
            }
        };
        thread.start();
        thread.join();
        long end = System.nanoTime();
        Assertions.assertThat((long)(end - begin)).isGreaterThanOrEqualTo(50000000L);
    }

    @Test
    public void test_void_ignore_noException() throws Exception {
        boolean success = ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
            }
        });
        ExecutionUtilsTest.assertTrue((boolean)success);
    }

    @Test
    public void test_void_ignore_withException() throws Exception {
        boolean success = ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                throw new Exception();
            }
        });
        ExecutionUtilsTest.assertFalse((boolean)success);
    }

    @Test
    public void test_void_log_noException() throws Exception {
        boolean success = ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
            }
        });
        ExecutionUtilsTest.assertTrue((boolean)success);
    }

    @Test
    public void test_void_log_withException() throws Exception {
        final Exception exception = new Exception();
        ILog log = DesignerPlugin.getDefault().getLog();
        ILogListener logListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                ExecutionUtilsTest.assertEquals((int)4, (int)status.getSeverity());
                ExecutionUtilsTest.assertEquals((Object)"org.eclipse.wb.core", (Object)status.getPlugin());
                ExecutionUtilsTest.assertEquals((int)4, (int)status.getCode());
                ExecutionUtilsTest.assertSame((Object)exception, (Object)status.getException());
            }
        };
        try {
            log.addLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)false);
            boolean success = ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    throw exception;
                }
            });
            ExecutionUtilsTest.assertFalse((boolean)success);
        }
        finally {
            log.removeLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
        }
    }

    @Test
    public void test_void_log_later_noException() throws Exception {
        final boolean[] executed = new boolean[1];
        ExecutionUtils.runLogLater((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                executed[0] = true;
            }
        });
        ExecutionUtilsTest.assertFalse((boolean)executed[0]);
        ExecutionUtilsTest.waitEventLoop(10);
        ExecutionUtilsTest.assertTrue((boolean)executed[0]);
    }

    @Test
    public void test_void_rethrow_noException() throws Exception {
        ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
            }
        });
    }

    @Test
    public void test_void_rethrow_withException() throws Exception {
        final Exception exception = new Exception();
        try {
            ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    throw exception;
                }
            });
        }
        catch (Throwable e) {
            ExecutionUtilsTest.assertSame((Object)exception, (Object)e);
        }
    }

    @Test
    public void test_void_rethrowMessage_noException() throws Exception {
        ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
            }
        }, (String)"Error message '%s' for %d.", (Object[])new Object[]{"Not found", 42});
    }

    @Test
    public void test_void_rethrowMessage_withException() throws Exception {
        final Exception exception = new Exception();
        try {
            ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    throw exception;
                }
            }, (String)"Error message '%s' for %d.", (Object[])new Object[]{"Not found", 42});
        }
        catch (RuntimeException e) {
            ExecutionUtilsTest.assertEquals((Object)"Error message 'Not found' for 42.", (Object)e.getMessage());
            ExecutionUtilsTest.assertSame((Object)exception, (Object)e.getCause());
        }
    }

    @Test
    public void test_void_runDesignTime_void() throws Exception {
        ExecutionUtils.runDesignTime((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ExecutionUtilsTest.assertTrue((boolean)Beans.isDesignTime());
            }
        });
    }

    @Test
    public void test_void_runDesignTime_Object() throws Exception {
        Object o = new Object();
        Object result = ExecutionUtils.runDesignTime(() -> {
            ExecutionUtilsTest.assertTrue((boolean)Beans.isDesignTime());
            return o;
        });
        ExecutionUtilsTest.assertSame((Object)o, (Object)result);
    }

    @Test
    public void test_object_ignore_noException() throws Exception {
        Object myResult = new Object();
        Object result = ExecutionUtils.runObjectIgnore(() -> myResult, null);
        ExecutionUtilsTest.assertSame((Object)myResult, (Object)result);
    }

    @Test
    public void test_object_ignore_withException() throws Exception {
        Object myResult = new Object();
        Object result = ExecutionUtils.runObjectIgnore(() -> {
            throw new Exception();
        }, (Object)myResult);
        ExecutionUtilsTest.assertSame((Object)myResult, (Object)result);
    }

    @Test
    public void test_object_rethrow_noException() throws Exception {
        Object result = ExecutionUtils.runObject(() -> null);
        ExecutionUtilsTest.assertNull((Object)result);
    }

    @Test
    public void test_object_rethrow_noException2() throws Exception {
        Object myResult = new Object();
        Object result = ExecutionUtils.runObject(() -> myResult);
        ExecutionUtilsTest.assertSame((Object)myResult, (Object)result);
    }

    @Test
    public void test_object_rethrow_noException3() throws Exception {
        Integer myResult = 12345;
        Integer result = (Integer)ExecutionUtils.runObject(() -> myResult);
        ExecutionUtilsTest.assertSame((Object)myResult, (Object)result);
    }

    @Test
    public void test_object_rethrow_withException() throws Exception {
        Exception exception = new Exception();
        try {
            ExecutionUtils.runObject(() -> {
                throw exception;
            });
        }
        catch (Throwable e) {
            ExecutionUtilsTest.assertSame((Object)exception, (Object)e);
        }
    }

    @Test
    public void test_object_rethrow_withError() throws Exception {
        class MyError
        extends Error {
            private static final long serialVersionUID = 0L;

            MyError() {
            }
        }
        MyError myError = new MyError();
        try {
            ExecutionUtils.runObject(() -> {
                throw myError;
            });
            ExecutionUtilsTest.fail();
        }
        catch (MyError e) {
            ExecutionUtilsTest.assertSame((Object)myError, (Object)e);
        }
    }

    @Test
    public void test_object_rethrowMessage_noException() throws Exception {
        Object result = ExecutionUtils.runObject(() -> null, (String)"Error message '%s' for %d.", (Object[])new Object[]{"Not found", 42});
        ExecutionUtilsTest.assertNull((Object)result);
    }

    @Test
    public void test_object_rethrowMessage_withException() throws Exception {
        Exception exception = new Exception();
        try {
            ExecutionUtils.runObject(() -> {
                throw exception;
            }, (String)"Error message '%s' for %d.", (Object[])new Object[]{"Not found", 42});
        }
        catch (Error e) {
            ExecutionUtilsTest.assertEquals((Object)"Error message 'Not found' for 42.", (Object)e.getMessage());
            ExecutionUtilsTest.assertSame((Object)exception, (Object)e.getCause());
        }
    }

    @Test
    public void test_object_log_noException() throws Exception {
        Object myResult = new Object();
        Object result = ExecutionUtils.runObjectLog(() -> myResult, null);
        ExecutionUtilsTest.assertSame((Object)myResult, (Object)result);
    }

    @Test
    public void test_object_log_withException() throws Exception {
        Object result;
        Object myResult = new Object();
        try {
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)false);
            result = ExecutionUtils.runObjectLog(() -> {
                throw new Exception();
            }, (Object)myResult);
        }
        finally {
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
        }
        ExecutionUtilsTest.assertSame((Object)myResult, (Object)result);
    }

    @Test
    public void test_runLogUI_noException() throws Exception {
        final boolean[] executed = new boolean[1];
        final boolean[] success = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                success[0] = ExecutionUtils.runLogUI((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        ExecutionUtilsTest.assertNotNull((Object)Display.getCurrent());
                        executed[0] = true;
                    }
                });
                ExecutionUtilsTest.assertTrue((boolean)executed[0]);
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        ExecutionUtilsTest.assertFalse((boolean)executed[0]);
        while (thread.isAlive()) {
            ExecutionUtilsTest.waitEventLoop(0);
        }
        ExecutionUtilsTest.assertTrue((boolean)executed[0]);
        ExecutionUtilsTest.assertTrue((boolean)success[0]);
    }

    @Test
    public void test_runLogUI_withException() throws Exception {
        final Exception exception = new Exception();
        ILog log = DesignerPlugin.getDefault().getLog();
        ILogListener logListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                ExecutionUtilsTest.assertEquals((int)4, (int)status.getSeverity());
                ExecutionUtilsTest.assertEquals((Object)"org.eclipse.wb.core", (Object)status.getPlugin());
                ExecutionUtilsTest.assertEquals((int)4, (int)status.getCode());
                ExecutionUtilsTest.assertSame((Object)exception, (Object)status.getException());
            }
        };
        try {
            log.addLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)false);
            final boolean[] success = new boolean[1];
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    success[0] = ExecutionUtils.runLogUI((RunnableEx)new RunnableEx(){

                        public void run() throws Exception {
                            throw exception;
                        }
                    });
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
            while (thread.isAlive()) {
                ExecutionUtilsTest.waitEventLoop(0);
            }
            ExecutionUtilsTest.assertFalse((boolean)success[0]);
        }
        finally {
            log.removeLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
        }
    }

    @Test
    public void test_runRethrowUI() throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ExecutionUtils.runRethrowUI((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        ExecutionUtilsTest.assertNotNull((Object)Display.getCurrent());
                    }
                });
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        while (thread.isAlive()) {
            ExecutionUtilsTest.waitEventLoop(0);
        }
    }

    @Test
    public void test_runAsync() throws Exception {
        final boolean[] executed = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ExecutionUtils.runLogLater((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        ExecutionUtilsTest.assertNotNull((Object)Display.getCurrent());
                        executed[0] = true;
                    }
                });
                ExecutionUtilsTest.assertFalse((boolean)executed[0]);
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        ExecutionUtilsTest.assertFalse((boolean)executed[0]);
        thread.join();
        ExecutionUtilsTest.assertFalse((boolean)executed[0]);
        ExecutionUtilsTest.waitEventLoop(0);
        ExecutionUtilsTest.assertTrue((boolean)executed[0]);
    }

    @Test
    public void test_UI_object() throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object myResult = new Object();
                Object result = ExecutionUtils.runObjectUI(() -> {
                    ExecutionUtilsTest.assertNotNull((Object)Display.getCurrent());
                    return myResult;
                });
                ExecutionUtilsTest.assertSame((Object)myResult, (Object)result);
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        while (thread.isAlive()) {
            ExecutionUtilsTest.waitEventLoop(0);
        }
    }

    @Test
    public void test_edit() throws Exception {
        final AtomicBoolean refreshed = new AtomicBoolean();
        final TestObjectInfo object = new TestObjectInfo(){

            protected void refresh_finish() throws Exception {
                refreshed.set(true);
            }
        };
        ExecutionUtils.run((ObjectInfo)object, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ExecutionUtilsTest.assertFalse((boolean)refreshed.get());
                object.startEdit();
                object.endEdit();
                ExecutionUtilsTest.assertFalse((boolean)refreshed.get());
            }
        });
        ExecutionUtilsTest.assertTrue((boolean)refreshed.get());
    }

    @Test
    public void test_edit_exception_withSite() throws Exception {
        TestObjectInfo object = new TestObjectInfo();
        final Exception exception = new Exception();
        final boolean[] exceptionHandled = new boolean[1];
        DesignPageSite.Helper.setSite((ObjectInfo)object, (IDesignPageSite)new DesignPageSite(){

            public void handleException(Throwable e) {
                ExecutionUtilsTest.assertSame((Object)exception, (Object)e);
                exceptionHandled[0] = true;
            }
        });
        ExecutionUtilsTest.assertFalse((boolean)exceptionHandled[0]);
        ExecutionUtils.run((ObjectInfo)object, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                throw exception;
            }
        });
        ExecutionUtilsTest.assertTrue((boolean)exceptionHandled[0]);
    }

    @Test
    public void test_edit_exception_noSite() throws Exception {
        final AtomicBoolean refreshed = new AtomicBoolean();
        TestObjectInfo object = new TestObjectInfo(){

            protected void refresh_finish() throws Exception {
                refreshed.set(true);
            }
        };
        final Exception exception = new Exception();
        try {
            ExecutionUtils.run((ObjectInfo)object, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    throw exception;
                }
            });
            ExecutionUtilsTest.fail();
        }
        catch (Throwable e) {
            ExecutionUtilsTest.assertSame((Object)exception, (Object)e);
            ExecutionUtilsTest.assertFalse((boolean)refreshed.get());
        }
    }

    @Test
    public void test_edit_exception_noSite_RuntimeException() throws Exception {
        TestObjectInfo object = new TestObjectInfo(){

            @Override
            public String toString() {
                throw new Error("toString() is not implemented!");
            }
        };
        final RuntimeException exception = new RuntimeException();
        try {
            ExecutionUtils.run((ObjectInfo)object, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    throw exception;
                }
            });
            ExecutionUtilsTest.fail();
        }
        catch (Throwable e) {
            ExecutionUtilsTest.assertSame((Object)exception, (Object)e);
        }
    }

    @Test
    public void test_edit_later() throws Exception {
        final AtomicBoolean refreshed = new AtomicBoolean();
        final TestObjectInfo object = new TestObjectInfo(){

            protected void refresh_finish() throws Exception {
                refreshed.set(true);
            }
        };
        final AtomicBoolean executed = new AtomicBoolean();
        ExecutionUtils.runLater((ObjectInfo)object, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                executed.set(true);
                object.startEdit();
                object.endEdit();
                ExecutionUtilsTest.assertFalse((boolean)refreshed.get());
            }
        });
        ExecutionUtilsTest.assertFalse((boolean)executed.get());
        ExecutionUtilsTest.assertFalse((boolean)refreshed.get());
        ExecutionUtilsTest.waitEventLoop(1);
        ExecutionUtilsTest.assertTrue((boolean)executed.get());
        ExecutionUtilsTest.assertTrue((boolean)refreshed.get());
    }

    @Test
    public void test_edit_object() throws Exception {
        final AtomicBoolean refreshed = new AtomicBoolean();
        TestObjectInfo object = new TestObjectInfo(){

            protected void refresh_finish() throws Exception {
                refreshed.set(true);
            }
        };
        String result = "expected";
        String actual = (String)ExecutionUtils.runObject((ObjectInfo)object, () -> "expected");
        ExecutionUtilsTest.assertSame((Object)"expected", (Object)actual);
        ExecutionUtilsTest.assertTrue((boolean)refreshed.get());
    }

    @Test
    public void test_refresh() throws Exception {
        final AtomicBoolean refreshed = new AtomicBoolean();
        TestObjectInfo object = new TestObjectInfo(){

            protected void refresh_finish() throws Exception {
                refreshed.set(true);
            }
        };
        ExecutionUtils.refresh((ObjectInfo)object);
        ExecutionUtilsTest.assertTrue((boolean)refreshed.get());
    }
}

