/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class StringsAddPropertyTest
extends SwingModelTest {
    @Test
    public void test_0() throws Exception {
        this.createMyPanel();
        StringsAddPropertyTest.setFileContentSrc("test/MyPanel.wbp-component.xml", StringsAddPropertyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "      <method name='addItem'>", "        <parameter type='java.lang.String'/>", "      </method>", "  </methods>", "  <add-property id='stringsAdd' title='items'>", "    <parameter name='addMethod'>addItem</parameter>", "  </add-property>", "</component>"));
        StringsAddPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    addItem('aaa');", "    addItem('bbb');", "  }", "}");
        panel.refresh();
        Property itemsProperty = panel.getPropertyByTitle("items");
        StringsAddPropertyTest.assertNotNull((Object)itemsProperty);
        StringsAddPropertyTest.assertEquals((Object)"[aaa,bbb]", (Object)StringsAddPropertyTest.getPropertyText(itemsProperty));
        StringsAddPropertyTest.assertTrue((boolean)itemsProperty.isModified());
        StringsAddPropertyTest.assertArrayEquals((Object[])new String[]{"aaa", "bbb"}, (Object[])((String[])itemsProperty.getValue()));
        itemsProperty.setValue((Object)new String[]{"000", "111", "222"});
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    addItem('000');", "    addItem('111');", "    addItem('222');", "  }", "}");
        StringsAddPropertyTest.assertEquals((Object)"[000,111,222]", (Object)StringsAddPropertyTest.getPropertyText(itemsProperty));
        StringsAddPropertyTest.assertTrue((boolean)itemsProperty.isModified());
        StringsAddPropertyTest.assertArrayEquals((Object[])new String[]{"000", "111", "222"}, (Object[])((String[])itemsProperty.getValue()));
    }

    @Test
    public void test_removeMethods() throws Exception {
        this.createMyPanel();
        StringsAddPropertyTest.setFileContentSrc("test/MyPanel.wbp-component.xml", StringsAddPropertyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "      <method name='addItem'>", "        <parameter type='java.lang.String'/>", "      </method>", "  </methods>", "  <add-property id='stringsAdd' title='items'>", "    <parameter name='addMethod'>addItem</parameter>", "    <parameter name='removeMethods'>clear() insertItem(java.lang.String,int)</parameter>", "  </add-property>", "</component>"));
        StringsAddPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    clear();", "    addItem('aaa');", "    addItem('bbb');", "    insertItem('ccc', 1);", "  }", "}");
        panel.refresh();
        Property itemsProperty = panel.getPropertyByTitle("items");
        StringsAddPropertyTest.assertNotNull((Object)itemsProperty);
        StringsAddPropertyTest.assertEquals((Object)"[aaa,bbb]", (Object)StringsAddPropertyTest.getPropertyText(itemsProperty));
        StringsAddPropertyTest.assertTrue((boolean)itemsProperty.isModified());
        StringsAddPropertyTest.assertArrayEquals((Object[])new String[]{"aaa", "bbb"}, (Object[])((String[])itemsProperty.getValue()));
        itemsProperty.setValue((Object)new String[]{"000", "111", "222"});
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    addItem('000');", "    addItem('111');", "    addItem('222');", "  }", "}");
        StringsAddPropertyTest.assertEquals((Object)"[000,111,222]", (Object)StringsAddPropertyTest.getPropertyText(itemsProperty));
        StringsAddPropertyTest.assertTrue((boolean)itemsProperty.isModified());
        StringsAddPropertyTest.assertArrayEquals((Object[])new String[]{"000", "111", "222"}, (Object[])((String[])itemsProperty.getValue()));
    }

    private void createMyPanel() throws Exception {
        StringsAddPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void clear() {", "  }", "  public void addItem(String item) {", "  }", "  public void insertItem(String item, int index) {", "  }", "}"));
    }
}

