/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.util.Lists;
import org.eclipse.wb.internal.core.model.property.editor.ExpressionListPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.tests.designer.core.model.property.editor.AbstractTextPropertyEditorTest;
import org.junit.jupiter.api.Test;

public class ExpressionListPropertyEditorTest
extends AbstractTextPropertyEditorTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_configure_valid() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        ExpressionListPropertyEditor editor = this.createEditor(ExpressionListPropertyEditor.class, parameters);
        this.assertEditorConfiguration(editor, parameters);
    }

    @Test
    public void test_configure_titles() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        parameters.remove("titles");
        ExpressionListPropertyEditor editor = this.createEditor(ExpressionListPropertyEditor.class, parameters);
        parameters.put("titles", parameters.get("expressions"));
        this.assertEditorConfiguration(editor, parameters);
    }

    @Test
    public void test_configure_count() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        List conditions = (List)parameters.get("conditions");
        conditions.remove(0);
        parameters.put("conditions", conditions);
        try {
            this.createEditor(ExpressionListPropertyEditor.class, parameters);
            ExpressionListPropertyEditorTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_configure_parameters() throws Exception {
        Map<String, Object> parameters = this.getEditorParameters();
        parameters.remove("conditions");
        try {
            this.createEditor(ExpressionListPropertyEditor.class, parameters);
            ExpressionListPropertyEditorTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_getValueSource() throws Exception {
        ExpressionListPropertyEditor editor = this.createEditor(ExpressionListPropertyEditor.class, this.getEditorParameters());
        ExpressionListPropertyEditorTest.assertEquals((Object)"new java.lang.String()", (Object)editor.getValueSource((Object)new String()));
        ExpressionListPropertyEditorTest.assertEquals((Object)"null", (Object)editor.getValueSource(null));
    }

    @Test
    public void test_getClipboardSource() throws Exception {
        ExpressionListPropertyEditor editor = this.createEditor(ExpressionListPropertyEditor.class, this.getEditorParameters());
        ExpressionListPropertyEditorTest.assert_getClipboardSource("new java.lang.String()", (TextDisplayPropertyEditor)editor, new String());
        ExpressionListPropertyEditorTest.assert_getClipboardSource(null, (TextDisplayPropertyEditor)editor, new StringBuffer());
    }

    @Test
    public void test_getText() throws Exception {
        ExpressionListPropertyEditor editor = this.createEditor(ExpressionListPropertyEditor.class, this.getEditorParameters());
        ExpressionListPropertyEditorTest.assert_getText("STR", (TextDisplayPropertyEditor)editor, new String());
        ExpressionListPropertyEditorTest.assert_getText("NIL", (TextDisplayPropertyEditor)editor, null);
        ExpressionListPropertyEditorTest.assert_getText(null, (TextDisplayPropertyEditor)editor, new StringBuffer());
    }

    @Test
    public void test_imports() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("functions", ExpressionListPropertyEditorTest.getSourceDQ("import java.util.ArrayList;"));
        parameters.put("expressions", Lists.newArrayList((Object[])new String[]{"new java.util.ArrayList()", "new java.lang.String()", "null"}));
        parameters.put("conditions", Lists.newArrayList((Object[])new String[]{"value is ArrayList", "value is String", "value == null"}));
        parameters.put("titles", Lists.newArrayList((Object[])new String[]{"AL", "STR", "NIL"}));
        ExpressionListPropertyEditor editor = this.createEditor(ExpressionListPropertyEditor.class, parameters);
        ExpressionListPropertyEditorTest.assert_getText("AL", (TextDisplayPropertyEditor)editor, new ArrayList());
        ExpressionListPropertyEditorTest.assert_getText("STR", (TextDisplayPropertyEditor)editor, new String());
        ExpressionListPropertyEditorTest.assert_getText("NIL", (TextDisplayPropertyEditor)editor, null);
    }

    private void assertEditorConfiguration(ExpressionListPropertyEditor editor, Map<String, Object> parameters) throws Exception {
        ExpressionListPropertyEditorTest.assertContainsOnly(editor, "m_expressions", (List)parameters.get("expressions"));
        ExpressionListPropertyEditorTest.assertContainsOnly(editor, "m_conditions", (List)parameters.get("conditions"));
        ExpressionListPropertyEditorTest.assertContainsOnly(editor, "m_titles", (List)parameters.get("titles"));
        ExpressionListPropertyEditorTest.assertEquals((Object)ExpressionListPropertyEditorTest.getFieldValue(editor, "m_functions"), (Object)parameters.get("functions"));
    }

    private Map<String, Object> getEditorParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("functions", ExpressionListPropertyEditorTest.getSourceDQ("def valueType(c) {", "  if (value == null) {", "    return false; ", "  } else { ", "    return isType(value.getClass(),c); ", "  } ", "};"));
        params.put("expressions", Lists.newArrayList((Object[])new String[]{"new java.lang.Integer()", "new java.lang.String()", "null"}));
        params.put("conditions", Lists.newArrayList((Object[])new String[]{"valueType(\"java.lang.Integer\")", "valueType(\"java.lang.String\")", "value == null"}));
        params.put("titles", Lists.newArrayList((Object[])new String[]{"INT", "STR", "NIL"}));
        params.put("imports", Lists.newArrayList((Object[])new String[]{"com.google.common.collect.Lists"}));
        return params;
    }
}

