/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.accessor;

import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.accessor.FactoryAccessor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FactoryAccessorTest
extends SwingModelTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject != null) {
            FactoryAccessorTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
            FactoryAccessorTest.waitForAutoBuild();
        }
    }

    @Test
    public void test_0() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(StaticFactory.createButton('text'));", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)button.getPropertyByTitle("text");
        FactoryAccessor accessor = (FactoryAccessor)FactoryAccessorTest.getGenericPropertyAccessors(property).get(1);
        FactoryAccessorTest.assertEquals((Object)"text", (Object)((StringLiteral)accessor.getExpression((JavaInfo)button)).getLiteralValue());
    }

    @Test
    public void test_setExpression_newValue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(StaticFactory.createButton('text'));", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)button.getPropertyByTitle("text");
        FactoryAccessor accessor = (FactoryAccessor)FactoryAccessorTest.getGenericPropertyAccessors(property).get(1);
        FactoryAccessorTest.assertTrue((boolean)accessor.setExpression((JavaInfo)button, "\"new text\""));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(StaticFactory.createButton('new text'));", "  }", "}");
    }

    @Test
    public void test_setExpression_nullValue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(StaticFactory.createButton('text'));", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)button.getPropertyByTitle("text");
        FactoryAccessor accessor = (FactoryAccessor)FactoryAccessorTest.getGenericPropertyAccessors(property).get(1);
        FactoryAccessorTest.assertTrue((boolean)accessor.setExpression((JavaInfo)button, null));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(StaticFactory.createButton((String) null));", "  }", "}");
    }

    @Test
    public void test_setExpression_nullValue_noDefault() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(StaticFactory.createButton('text'));", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FactoryAccessor accessor = new FactoryAccessor(0, null);
        FactoryAccessorTest.assertFalse((boolean)accessor.setExpression((JavaInfo)button, null));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(StaticFactory.createButton('text'));", "  }", "}");
    }
}

