/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.creation;

import javax.swing.JButton;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ConstructorDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.ObjectPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.StaticFieldPropertyEditor;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.model.parser.AbstractJavaInfoTest;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ConstructorCreationSupportTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_access() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "  }", "}");
        ConstructorCreationSupport creationSupport = (ConstructorCreationSupport)panel.getCreationSupport();
        ConstructorCreationSupportTest.assertSame((Object)creationSupport.getCreation(), (Object)creationSupport.getNode());
        ConstructorCreationSupportTest.assertEquals((Object)"new JPanel()", (Object)this.m_lastEditor.getSource((ASTNode)creationSupport.getCreation()));
        ConstructorCreationSupportTest.assertEquals((Object)"new: javax.swing.JPanel", (Object)creationSupport.toString());
        IMethodBinding binding = creationSupport.getBinding();
        ConstructorCreationSupportTest.assertEquals((Object)"<init>()", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)binding));
        ConstructorDescription description = creationSupport.getDescription();
        ConstructorCreationSupportTest.assertNotNull((Object)description);
        ConstructorCreationSupportTest.assertEquals((int)0, (int)description.getParameters().size());
        ConstructorCreationSupportTest.assertTrue((boolean)creationSupport.canReorder());
        ConstructorCreationSupportTest.assertTrue((boolean)creationSupport.canReparent());
    }

    @Test
    public void test_delete_simpleComponent() throws Exception {
        this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)ConstructorCreationSupportTest.getJavaInfoByName("button");
        ConstructorCreationSupportTest.assertTrue((boolean)button.getAssociation().canDelete());
        ConstructorCreationSupportTest.assertTrue((boolean)button.getCreationSupport().canDelete());
        ConstructorCreationSupportTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_delete_rootComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  public static void main(String[] args) {", "    JPanel rootPanel = new JPanel();", "    rootPanel.setBackground(Color.green);", "    {", "      JButton button = new JButton();", "      rootPanel.add(button);", "    }", "  }", "}");
        ConstructorCreationSupportTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)panel.getCreationSupport());
        ConstructorCreationSupportTest.assertTrue((boolean)panel.getAssociation().canDelete());
        ConstructorCreationSupportTest.assertTrue((boolean)panel.getCreationSupport().canDelete());
        ConstructorCreationSupportTest.assertTrue((boolean)panel.canDelete());
        panel.delete();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  public static void main(String[] args) {", "    JPanel rootPanel = new JPanel();", "  }", "}");
        panel.getProperties();
    }

    @Test
    public void test_properties_good() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JLabel label = new JLabel('111', SwingConstants.RIGHT);", "    add(label);", "  }", "}");
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorCreationSupportTest.assertEquals((int)6, (int)label.getDescription().getConstructors().size());
        Property constructorProperty = label.getPropertyByTitle("Constructor");
        ConstructorCreationSupportTest.assertNotNull((Object)constructorProperty);
        Property[] subProperties = ConstructorCreationSupportTest.getSubProperties(constructorProperty);
        ConstructorCreationSupportTest.assertEquals((int)2, (int)subProperties.length);
        ConstructorCreationSupportTest.assertEquals((Object)"text", (Object)subProperties[0].getTitle());
        Property alignmentProperty = subProperties[1];
        ConstructorCreationSupportTest.assertEquals((Object)"horizontalAlignment", (Object)alignmentProperty.getTitle());
        ConstructorCreationSupportTest.assertInstanceOf(StaticFieldPropertyEditor.class, (Object)alignmentProperty.getEditor());
    }

    @Test
    public void test_properties_parentProperty() throws Exception {
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container parent, int value) {", "    parent.add(this);", "  }", "}"));
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.wbp-component.xml", ConstructorCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "      <parameter type='int'/>", "    </constructor>", "  </constructors>", "</component>"));
        ConstructorCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    new MyButton(this, 123);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorCreationSupportTest.assertNotNull((Object)PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor"));
        ConstructorCreationSupportTest.assertNotNull((Object)PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor/value"));
        Property parentProperty = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor/parent");
        ConstructorCreationSupportTest.assertNotNull((Object)parentProperty);
        Object[] parentProperties = ConstructorCreationSupportTest.getSubProperties(parentProperty);
        ConstructorCreationSupportTest.assertArrayEquals((Object[])parentProperties, (Object[])panel.getProperties());
    }

    @Test
    public void test_properties_parentProperty_disable() throws Exception {
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container parent, int value) {", "    parent.add(this);", "  }", "}"));
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.wbp-component.xml", ConstructorCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'>", "        <tag name='property.no' value='true'/>", "      </parameter>", "      <parameter type='int'/>", "    </constructor>", "  </constructors>", "</component>"));
        ConstructorCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    new MyButton(this, 123);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorCreationSupportTest.assertNotNull((Object)PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor"));
        ConstructorCreationSupportTest.assertNotNull((Object)PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor/value"));
        ConstructorCreationSupportTest.assertNull((Object)PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor/parent"));
    }

    @Test
    public void test_properties_notBoundJavaInfo() throws Exception {
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Component someComponent) {", "  }", "}"));
        ConstructorCreationSupportTest.waitForAutoBuild();
        this.parseContainer("class Test extends JPanel {", "  Test() {", "    JButton someComponent = new JButton();", "    add(new MyButton(someComponent));", "  }", "}");
        ConstructorCreationSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyButton(someComponent))/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyButton} {empty} {/add(new MyButton(someComponent))/}");
    }

    @Test
    public void test_properties_objectProperty() throws Exception {
        ConstructorCreationSupportTest.setFileContentSrc("test/MyComponent.java", this.getTestSource("// filler filler filler filler filler", "public class MyComponent extends JButton {", "  public MyComponent(JButton button) {", "  }", "}"));
        ConstructorCreationSupportTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  private JButton button = new JButton();", "  private MyComponent component = new MyComponent(button);", "  public Test() {", "    add(button);", "    add(component);", "  }", "}");
        ComponentInfo component = (ComponentInfo)ConstructorCreationSupportTest.getJavaInfoByName("component");
        Property buttonProperty = PropertyUtils.getByPath((ObjectInfo)component, (String)"Constructor/button");
        ConstructorCreationSupportTest.assertNotNull((Object)buttonProperty);
        ConstructorCreationSupportTest.assertSame((Object)ObjectPropertyEditor.INSTANCE, (Object)buttonProperty.getEditor());
    }

    @Test
    public void test_constructorParameterEditor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new TextArea('', 10, 50, TextArea.SCROLLBARS_BOTH));", "  }", "}");
        ComponentInfo textArea = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property constructorProperty = textArea.getPropertyByTitle("Constructor");
        ConstructorCreationSupportTest.assertNotNull((Object)constructorProperty);
        Property[] subProperties = ConstructorCreationSupportTest.getSubProperties(constructorProperty);
        ConstructorCreationSupportTest.assertEquals((int)4, (int)subProperties.length);
        ConstructorCreationSupportTest.assertEquals((Object)"text", (Object)subProperties[0].getTitle());
        ConstructorCreationSupportTest.assertEquals((Object)"rows", (Object)subProperties[1].getTitle());
        ConstructorCreationSupportTest.assertEquals((Object)"columns", (Object)subProperties[2].getTitle());
        ConstructorCreationSupportTest.assertEquals((Object)"scrollbars", (Object)subProperties[3].getTitle());
        StaticFieldPropertyEditor editor = (StaticFieldPropertyEditor)subProperties[3].getEditor();
        ConstructorCreationSupportTest.assertArrayEquals((Object[])new String[]{"SCROLLBARS_BOTH", "SCROLLBARS_VERTICAL_ONLY", "SCROLLBARS_HORIZONTAL_ONLY", "SCROLLBARS_NONE"}, (Object[])((String[])ConstructorCreationSupportTest.getFieldValue(editor, "m_titles")));
    }

    @Test
    public void test_CreationDescription_parameters() throws Exception {
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.wbp-component.xml", ConstructorCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation id='withParameters'>", "    <source><![CDATA[new test.MyButton()]]></source>", "    <parameter name='name_1'>value_1</parameter>", "    <parameter name='name_2'>value_2</parameter>", "  </creation>", "</component>"));
        ConstructorCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Object myButton = ConstructorCreationSupportTest.createJavaInfo("test.MyButton", "withParameters");
        ConstructorCreationSupportTest.assertEquals((Object)"value_1", (Object)JavaInfoUtils.getParameter(myButton, (String)"name_1"));
        ConstructorCreationSupportTest.assertEquals((Object)"value_2", (Object)JavaInfoUtils.getParameter(myButton, (String)"name_2"));
    }

    @Test
    public void test_clipboard_normalProperties() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton('Some text', null));", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorCreationSupportTest.assertClipboardSource((JavaInfo)button, "new javax.swing.JButton(\"Some text\", null)");
    }

    @Test
    public void test_clipboard_parentAsArgument() throws Exception {
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container parent) {", "    parent.add(this);", "  }", "}"));
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.wbp-component.xml", ConstructorCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        ConstructorCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    new MyButton(this);", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorCreationSupportTest.assertClipboardSource((JavaInfo)button, "new test.MyButton(%parent%)");
    }

    @Test
    public void test_clipboard_specialPatternUsingBroadcast() throws Exception {
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container someSpecial) {", "  }", "}"));
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.wbp-component.xml", ConstructorCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container'>", "        <tag name='myTag' value='generateSpecialPattern'/>", "      </parameter>", "    </constructor>", "  </constructors>", "</component>"));
        ConstructorCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton(this));", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panel.addBroadcastListener((Object)new JavaEventListener(){

            public void clipboardCopy_Argument(JavaInfo javaInfo, ParameterDescription parameter, Expression argument, String[] source) throws Exception {
                if ("generateSpecialPattern".equals(parameter.getTag("myTag"))) {
                    source[0] = "%someSpecialPattern%";
                }
            }
        });
        ConstructorCreationSupportTest.assertClipboardSource((JavaInfo)button, "new test.MyButton(%someSpecialPattern%)");
    }

    @Test
    public void test_clipboard_styleProperty() throws Exception {
        ConstructorCreationSupportTest.setFileContentSrc("test/Styles.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public interface Styles {", "  int NONE = 0;", "  int BORDER = 1;", "}"));
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(int style) {", "  }", "}"));
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.wbp-component.xml", ConstructorCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='int' defaultSource='test.Styles.NONE'>", "        <editor id='style'>", "          <parameter name='class'>test.Styles</parameter>", "          <parameter name='set'>BORDER</parameter>", "        </editor>", "      </parameter>", "    </constructor>", "  </constructors>", "</component>"));
        ConstructorCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton(Styles.BORDER));", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorCreationSupportTest.assertClipboardSource((JavaInfo)button, "new test.MyButton(test.Styles.BORDER)");
        Property styleProperty = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor/style");
        ((GenericProperty)styleProperty).setExpression("test.Styles.NONE", Property.UNKNOWN_VALUE);
        ConstructorCreationSupportTest.assertClipboardSource((JavaInfo)button, "new test.MyButton(test.Styles.NONE)");
    }

    @Test
    public void test_clipboard_typeArguments() throws Exception {
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton<T, S> extends JButton {", "  public MyButton() {", "  }", "}"));
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.wbp-component.xml", ConstructorCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton<%T%>()]]></source>", "    <typeParameters>", "      <typeParameter name='T' type='java.lang.Object' title='arg T'/>", "      <typeParameter name='S' type='java.lang.Object' title='arg S'/>", "    </typeParameters>", "  </creation>", "</component>"));
        ConstructorCreationSupportTest.waitForAutoBuild();
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton<Double, String> button = new MyButton<Double, String>();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)ConstructorCreationSupportTest.getJavaInfoByName("button");
        ConstructorCreationSupportTest.doCopyPaste(button, new AbstractJavaInfoTest.PasteProcedure<ComponentInfo>(){

            @Override
            public void run(ComponentInfo copy) throws Exception {
                ((FlowLayoutInfo)panel.getLayout()).add(copy, null);
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton<Double, String> button = new MyButton<Double, String>();", "      add(button);", "    }", "    {", "      MyButton<Double, String> button = new MyButton<Double, String>();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_clipboard_anonymousClassDeclaration() throws Exception {
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public abstract class MyButton extends JButton {", "  public MyButton() {", "  }", "  protected abstract String myStringMethod(int a, double b, String c);", "  protected abstract void myVoidMethod();", "}"));
        ConstructorCreationSupportTest.waitForAutoBuild();
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton() {", "        protected String myStringMethod(int a, double b, String c) {", "          return 'foo';", "        }", "        protected void myVoidMethod() {", "        }", "      };", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)ConstructorCreationSupportTest.getJavaInfoByName("button");
        ConstructorCreationSupportTest.doCopyPaste(button, new AbstractJavaInfoTest.PasteProcedure<ComponentInfo>(){

            @Override
            public void run(ComponentInfo copy) throws Exception {
                ((FlowLayoutInfo)panel.getLayout()).add(copy, null);
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton() {", "        protected String myStringMethod(int a, double b, String c) {", "          return 'foo';", "        }", "        protected void myVoidMethod() {", "        }", "      };", "      add(button);", "    }", "    {", "      MyButton button = new MyButton() {", "        protected String myStringMethod(int a, double b, String c) {", "          return (String) null;", "        }", "        protected void myVoidMethod() {", "        }", "      };", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_getSource_forCreationId() throws Exception {
        this.setJavaContentSrc("test", "MyButton", new String[]{"public class MyButton extends JButton {", "  public MyButton(boolean b) {", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton(false)]]></source>", "  </creation>", "  <creation id='true'>", "    <source><![CDATA[new test.MyButton(true)]]></source>", "  </creation>", "</component>"});
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        Class<?> clazz = this.m_lastLoader.loadClass("test.MyButton");
        ConstructorCreationSupport creationSupport = new ConstructorCreationSupport();
        JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, clazz, (CreationSupport)creationSupport);
        ConstructorCreationSupportTest.assertEquals((Object)"new test.MyButton(false)", (Object)creationSupport.add_getSource(null));
        creationSupport = new ConstructorCreationSupport("true", false);
        JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, clazz, (CreationSupport)creationSupport);
        ConstructorCreationSupportTest.assertEquals((Object)"new test.MyButton(true)", (Object)creationSupport.add_getSource(null));
    }

    @Test
    public void test_getSource_forSource() throws Exception {
        this.setJavaContentSrc("test", "MyButton", new String[]{"public class MyButton extends JButton {", "  public MyButton(boolean b) {", "  }", "}"}, null);
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        Class<?> clazz = this.m_lastLoader.loadClass("test.MyButton");
        ConstructorCreationSupport creationSupport = ConstructorCreationSupport.forSource((String)"new test.MyButton(1 == 1)");
        JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, clazz, (CreationSupport)creationSupport);
        ConstructorCreationSupportTest.assertEquals((Object)"new test.MyButton(1 == 1)", (Object)creationSupport.add_getSource(null));
    }

    @Test
    public void test_CREATE_noInvocations() throws Exception {
        this.setJavaContentSrc("test", "MyButton", new String[]{"public class MyButton extends JButton {", "  public MyButton() {", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton()]]></source>", "    <invocation signature='setEnabled(boolean)'><![CDATA[false]]></invocation>", "  </creation>", "</component>"});
        String[] lines1 = new String[]{"public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines1);
        ConstructorCreationSupport creationSupport = new ConstructorCreationSupport(null, false);
        ComponentInfo newButton = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.MyButton"), (CreationSupport)creationSupport);
        ((FlowLayoutInfo)panel.getLayout()).add(newButton, null);
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton myButton = new MyButton();", "      add(myButton);", "    }", "  }", "}"};
        this.assertEditor(lines);
        ClassInstanceCreation creation = creationSupport.getCreation();
        ConstructorCreationSupportTest.assertNotNull((Object)creation);
        ConstructorCreationSupportTest.assertEquals((Object)"new MyButton()", (Object)this.m_lastEditor.getSource((ASTNode)creation));
        ConstructorCreationSupportTest.assertNotNull((Object)creationSupport.getBinding());
        ConstructorDescription description = creationSupport.getDescription();
        ConstructorCreationSupportTest.assertNotNull((Object)description);
        ConstructorCreationSupportTest.assertEquals((Object)"<init>()", (Object)description.getSignature());
    }

    @Test
    public void test_CREATE_addInvocations() throws Exception {
        this.setJavaContentSrc("test", "MyButton", new String[]{"public class MyButton extends JButton {", "  public MyButton() {", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton()]]></source>", "    <invocation signature='setEnabled(boolean)'><![CDATA[false]]></invocation>", "  </creation>", "</component>"});
        String[] lines1 = new String[]{"public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines1);
        ConstructorCreationSupport creationSupport = new ConstructorCreationSupport(null, true);
        ComponentInfo newButton = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.MyButton"), (CreationSupport)creationSupport);
        ((FlowLayoutInfo)panel.getLayout()).add(newButton, null);
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton myButton = new MyButton();", "      add(myButton);", "      myButton.setEnabled(false);", "    }", "  }", "}"};
        this.assertEditor(lines);
    }

    @Test
    public void test_template_index() throws Exception {
        this.setJavaContentSrc("test", "MyButton", new String[]{"public class MyButton extends JButton {", "  public MyButton(String value) {", "  }", "  public void setValue(String value) {", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton(\"value_%index%\")]]></source>", "  </creation>", "</component>"});
        String[] lines1 = new String[]{"public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines1);
        ConstructorCreationSupport creationSupport = new ConstructorCreationSupport(null, true);
        ComponentInfo newButton = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.MyButton"), (CreationSupport)creationSupport);
        ((FlowLayoutInfo)panel.getLayout()).add(newButton, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton myButton = new MyButton('value_2');", "      add(myButton);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_badConstructur() throws Exception {
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  public MyButton() {", "  }", "}"));
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.wbp-component.xml", ConstructorCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton(BAD)]]></source>", "  </creation>", "</component>"));
        ConstructorCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        try {
            ComponentInfo newButton = (ComponentInfo)ConstructorCreationSupportTest.createJavaInfo("test.MyButton");
            flowLayout.add(newButton, null);
            ConstructorCreationSupportTest.fail();
        }
        catch (DesignerException e) {
            ConstructorCreationSupportTest.assertEquals((int)208, (int)e.getCode());
        }
    }

    @Test
    public void test_getAssociation_noParent() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        Class<JButton> clazz = JButton.class;
        ConstructorCreationSupport creationSupport = new ConstructorCreationSupport();
        JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, clazz, (CreationSupport)creationSupport);
        ConstructorCreationSupportTest.assertNull((Object)creationSupport.getAssociation());
    }

    @Test
    public void test_getAssociation_hasParent() throws Exception {
        this.setJavaContentSrc("test", "MyButton", new String[]{"public class MyButton extends JButton {", "  public MyButton(JPanel parent) {", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton(%parent%)]]></source>", "  </creation>", "  <constructors>", "    <constructor>", "      <parameter type='javax.swing.JPanel' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"});
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        Class<?> clazz = this.m_lastLoader.loadClass("test.MyButton");
        ConstructorCreationSupport creationSupport = new ConstructorCreationSupport();
        JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, clazz, (CreationSupport)creationSupport);
        ConstructorCreationSupportTest.assertInstanceOf(ConstructorParentAssociation.class, (Object)creationSupport.getAssociation());
    }

    @Test
    public void test_canUseParent_MOVE_false() throws Exception {
        this.prepare_canUseParent_MyButton();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    {", "      JPanel panel_1 = new JPanel();", "      getContentPane().add(panel_1);", "      panel_1.add(new MyButton(panel_1));", "    }", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ContainerInfo panel_1 = (ContainerInfo)contentPane.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)panel_1.getChildrenComponents().get(0);
        CreationSupport creationSupport = button.getCreationSupport();
        ConstructorCreationSupportTest.assertFalse((boolean)creationSupport.canUseParent((JavaInfo)frame));
        ConstructorCreationSupportTest.assertFalse((boolean)creationSupport.canUseParent((JavaInfo)frame));
    }

    @Test
    public void test_canUseParent_MOVE_true() throws Exception {
        this.prepare_canUseParent_MyButton();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    {", "      JPanel panel_1 = new JPanel();", "      getContentPane().add(panel_1);", "      panel_1.add(new MyButton(panel_1));", "    }", "    {", "      JPanel panel_2 = new JPanel();", "      getContentPane().add(panel_2);", "    }", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ContainerInfo panel_1 = (ContainerInfo)contentPane.getChildrenComponents().get(0);
        ContainerInfo panel_2 = (ContainerInfo)contentPane.getChildrenComponents().get(1);
        ComponentInfo button = (ComponentInfo)panel_1.getChildrenComponents().get(0);
        CreationSupport creationSupport = button.getCreationSupport();
        ConstructorCreationSupportTest.assertTrue((boolean)creationSupport.canUseParent((JavaInfo)panel_2));
        ConstructorCreationSupportTest.assertTrue((boolean)creationSupport.canUseParent((JavaInfo)panel_2));
    }

    @Test
    public void test_canUseParent_CREATE_false() throws Exception {
        this.prepare_canUseParent_MyButton();
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        frame.refresh();
        ComponentInfo button = ConstructorCreationSupportTest.createComponent("test.MyButton");
        CreationSupport creationSupport = button.getCreationSupport();
        ConstructorCreationSupportTest.assertFalse((boolean)creationSupport.canUseParent((JavaInfo)frame));
        ConstructorCreationSupportTest.assertFalse((boolean)creationSupport.canUseParent((JavaInfo)frame));
    }

    @Test
    public void test_canUseParent_CREATE_true() throws Exception {
        this.prepare_canUseParent_MyButton();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentInfo button = ConstructorCreationSupportTest.createComponent("test.MyButton");
        CreationSupport creationSupport = button.getCreationSupport();
        ConstructorCreationSupportTest.assertTrue((boolean)creationSupport.canUseParent((JavaInfo)panel));
        ConstructorCreationSupportTest.assertTrue((boolean)creationSupport.canUseParent((JavaInfo)panel));
    }

    @Test
    public void test_canUseParent_CREATE_noParent() throws Exception {
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(JPanel parentForButton) {", "  }", "}"));
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.wbp-component.xml", ConstructorCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton(%parentForButton%)]]></source>", "  </creation>", "</component>"));
        ConstructorCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentInfo button = ConstructorCreationSupportTest.createComponent("test.MyButton");
        CreationSupport creationSupport = button.getCreationSupport();
        ConstructorCreationSupportTest.assertTrue((boolean)creationSupport.canUseParent((JavaInfo)panel));
        ConstructorCreationSupportTest.assertTrue((boolean)creationSupport.canUseParent((JavaInfo)panel));
    }

    private void prepare_canUseParent_MyButton() throws Exception {
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(JPanel parent) {", "  }", "}"));
        ConstructorCreationSupportTest.setFileContentSrc("test/MyButton.wbp-component.xml", ConstructorCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton(%parent%)]]></source>", "  </creation>", "  <constructors>", "    <constructor>", "      <parameter type='javax.swing.JPanel' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        ConstructorCreationSupportTest.waitForAutoBuild();
    }
}

