/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavadocCompletionModelTest;

public class JavadocTextCompletionModelTest
extends AbstractJavadocCompletionModelTest {
    public JavadocTextCompletionModelTest(String name) {
        super(name);
    }

    public static Test suite() {
        return JavadocTextCompletionModelTest.buildModelTestSuite(JavadocTextCompletionModelTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setUpProjectOptions("1.4");
    }

    public void test001() throws JavaScriptModelException {
        String source = "package javadoc.text;\n/**\n * Completion on @ inside text\n */\npublic class BasicTestTextIns {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "@");
        this.assertResults("link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}\n" + "value[JSDOC_INLINE_TAG]{{@value}, null, null, value, null, " + this.positions + 8 + "}");
    }

    public void test002() throws JavaScriptModelException {
        String source = "package javadoc.text;\n/**\n * Completion on @s inside text\n */\npublic class BasicTestTextIns {}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "@s");
        this.assertResults("");
    }

    public void test003() throws JavaScriptModelException {
        this.setUpProjectOptions("1.4");
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion on @ inside text\n\t */\n\tint field;\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "@");
        this.assertResults("link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}\n" + "value[JSDOC_INLINE_TAG]{{@value}, null, null, value, null, " + this.positions + 8 + "}");
    }

    public void test004() throws JavaScriptModelException {
        this.setUpProjectOptions("1.4");
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion on @d inside text\n\t */\n\tint field;\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "@d");
        this.assertResults("docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}");
    }

    public void test005() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion on empty tag name: @\n\t */\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "@");
        this.assertResults("link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}\n" + "inheritDoc[JSDOC_INLINE_TAG]{{@inheritDoc}, null, null, inheritDoc, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}\n" + "value[JSDOC_INLINE_TAG]{{@value}, null, null, value, null, " + this.positions + 8 + "}");
    }

    public void test006() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion on impossible tag name: @ret\n\t */\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "@ret");
        this.assertResults("");
    }

    public void test007() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion on one letter: @l\n\t */\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "@l");
        this.assertResults("link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}");
    }

    public void test008() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion on started inline tag: {@li\n\t */\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "{@li");
        this.assertResults("link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}");
    }

    public void test009() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion with several letters:\n\t *\t\t@param str @inh\n\t */\n\tpublic void foo(String str) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "@inh");
        this.assertResults("inheritDoc[JSDOC_INLINE_TAG]{{@inheritDoc}, null, null, inheritDoc, null, " + this.positions + 8 + "}");
    }

    public void test010() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion with several letters:\n\t *\t\t@param str {@inh\n\t */\n\tpublic void foo(String str) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "{@inh");
        this.assertResults("inheritDoc[JSDOC_INLINE_TAG]{{@inheritDoc}, null, null, inheritDoc, null, " + this.positions + 8 + "}");
    }

    public void test011() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion on full tag name: {@docRoot}\n\t */\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "{@docRoot");
        this.assertResults("docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}");
    }

    public void test020() throws JavaScriptModelException {
        String source = "package javadoc.text;\n/**\n * Completion after: BasicTestTextIns\n */\npublic class BasicTestTextIns {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "BasicTestTextIns");
        this.assertSortedResults("BasicTestTextIns[JSDOC_TYPE_REF]{{@link BasicTestTextIns}, javadoc.text, Ljavadoc.text.BasicTestTextIns;, null, null, " + this.positions + 56 + "}\n" + "BasicTestTextIns[TYPE_REF]{BasicTestTextIns, javadoc.text, Ljavadoc.text.BasicTestTextIns;, null, null, " + this.positions + 25 + "}");
    }

    public void test021() throws JavaScriptModelException {
        String source = "package javadoc.text;\n/**\n * Completion after: {@link BasicTestTextIns\n */\npublic class BasicTestTextIns {\n}\nclass BasicTestTextInsException extends Exception{\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "BasicTestTextIns");
        this.assertSortedResults("BasicTestTextIns[TYPE_REF]{BasicTestTextIns, javadoc.text, Ljavadoc.text.BasicTestTextIns;, null, null, " + this.positions + 25 + "}\n" + "BasicTestTextInsException[TYPE_REF]{BasicTestTextInsException, javadoc.text, Ljavadoc.text.BasicTestTextInsException;, null, null, " + this.positions + 21 + "}");
    }

    public void test022() throws JavaScriptModelException {
        String source = "package javadoc.text;\n/**\n * Completion after: @link BasicTestTextIns\n */\npublic class BasicTestTextIns {\n\tpublic void foo() throws BasicTestTextInsException {}\n}\nclass BasicTestTextInsException extends Exception{\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "BasicTestTextIns");
        this.assertSortedResults("BasicTestTextIns[JSDOC_TYPE_REF]{{@link BasicTestTextIns}, javadoc.text, Ljavadoc.text.BasicTestTextIns;, null, null, " + this.positions + 56 + "}\n" + "BasicTestTextInsException[JSDOC_TYPE_REF]{{@link BasicTestTextInsException}, javadoc.text, Ljavadoc.text.BasicTestTextInsException;, null, null, " + this.positions + 52 + "}\n" + "BasicTestTextIns[TYPE_REF]{BasicTestTextIns, javadoc.text, Ljavadoc.text.BasicTestTextIns;, null, null, " + this.positions + 25 + "}\n" + "BasicTestTextInsException[TYPE_REF]{BasicTestTextInsException, javadoc.text, Ljavadoc.text.BasicTestTextInsException;, null, null, " + this.positions + 21 + "}");
    }

    public void test023() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: @link BasicTestTextIns\n\t */\n\tpublic void foo() throws BasicTestTextInsException {}\n}\nclass BasicTestTextInsException extends Exception{\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "BasicTestTextIns", 2);
        this.assertSortedResults("BasicTestTextInsException[JSDOC_TYPE_REF]{{@link BasicTestTextInsException}, javadoc.text, Ljavadoc.text.BasicTestTextInsException;, null, null, " + this.positions + 82 + "}\n" + "BasicTestTextIns[JSDOC_TYPE_REF]{{@link BasicTestTextIns}, javadoc.text, Ljavadoc.text.BasicTestTextIns;, null, null, " + this.positions + 56 + "}\n" + "BasicTestTextInsException[TYPE_REF]{BasicTestTextInsException, javadoc.text, Ljavadoc.text.BasicTestTextInsException;, null, null, " + this.positions + 51 + "}\n" + "BasicTestTextIns[TYPE_REF]{BasicTestTextIns, javadoc.text, Ljavadoc.text.BasicTestTextIns;, null, null, " + this.positions + 25 + "}");
    }

    public void test024() throws JavaScriptModelException {
        String source = "package javadoc.text;\n/**\n * Completion after: @see BasicTestTextIns\n */\npublic class BasicTestTextIns {\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "BasicTestTextIns");
        this.assertSortedResults("BasicTestTextIns[JSDOC_TYPE_REF]{{@link BasicTestTextIns}, javadoc.text, Ljavadoc.text.BasicTestTextIns;, null, null, " + this.positions + 56 + "}\n" + "BasicTestTextIns[TYPE_REF]{BasicTestTextIns, javadoc.text, Ljavadoc.text.BasicTestTextIns;, null, null, " + this.positions + 25 + "}");
    }

    public void test025() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: @see BasicTestTextIns\n\t */\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "BasicTestTextIns", 2);
        this.assertSortedResults("BasicTestTextIns[JSDOC_TYPE_REF]{{@link BasicTestTextIns}, javadoc.text, Ljavadoc.text.BasicTestTextIns;, null, null, " + this.positions + 56 + "}\n" + "BasicTestTextIns[TYPE_REF]{BasicTestTextIns, javadoc.text, Ljavadoc.text.BasicTestTextIns;, null, null, " + this.positions + 25 + "}");
    }

    public void test026() throws JavaScriptModelException {
        String source = "package javadoc.text;\n/**\n * Completion after: java.la\n */\npublic class BasicTestTextIns {\n\tpublic void foo() throws InterruptedException {\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "java.la");
        this.assertSortedResults("java.lang[PACKAGE_REF]{java.lang, java.lang, null, null, null, " + this.positions + 20 + "}");
    }

    public void test027() throws JavaScriptModelException {
        String source = "package javadoc.text;\n/**\n * Completion after: java.lang.I\n */\npublic class BasicTestTextIns {\n\tpublic void foo() throws InterruptedException {\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "java.lang.I");
        this.assertSortedResults("IllegalMonitorStateException[JSDOC_TYPE_REF]{{@link IllegalMonitorStateException}, java.lang, Ljava.lang.IllegalMonitorStateException;, null, null, " + this.positions + 49 + "}\n" + "InterruptedException[JSDOC_TYPE_REF]{{@link InterruptedException}, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 49 + "}\n" + "IllegalMonitorStateException[TYPE_REF]{IllegalMonitorStateException, java.lang, Ljava.lang.IllegalMonitorStateException;, null, null, " + this.positions + 18 + "}\n" + "InterruptedException[TYPE_REF]{InterruptedException, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 18 + "}");
    }

    public void test028() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: java.lang.I\n\t */\n\tpublic void foo() throws InterruptedException {\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "java.lang.I");
        this.assertSortedResults("InterruptedException[JSDOC_TYPE_REF]{{@link InterruptedException}, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 79 + "}\n" + "IllegalMonitorStateException[JSDOC_TYPE_REF]{{@link IllegalMonitorStateException}, java.lang, Ljava.lang.IllegalMonitorStateException;, null, null, " + this.positions + 49 + "}\n" + "InterruptedException[TYPE_REF]{InterruptedException, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 48 + "}\n" + "IllegalMonitorStateException[TYPE_REF]{IllegalMonitorStateException, java.lang, Ljava.lang.IllegalMonitorStateException;, null, null, " + this.positions + 18 + "}");
    }

    public void test030() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: #fo\n\t */\n\tint foo;\n}";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#fo");
        this.assertSortedResults("foo[JSDOC_FIELD_REF]{{@link #foo}, Ljavadoc.text.BasicTestTextIns;, I, foo, null, " + this.positions + 60 + "}");
    }

    public void test031() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: BasicTestTextIns#fo\n\t */\n\tstatic int foo;\n}";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "BasicTestTextIns#fo");
        this.assertSortedResults("foo[JSDOC_FIELD_REF]{{@link BasicTestTextIns#foo}, Ljavadoc.text.BasicTestTextIns;, I, foo, null, " + this.positions + 49 + "}\n" + "foo[JSDOC_VALUE_REF]{{@value BasicTestTextIns#foo}, Ljavadoc.text.BasicTestTextIns;, I, foo, null, " + this.positions + 49 + "}");
    }

    public void test032() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: javadoc.text.BasicTestTextIns#fo\n\t */\n\tint foo;\n}";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "javadoc.text.BasicTestTextIns#fo");
        this.assertSortedResults("foo[JSDOC_FIELD_REF]{{@link javadoc.text.BasicTestTextIns#foo}, Ljavadoc.text.BasicTestTextIns;, I, foo, null, " + this.positions + 60 + "}");
    }

    public void test033() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/text/BasicTestTextIns.js", "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: OtherFields#fo\n\t */\n\tint foo;\n}", "/Completion/src/javadoc/text/OtherFields.js", "package javadoc.text;\npublic class OtherFields {\n\tstatic int foo;\n}"};
        this.completeInJavadoc(sources, true, "OtherFields#fo");
        this.assertSortedResults("foo[JSDOC_FIELD_REF]{{@link OtherFields#foo}, Ljavadoc.text.OtherFields;, I, foo, null, " + this.positions + 49 + "}\n" + "foo[JSDOC_VALUE_REF]{{@value OtherFields#foo}, Ljavadoc.text.OtherFields;, I, foo, null, " + this.positions + 49 + "}");
    }

    public void test034() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: {@value #fo\n\t *\t\tNote: this test must be run with 1.4 compliance\n\t */\n\tint foo;\n}";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "fo");
        this.assertSortedResults("foo[FIELD_REF]{foo, Ljavadoc.text.BasicTestTextIns;, I, foo, null, " + this.positions + 29 + "}");
    }

    public void test035() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: {@value #fo\n\t *\t\tNote: this test must be run with 1.5 compliance\n\t */\n\tint foo;\n}";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "fo");
        this.assertSortedResults("foo[FIELD_REF]{foo, Ljavadoc.text.BasicTestTextIns;, I, foo, null, " + this.positions + 29 + "}");
    }

    public void test036() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: {@link BasicTestTextIns#fo\n\t */\n\tstatic int foo;\n}";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "fo");
        this.assertSortedResults("foo[FIELD_REF]{foo, Ljavadoc.text.BasicTestTextIns;, I, foo, null, " + this.positions + 18 + "}");
    }

    public void test037() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: {@link javadoc.text.BasicTestTextIns#fo }\n\t */\n\tint foo;\n}";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "fo");
        this.assertSortedResults("foo[FIELD_REF]{foo, Ljavadoc.text.BasicTestTextIns;, I, foo, null, " + this.positions + 29 + "}");
    }

    public void test038() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String[] sources = new String[]{"/Completion/src/javadoc/text/BasicTestTextIns.js", "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: {@value OtherFields#fo\n\t *\t\tNote: this test must be run with 1.5 compliance\n\t */\n\tint foo;\n}", "/Completion/src/javadoc/text/OtherFields.js", "package javadoc.text;\npublic class OtherFields {\n\tstatic int foo;\n}"};
        this.completeInJavadoc(sources, true, "fo");
        this.assertSortedResults("foo[FIELD_REF]{foo, Ljavadoc.text.OtherFields;, I, foo, null, " + this.positions + 18 + "}");
    }

    public void test040() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: meth\n\t */\n\tvoid method() {}\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "meth");
        this.assertSortedResults("");
    }

    public void test041() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: #meth\n\t */\n\tvoid method() {}\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#meth");
        this.assertSortedResults("method[JSDOC_METHOD_REF]{{@link #method()}, Ljavadoc.text.BasicTestTextIns;, ()V, method, null, " + this.positions + 60 + "}");
    }

    public void test042() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: #meth with text after\n\t */\n\tvoid method() {}\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#meth");
        this.assertSortedResults("method[JSDOC_METHOD_REF]{{@link #method()}, Ljavadoc.text.BasicTestTextIns;, ()V, method, null, " + this.positions + 60 + "}");
    }

    public void test043() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: #method\n\t */\n\tvoid method() {}\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#meth");
        this.assertSortedResults("method[JSDOC_METHOD_REF]{{@link #method()}, Ljavadoc.text.BasicTestTextIns;, ()V, method, null, " + this.positions + 60 + "}");
    }

    public void test044() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: BasicTestTextIns#param\n\t */\n\tvoid method() {}\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "BasicTestTextIns#param");
        this.assertSortedResults("paramMethod[JSDOC_METHOD_REF]{{@link BasicTestTextIns#paramMethod(String, boolean, Object)}, Ljavadoc.text.BasicTestTextIns;, (Ljava.lang.String;ZLjava.lang.Object;)V, paramMethod, (str, flag, obj), " + this.positions + 60 + "}");
    }

    public void test045() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: javadoc.text.BasicTestTextIns#meth\n\t */\n\tvoid method() {}\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "javadoc.text.BasicTestTextIns#meth");
        this.assertSortedResults("method[JSDOC_METHOD_REF]{{@link javadoc.text.BasicTestTextIns#method()}, Ljavadoc.text.BasicTestTextIns;, ()V, method, null, " + this.positions + 60 + "}");
    }

    public void test046() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after: {@link #param\n\t */\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "param");
        this.assertSortedResults("paramMethod[FUNCTION_REF]{paramMethod(String, boolean, Object), Ljavadoc.text.BasicTestTextIns;, (Ljava.lang.String;ZLjava.lang.Object;)V, paramMethod, (str, flag, obj), " + this.positions + 29 + "}");
    }

    public void test047() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: {@link BasicTestTextIns#meth\n\t */\n\tvoid method() {}\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "meth");
        this.assertSortedResults("method[FUNCTION_REF]{method(), Ljavadoc.text.BasicTestTextIns;, ()V, method, null, " + this.positions + 29 + "}");
    }

    public void test048() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after: {@link javadoc.text.BasicTestTextIns#param }\n\t */\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "param");
        this.assertSortedResults("paramMethod[FUNCTION_REF]{paramMethod(String, boolean, Object), Ljavadoc.text.BasicTestTextIns;, (Ljava.lang.String;ZLjava.lang.Object;)V, paramMethod, (str, flag, obj), " + this.positions + 29 + "}");
    }

    public void test049() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/text/BasicTestTextIns.js", "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: OtherTypes#meth\n\t */\n\tvoid foo() {};\n}", "/Completion/src/javadoc/text/OtherTypes.js", "package javadoc.text;\npublic class OtherTypes {\n\tvoid method() {};\n}"};
        this.completeInJavadoc(sources, true, "OtherTypes#meth");
        this.assertSortedResults("method[JSDOC_METHOD_REF]{{@link OtherTypes#method()}, Ljavadoc.text.OtherTypes;, ()V, method, null, " + this.positions + 60 + "}");
    }

    public void test050() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/text/BasicTestTextIns.js", "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: {@link OtherTypes#method }\n\t */\n\tvoid foo() {};\n}", "/Completion/src/javadoc/text/OtherTypes.js", "package javadoc.text;\npublic class OtherTypes {\n\tvoid method() {};\n}"};
        this.completeInJavadoc(sources, true, "meth");
        this.assertSortedResults("method[FUNCTION_REF]{method(), Ljavadoc.text.OtherTypes;, ()V, method, null, " + this.positions + 29 + "}");
    }

    public void test051() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: #\n\t */\n\tvoid method() {}\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#");
        this.assertSortedResults("clone[JSDOC_METHOD_REF]{{@link #clone()}, Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 60 + "}\n" + "equals[JSDOC_METHOD_REF]{{@link #equals(Object)}, Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, null, " + this.positions + 60 + "}\n" + "finalize[JSDOC_METHOD_REF]{{@link #finalize()}, Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 60 + "}\n" + "getClass[JSDOC_METHOD_REF]{{@link #getClass()}, Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 60 + "}\n" + "hashCode[JSDOC_METHOD_REF]{{@link #hashCode()}, Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 60 + "}\n" + "method[JSDOC_METHOD_REF]{{@link #method()}, Ljavadoc.text.BasicTestTextIns;, ()V, method, null, " + this.positions + 60 + "}\n" + "notify[JSDOC_METHOD_REF]{{@link #notify()}, Ljava.lang.Object;, ()V, notify, null, " + this.positions + 60 + "}\n" + "notifyAll[JSDOC_METHOD_REF]{{@link #notifyAll()}, Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 60 + "}\n" + "paramMethod[JSDOC_METHOD_REF]{{@link #paramMethod(String, boolean, Object)}, Ljavadoc.text.BasicTestTextIns;, (Ljava.lang.String;ZLjava.lang.Object;)V, paramMethod, (str, flag, obj), " + this.positions + 60 + "}\n" + "toString[JSDOC_METHOD_REF]{{@link #toString()}, Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 60 + "}\n" + "wait[JSDOC_METHOD_REF]{{@link #wait(long, int)}, Ljava.lang.Object;, (JI)V, wait, null, " + this.positions + 60 + "}\n" + "wait[JSDOC_METHOD_REF]{{@link #wait(long)}, Ljava.lang.Object;, (J)V, wait, null, " + this.positions + 60 + "}\n" + "wait[JSDOC_METHOD_REF]{{@link #wait()}, Ljava.lang.Object;, ()V, wait, null, " + this.positions + 60 + "}\n" + "BasicTestTextIns[JSDOC_METHOD_REF]{{@link #BasicTestTextIns()}, Ljavadoc.text.BasicTestTextIns;, ()V, BasicTestTextIns, null, " + this.positions + 39 + "}");
    }

    public void test052() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: #method\n\t */\n\tvoid method() {}\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#");
        this.assertSortedResults("clone[JSDOC_METHOD_REF]{{@link #clone()}, Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 60 + "}\n" + "equals[JSDOC_METHOD_REF]{{@link #equals(Object)}, Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, null, " + this.positions + 60 + "}\n" + "finalize[JSDOC_METHOD_REF]{{@link #finalize()}, Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 60 + "}\n" + "getClass[JSDOC_METHOD_REF]{{@link #getClass()}, Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 60 + "}\n" + "hashCode[JSDOC_METHOD_REF]{{@link #hashCode()}, Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 60 + "}\n" + "method[JSDOC_METHOD_REF]{{@link #method()}, Ljavadoc.text.BasicTestTextIns;, ()V, method, null, " + this.positions + 60 + "}\n" + "notify[JSDOC_METHOD_REF]{{@link #notify()}, Ljava.lang.Object;, ()V, notify, null, " + this.positions + 60 + "}\n" + "notifyAll[JSDOC_METHOD_REF]{{@link #notifyAll()}, Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 60 + "}\n" + "paramMethod[JSDOC_METHOD_REF]{{@link #paramMethod(String, boolean, Object)}, Ljavadoc.text.BasicTestTextIns;, (Ljava.lang.String;ZLjava.lang.Object;)V, paramMethod, (str, flag, obj), " + this.positions + 60 + "}\n" + "toString[JSDOC_METHOD_REF]{{@link #toString()}, Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 60 + "}\n" + "wait[JSDOC_METHOD_REF]{{@link #wait(long, int)}, Ljava.lang.Object;, (JI)V, wait, null, " + this.positions + 60 + "}\n" + "wait[JSDOC_METHOD_REF]{{@link #wait(long)}, Ljava.lang.Object;, (J)V, wait, null, " + this.positions + 60 + "}\n" + "wait[JSDOC_METHOD_REF]{{@link #wait()}, Ljava.lang.Object;, ()V, wait, null, " + this.positions + 60 + "}\n" + "BasicTestTextIns[JSDOC_METHOD_REF]{{@link #BasicTestTextIns()}, Ljavadoc.text.BasicTestTextIns;, ()V, BasicTestTextIns, null, " + this.positions + 39 + "}");
    }

    public void test053() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: {@link BasicTestTextIns#\n\t */\n\tvoid method() {}\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#", 0);
        this.assertSortedResults("clone[FUNCTION_REF]{clone(), Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 29 + "}\n" + "equals[FUNCTION_REF]{equals(Object), Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, (obj), " + this.positions + 29 + "}\n" + "finalize[FUNCTION_REF]{finalize(), Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 29 + "}\n" + "getClass[FUNCTION_REF]{getClass(), Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 29 + "}\n" + "hashCode[FUNCTION_REF]{hashCode(), Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 29 + "}\n" + "method[FUNCTION_REF]{method(), Ljavadoc.text.BasicTestTextIns;, ()V, method, null, " + this.positions + 29 + "}\n" + "notify[FUNCTION_REF]{notify(), Ljava.lang.Object;, ()V, notify, null, " + this.positions + 29 + "}\n" + "notifyAll[FUNCTION_REF]{notifyAll(), Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 29 + "}\n" + "paramMethod[FUNCTION_REF]{paramMethod(String, boolean, Object), Ljavadoc.text.BasicTestTextIns;, (Ljava.lang.String;ZLjava.lang.Object;)V, paramMethod, (str, flag, obj), " + this.positions + 29 + "}\n" + "toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long, int), Ljava.lang.Object;, (JI)V, wait, (millis, nanos), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long), Ljava.lang.Object;, (J)V, wait, (millis), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(), Ljava.lang.Object;, ()V, wait, null, " + this.positions + 29 + "}\n" + "BasicTestTextIns[FUNCTION_REF<CONSTRUCTOR>]{BasicTestTextIns(), Ljavadoc.text.BasicTestTextIns;, ()V, BasicTestTextIns, null, " + this.positions + 8 + "}");
    }

    public void test054() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: {@link javadoc.text.BasicTestTextIns# }\n\t */\n\tvoid method() {}\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#", 0);
        this.assertSortedResults("clone[FUNCTION_REF]{clone(), Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 29 + "}\n" + "equals[FUNCTION_REF]{equals(Object), Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, (obj), " + this.positions + 29 + "}\n" + "finalize[FUNCTION_REF]{finalize(), Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 29 + "}\n" + "getClass[FUNCTION_REF]{getClass(), Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 29 + "}\n" + "hashCode[FUNCTION_REF]{hashCode(), Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 29 + "}\n" + "method[FUNCTION_REF]{method(), Ljavadoc.text.BasicTestTextIns;, ()V, method, null, " + this.positions + 29 + "}\n" + "notify[FUNCTION_REF]{notify(), Ljava.lang.Object;, ()V, notify, null, " + this.positions + 29 + "}\n" + "notifyAll[FUNCTION_REF]{notifyAll(), Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 29 + "}\n" + "paramMethod[FUNCTION_REF]{paramMethod(String, boolean, Object), Ljavadoc.text.BasicTestTextIns;, (Ljava.lang.String;ZLjava.lang.Object;)V, paramMethod, (str, flag, obj), " + this.positions + 29 + "}\n" + "toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long, int), Ljava.lang.Object;, (JI)V, wait, (millis, nanos), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long), Ljava.lang.Object;, (J)V, wait, (millis), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(), Ljava.lang.Object;, ()V, wait, null, " + this.positions + 29 + "}\n" + "BasicTestTextIns[FUNCTION_REF<CONSTRUCTOR>]{BasicTestTextIns(), Ljavadoc.text.BasicTestTextIns;, ()V, BasicTestTextIns, null, " + this.positions + 8 + "}");
    }

    public void test055() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after: #paramMethod(\n\t */\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#paramMethod(");
        this.assertSortedResults("paramMethod[JSDOC_METHOD_REF]{{@link #paramMethod(String, boolean, Object)}, Ljavadoc.text.BasicTestTextIns;, (Ljava.lang.String;ZLjava.lang.Object;)V, paramMethod, (str, flag, obj), " + this.positions + 56 + "}");
    }

    public void test056() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after: {@link #paramMethod(Str\n\t */\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "Str");
        this.assertSortedResults("String[TYPE_REF]{String, java.lang, Ljava.lang.String;, null, null, " + this.positions + 21 + "}");
    }

    public void test057() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after: {@link #paramMethod(String s\n\t */\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "paramMethod(String s");
        this.assertSortedResults("paramMethod[FUNCTION_REF]{paramMethod(String, boolean, Object), Ljavadoc.text.BasicTestTextIns;, (Ljava.lang.String;ZLjava.lang.Object;)V, paramMethod, (str, flag, obj), " + this.positions + 25 + "}");
    }

    public void test058() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after: #paramMethod(String str, \n\t */\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#paramMethod(String str,");
        this.assertSortedResults("paramMethod[JSDOC_METHOD_REF]{{@link #paramMethod(String, boolean, Object)}, Ljavadoc.text.BasicTestTextIns;, (Ljava.lang.String;ZLjava.lang.Object;)V, paramMethod, (str, flag, obj), " + this.positions + 56 + "}");
    }

    public void test059() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after: {@link #paramMethod(String,\n\t */\n\tvoid paramMethod(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "paramMethod(String,");
        this.assertSortedResults("paramMethod[FUNCTION_REF]{paramMethod(String, boolean, Object), Ljavadoc.text.BasicTestTextIns;, (Ljava.lang.String;ZLjava.lang.Object;)V, paramMethod, (str, flag, obj), " + this.positions + 25 + "}");
    }

    public void test070() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: #BasicTest\n\t */\n\tBasicTestTextIns() {}\n\tBasicTestTextIns(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#BasicTest");
        this.assertSortedResults("BasicTestTextIns[JSDOC_METHOD_REF]{{@link #BasicTestTextIns(int, float, Class)}, Ljavadoc.text.BasicTestTextIns;, (IFLjava.lang.Class;)V, BasicTestTextIns, (xxx, real, clazz), " + this.positions + 39 + "}\n" + "BasicTestTextIns[JSDOC_METHOD_REF]{{@link #BasicTestTextIns()}, Ljavadoc.text.BasicTestTextIns;, ()V, BasicTestTextIns, null, " + this.positions + 39 + "}");
    }

    public void test071() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: {@link BasicTestTextIns#BasicTest\n\t */\n\tBasicTestTextIns() {}\n\tBasicTestTextIns(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "BasicTest", 3);
        this.assertSortedResults("BasicTestTextIns[FUNCTION_REF<CONSTRUCTOR>]{BasicTestTextIns(int, float, Class), Ljavadoc.text.BasicTestTextIns;, (IFLjava.lang.Class;)V, BasicTestTextIns, (xxx, real, clazz), " + this.positions + 8 + "}\n" + "BasicTestTextIns[FUNCTION_REF<CONSTRUCTOR>]{BasicTestTextIns(), Ljavadoc.text.BasicTestTextIns;, ()V, BasicTestTextIns, null, " + this.positions + 8 + "}");
    }

    public void test072() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: {@linkplain javadoc.text.BasicTestTextIns#BasicTest }\n\t */\n\tBasicTestTextIns() {}\n\tBasicTestTextIns(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "BasicTest", 3);
        this.assertSortedResults("BasicTestTextIns[FUNCTION_REF<CONSTRUCTOR>]{BasicTestTextIns(int, float, Class), Ljavadoc.text.BasicTestTextIns;, (IFLjava.lang.Class;)V, BasicTestTextIns, (xxx, real, clazz), " + this.positions + 8 + "}\n" + "BasicTestTextIns[FUNCTION_REF<CONSTRUCTOR>]{BasicTestTextIns(), Ljavadoc.text.BasicTestTextIns;, ()V, BasicTestTextIns, null, " + this.positions + 8 + "}");
    }

    public void test073() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/text/BasicTestTextIns.js", "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: OtherTypes#Other\n\t */\n\tvoid foo() {};\n}", "/Completion/src/javadoc/text/OtherTypes.js", "package javadoc.text;\npublic class OtherTypes {\n\tOtherTypes() {};\n}"};
        this.completeInJavadoc(sources, true, "OtherTypes#O");
        this.assertSortedResults("OtherTypes[JSDOC_METHOD_REF]{{@link OtherTypes#OtherTypes()}, Ljavadoc.text.OtherTypes;, ()V, OtherTypes, null, " + this.positions + 39 + "}");
    }

    public void test074() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/text/BasicTestTextIns.js", "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: {@link OtherTypes#O implicit default constructor\n\t */\n\tvoid foo() {};\n}", "/Completion/src/javadoc/text/OtherTypes.js", "package javadoc.text;\npublic class OtherTypes {\n}"};
        this.completeInJavadoc(sources, true, "O", 2);
        this.assertSortedResults("OtherTypes[FUNCTION_REF<CONSTRUCTOR>]{OtherTypes(), Ljavadoc.text.OtherTypes;, ()V, OtherTypes, null, " + this.positions + 8 + "}");
    }

    public void test075() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: #\n\t */\n\tBasicTestTextIns() {}\n\tBasicTestTextIns(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#");
        this.assertSortedResults("clone[JSDOC_METHOD_REF]{{@link #clone()}, Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 60 + "}\n" + "equals[JSDOC_METHOD_REF]{{@link #equals(Object)}, Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, null, " + this.positions + 60 + "}\n" + "finalize[JSDOC_METHOD_REF]{{@link #finalize()}, Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 60 + "}\n" + "getClass[JSDOC_METHOD_REF]{{@link #getClass()}, Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 60 + "}\n" + "hashCode[JSDOC_METHOD_REF]{{@link #hashCode()}, Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 60 + "}\n" + "notify[JSDOC_METHOD_REF]{{@link #notify()}, Ljava.lang.Object;, ()V, notify, null, " + this.positions + 60 + "}\n" + "notifyAll[JSDOC_METHOD_REF]{{@link #notifyAll()}, Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 60 + "}\n" + "toString[JSDOC_METHOD_REF]{{@link #toString()}, Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 60 + "}\n" + "wait[JSDOC_METHOD_REF]{{@link #wait(long, int)}, Ljava.lang.Object;, (JI)V, wait, null, " + this.positions + 60 + "}\n" + "wait[JSDOC_METHOD_REF]{{@link #wait(long)}, Ljava.lang.Object;, (J)V, wait, null, " + this.positions + 60 + "}\n" + "wait[JSDOC_METHOD_REF]{{@link #wait()}, Ljava.lang.Object;, ()V, wait, null, " + this.positions + 60 + "}\n" + "BasicTestTextIns[JSDOC_METHOD_REF]{{@link #BasicTestTextIns(int, float, Class)}, Ljavadoc.text.BasicTestTextIns;, (IFLjava.lang.Class;)V, BasicTestTextIns, (xxx, real, clazz), " + this.positions + 39 + "}\n" + "BasicTestTextIns[JSDOC_METHOD_REF]{{@link #BasicTestTextIns()}, Ljavadoc.text.BasicTestTextIns;, ()V, BasicTestTextIns, null, " + this.positions + 39 + "}");
    }

    public void test076() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: #blabla\n\t */\n\tBasicTestTextIns() {}\n\tBasicTestTextIns(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#");
        this.assertSortedResults("clone[JSDOC_METHOD_REF]{{@link #clone()}, Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 60 + "}\n" + "equals[JSDOC_METHOD_REF]{{@link #equals(Object)}, Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, null, " + this.positions + 60 + "}\n" + "finalize[JSDOC_METHOD_REF]{{@link #finalize()}, Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 60 + "}\n" + "getClass[JSDOC_METHOD_REF]{{@link #getClass()}, Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 60 + "}\n" + "hashCode[JSDOC_METHOD_REF]{{@link #hashCode()}, Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 60 + "}\n" + "notify[JSDOC_METHOD_REF]{{@link #notify()}, Ljava.lang.Object;, ()V, notify, null, " + this.positions + 60 + "}\n" + "notifyAll[JSDOC_METHOD_REF]{{@link #notifyAll()}, Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 60 + "}\n" + "toString[JSDOC_METHOD_REF]{{@link #toString()}, Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 60 + "}\n" + "wait[JSDOC_METHOD_REF]{{@link #wait(long, int)}, Ljava.lang.Object;, (JI)V, wait, null, " + this.positions + 60 + "}\n" + "wait[JSDOC_METHOD_REF]{{@link #wait(long)}, Ljava.lang.Object;, (J)V, wait, null, " + this.positions + 60 + "}\n" + "wait[JSDOC_METHOD_REF]{{@link #wait()}, Ljava.lang.Object;, ()V, wait, null, " + this.positions + 60 + "}\n" + "BasicTestTextIns[JSDOC_METHOD_REF]{{@link #BasicTestTextIns(int, float, Class)}, Ljavadoc.text.BasicTestTextIns;, (IFLjava.lang.Class;)V, BasicTestTextIns, (xxx, real, clazz), " + this.positions + 39 + "}\n" + "BasicTestTextIns[JSDOC_METHOD_REF]{{@link #BasicTestTextIns()}, Ljavadoc.text.BasicTestTextIns;, ()V, BasicTestTextIns, null, " + this.positions + 39 + "}");
    }

    public void test077() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after: {@link # }\n\t */\n\tBasicTestTextIns() {}\n\tBasicTestTextIns(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#", 0);
        this.assertSortedResults("clone[FUNCTION_REF]{clone(), Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 29 + "}\n" + "equals[FUNCTION_REF]{equals(Object), Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, (obj), " + this.positions + 29 + "}\n" + "finalize[FUNCTION_REF]{finalize(), Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 29 + "}\n" + "getClass[FUNCTION_REF]{getClass(), Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 29 + "}\n" + "hashCode[FUNCTION_REF]{hashCode(), Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 29 + "}\n" + "notify[FUNCTION_REF]{notify(), Ljava.lang.Object;, ()V, notify, null, " + this.positions + 29 + "}\n" + "notifyAll[FUNCTION_REF]{notifyAll(), Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 29 + "}\n" + "toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long, int), Ljava.lang.Object;, (JI)V, wait, (millis, nanos), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long), Ljava.lang.Object;, (J)V, wait, (millis), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(), Ljava.lang.Object;, ()V, wait, null, " + this.positions + 29 + "}\n" + "BasicTestTextIns[FUNCTION_REF<CONSTRUCTOR>]{BasicTestTextIns(int, float, Class), Ljavadoc.text.BasicTestTextIns;, (IFLjava.lang.Class;)V, BasicTestTextIns, (xxx, real, clazz), " + this.positions + 8 + "}\n" + "BasicTestTextIns[FUNCTION_REF<CONSTRUCTOR>]{BasicTestTextIns(), Ljavadoc.text.BasicTestTextIns;, ()V, BasicTestTextIns, null, " + this.positions + 8 + "}");
    }

    public void test078() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after: {@link #BasicTestTextIns(\n\t */\n\tBasicTestTextIns(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "BasicTestTextIns(");
        this.assertSortedResults("BasicTestTextIns[FUNCTION_REF<CONSTRUCTOR>]{BasicTestTextIns(int, float, Class), Ljavadoc.text.BasicTestTextIns;, (IFLjava.lang.Class;)V, BasicTestTextIns, (xxx, real, clazz), " + this.positions + 8 + "}");
    }

    public void test079() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after: BasicTestTextIns#BasicTestTextIns(int,\n\t */\n\tBasicTestTextIns() {}\n\tBasicTestTextIns(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "BasicTestTextIns#BasicTestTextIns(int,");
        this.assertSortedResults("BasicTestTextIns[JSDOC_METHOD_REF]{{@link BasicTestTextIns#BasicTestTextIns(int, float, Class)}, Ljavadoc.text.BasicTestTextIns;, (IFLjava.lang.Class;)V, BasicTestTextIns, (xxx, real, clazz), " + this.positions + 39 + "}");
    }

    public void test080() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after: BasicTestTextIns#BasicTestTextIns(int,\n\t * \tNote: completion takes place just after opening brace\n\t */\n\tBasicTestTextIns() {}\n\tBasicTestTextIns(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "BasicTestTextIns#BasicTestTextIns(");
        this.assertSortedResults("BasicTestTextIns[JSDOC_METHOD_REF]{{@link BasicTestTextIns#BasicTestTextIns(int, float, Class)}, Ljavadoc.text.BasicTestTextIns;, (IFLjava.lang.Class;)V, BasicTestTextIns, (xxx, real, clazz), " + this.positions + 39 + "}\n" + "BasicTestTextIns[JSDOC_METHOD_REF]{{@link BasicTestTextIns#BasicTestTextIns()}, Ljavadoc.text.BasicTestTextIns;, ()V, BasicTestTextIns, null, " + this.positions + 39 + "}");
    }

    public void test081() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\t/**\n\t * Completion after:\n\t * \tjavadoc.text.BasicTestTextIns#BasicTestTextIns(\n\t */\n\tvoid method() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "javadoc.text.BasicTestTextIns#BasicTestTextIns(");
        this.assertSortedResults("BasicTestTextIns[JSDOC_METHOD_REF]{{@link javadoc.text.BasicTestTextIns#BasicTestTextIns()}, Ljavadoc.text.BasicTestTextIns;, ()V, BasicTestTextIns, null, " + this.positions + 39 + "}");
    }

    public void test082() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after:\n\t * \t#BasicTestTextIns(int, float, java.lang.\n\t */\n\tBasicTestTextIns(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#BasicTestTextIns(int, float, java.lang.");
        this.assertSortedResults("BasicTestTextIns[JSDOC_METHOD_REF]{{@link #BasicTestTextIns(int, float, Class)}, Ljavadoc.text.BasicTestTextIns;, (IFLjava.lang.Class;)V, BasicTestTextIns, (xxx, real, clazz), " + this.positions + 39 + "}");
    }

    public void test083() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after:\n\t * \t#BasicTestTextIns(int, float, java.lang.Cla\n\t */\n\tBasicTestTextIns(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#BasicTestTextIns(int, float, java.lang.Cla");
        this.assertSortedResults("BasicTestTextIns[JSDOC_METHOD_REF]{{@link #BasicTestTextIns(int, float, Class)}, Ljavadoc.text.BasicTestTextIns;, (IFLjava.lang.Class;)V, BasicTestTextIns, (xxx, real, clazz), " + this.positions + 39 + "}");
    }

    public void test084() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after:\n\t * \t#BasicTestTextIns(int, float, Class)\n\t * \tNote: completion takes place before closing parenthesis\n\t */\n\tBasicTestTextIns(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#BasicTestTextIns(int, float, Class");
        this.assertSortedResults("BasicTestTextIns[JSDOC_METHOD_REF]{{@link #BasicTestTextIns(int, float, Class)}, Ljavadoc.text.BasicTestTextIns;, (IFLjava.lang.Class;)V, BasicTestTextIns, (xxx, real, clazz), " + this.positions + 39 + "}");
    }

    public void test085() throws JavaScriptModelException {
        String source = "package javadoc.text;\npublic class BasicTestTextIns {\n\tvoid method() {}\n\t/**\n\t * Completion after:\n\t * \t#BasicTestTextIns(int, float, Class)\n\t * \tNote: completion takes place after closing parenthesis\n\t */\n\tBasicTestTextIns(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/text/BasicTestTextIns.js", source, true, "#BasicTestTextIns(int, float, Class)");
        this.assertSortedResults("");
    }
}

