/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;

public class PositionUpdatingCornerCasesTest
extends TestCase {
    private IDocument fDocument;

    public PositionUpdatingCornerCasesTest(String name) {
        super(name);
    }

    protected void checkPositions(Position[] expected) throws BadPositionCategoryException {
        Position[] actual = this.fDocument.getPositions("__dflt_position_category");
        PositionUpdatingCornerCasesTest.assertTrue((String)"invalid number of positions", (actual.length == expected.length ? 1 : 0) != 0);
        int i = 0;
        while (i < expected.length) {
            PositionUpdatingCornerCasesTest.assertEquals((String)(String.valueOf(this.print(actual[i])) + " != " + this.print(expected[i])), (Object)expected[i], (Object)actual[i]);
            ++i;
        }
    }

    protected String print(Position p) {
        return "[" + p.getOffset() + "," + p.getLength() + "]";
    }

    protected void setUp() throws Exception {
        this.fDocument = this.createDocument("x-x-x-x-x-x-x-x-x-x-x");
        this.fDocument.addPosition(new Position(0, 0));
        this.fDocument.addPosition(new Position(0, 1));
        this.fDocument.addPosition(new Position(5, 0));
        this.fDocument.addPosition(new Position(5, 3));
    }

    private IDocument createDocument(String contents) {
        IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerForContentTypeId("org.eclipse.core.runtime.xml");
        BasicStructuredDocument document = (BasicStructuredDocument)handler.getDocumentLoader().createNewStructuredDocument();
        document.set(contents);
        return document;
    }

    public static Test suite() {
        return new TestSuite(PositionUpdatingCornerCasesTest.class);
    }

    protected void tearDown() {
        this.fDocument = null;
    }

    public void testInsert() throws Exception {
        this.fDocument.replace(0, 0, "yy");
        Position[] positions = new Position[]{new Position(2, 1), new Position(2, 0), new Position(7, 3), new Position(7, 0)};
        this.checkPositions(positions);
    }
}

