/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.IsNotNull;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.CompoundPredicate;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class XORTests
extends TestCase {
    private CompoundPredicate<Number> xorPredicate;

    public XORTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.xorPredicate = PredicateTools.xor(this.buildMin(1.0), this.buildMax(10.0));
    }

    private Predicate<Number> buildMin(double min) {
        return new Min(min);
    }

    private Predicate<Number> buildMax(double max) {
        return new Max(max);
    }

    private Predicate<Number> buildIsEven() {
        return new IsEven();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testPredicateing2() {
        XORTests.assertFalse((boolean)this.xorPredicate.evaluate((Object)new Integer(7)));
        XORTests.assertFalse((boolean)this.xorPredicate.evaluate((Object)new Integer(2)));
        XORTests.assertFalse((boolean)this.xorPredicate.evaluate((Object)new Double(6.666)));
        XORTests.assertTrue((boolean)this.xorPredicate.evaluate((Object)new Double(-99.0)));
        XORTests.assertTrue((boolean)this.xorPredicate.evaluate((Object)new Double(-1.0)));
        XORTests.assertTrue((boolean)this.xorPredicate.evaluate((Object)new Double(11.0)));
        XORTests.assertTrue((boolean)this.xorPredicate.evaluate((Object)new Double(111.0)));
    }

    public void testPredicateing3() {
        CompoundPredicate xorPredicate2 = PredicateTools.xor(this.xorPredicate, this.buildIsEven());
        XORTests.assertFalse((boolean)xorPredicate2.evaluate((Object)new Integer(7)));
        XORTests.assertFalse((boolean)xorPredicate2.evaluate((Object)new Integer(3)));
        XORTests.assertFalse((boolean)xorPredicate2.evaluate((Object)new Integer(9)));
        XORTests.assertTrue((boolean)xorPredicate2.evaluate((Object)new Integer(2)));
        XORTests.assertTrue((boolean)xorPredicate2.evaluate((Object)new Double(6.1)));
        XORTests.assertTrue((boolean)xorPredicate2.evaluate((Object)new Double(-99.0)));
        XORTests.assertTrue((boolean)xorPredicate2.evaluate((Object)new Double(-1.0)));
        XORTests.assertTrue((boolean)xorPredicate2.evaluate((Object)new Double(11.0)));
        XORTests.assertTrue((boolean)xorPredicate2.evaluate((Object)new Double(111.0)));
        XORTests.assertFalse((boolean)xorPredicate2.evaluate((Object)new Double(-98.0)));
        XORTests.assertFalse((boolean)xorPredicate2.evaluate((Object)new Double(0.0)));
        XORTests.assertFalse((boolean)xorPredicate2.evaluate((Object)new Double(-2.0)));
        XORTests.assertFalse((boolean)xorPredicate2.evaluate((Object)new Double(12.0)));
        XORTests.assertFalse((boolean)xorPredicate2.evaluate((Object)new Double(222.0)));
    }

    public void testEquals() {
        CompoundPredicate xorPredicate2 = PredicateTools.xor(this.buildMin(1.0), this.buildMax(10.0));
        XORTests.assertEquals(this.xorPredicate, (Object)xorPredicate2);
        XORTests.assertEquals((int)this.xorPredicate.hashCode(), (int)xorPredicate2.hashCode());
        XORTests.assertFalse((boolean)this.xorPredicate.equals((Object)IsNotNull.instance()));
    }

    static class IsEven
    extends PredicateAdapter<Number> {
        IsEven() {
        }

        public boolean evaluate(Number number) {
            return BitTools.isEven((int)number.intValue());
        }
    }

    static class Max
    extends CriterionPredicate<Number, Number> {
        Max(double max) {
            super((Object)new Double(max));
        }

        public boolean evaluate(Number number) {
            return number.doubleValue() >= ((Number)this.criterion).doubleValue();
        }
    }

    static class Min
    extends CriterionPredicate<Number, Number> {
        Min(double min) {
            super((Object)new Double(min));
        }

        public boolean evaluate(Number number) {
            return number.doubleValue() <= ((Number)this.criterion).doubleValue();
        }
    }
}

