/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.Collection;
import java.util.Iterator;
import javax.swing.JList;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ListModelAdapter;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.model.value.CoordinatedBag;
import org.eclipse.jpt.common.utility.tests.internal.model.value.CoordinatedList;

public class CollectionListValueModelAdapterTests
extends TestCase {
    private ListValueModel<String> adapter;
    private SimpleCollectionValueModel<String> wrappedCollectionHolder;
    private Collection<String> wrappedCollection;

    public CollectionListValueModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.wrappedCollection = new HashBag();
        this.wrappedCollectionHolder = new SimpleCollectionValueModel(this.wrappedCollection);
        this.adapter = new CollectionListValueModelAdapter(this.wrappedCollectionHolder);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator() {
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListChangeListener(this){

            @Override
            public void itemsAdded(ListAddEvent e) {
            }
        });
        this.wrappedCollectionHolder.add((Object)"foo");
        this.wrappedCollectionHolder.add((Object)"bar");
        this.wrappedCollectionHolder.add((Object)"baz");
        Collection<String> adapterCollection = this.adapterCollection();
        CollectionListValueModelAdapterTests.assertEquals((int)3, (int)adapterCollection.size());
        CollectionListValueModelAdapterTests.assertEquals(this.wrappedCollection, adapterCollection);
    }

    private Collection<String> adapterCollection() {
        return CollectionTools.hashBag((Iterator)this.adapter.iterator());
    }

    public void testStaleValue() {
        TestListChangeListener listener = new TestListChangeListener(this){

            @Override
            public void itemsAdded(ListAddEvent e) {
            }
        };
        this.adapter.addListChangeListener("list values", (ListChangeListener)listener);
        this.wrappedCollectionHolder.add((Object)"foo");
        this.wrappedCollectionHolder.add((Object)"bar");
        this.wrappedCollectionHolder.add((Object)"baz");
        Collection<String> adapterCollection = this.adapterCollection();
        CollectionListValueModelAdapterTests.assertEquals((int)3, (int)adapterCollection.size());
        CollectionListValueModelAdapterTests.assertEquals(this.wrappedCollection, adapterCollection);
        this.adapter.removeListChangeListener("list values", (ListChangeListener)listener);
        adapterCollection = this.adapterCollection();
        CollectionListValueModelAdapterTests.assertEquals((int)0, (int)adapterCollection.size());
        CollectionListValueModelAdapterTests.assertEquals((Object)new HashBag(), adapterCollection);
        this.adapter.addListChangeListener("list values", (ListChangeListener)listener);
        adapterCollection = this.adapterCollection();
        CollectionListValueModelAdapterTests.assertEquals((int)3, (int)adapterCollection.size());
        CollectionListValueModelAdapterTests.assertEquals(this.wrappedCollection, adapterCollection);
    }

    public void testAdd() {
        CoordinatedList<String> synchList = new CoordinatedList<String>(this.adapter);
        CoordinatedBag<String> synchCollection = new CoordinatedBag<String>((CollectionValueModel<String>)this.wrappedCollectionHolder);
        this.wrappedCollectionHolder.add((Object)"foo");
        CollectionListValueModelAdapterTests.assertTrue((boolean)this.wrappedCollection.contains("foo"));
        this.wrappedCollectionHolder.add((Object)"bar");
        this.wrappedCollectionHolder.add((Object)"baz");
        this.wrappedCollectionHolder.add((Object)"joo");
        this.wrappedCollectionHolder.add((Object)"jar");
        this.wrappedCollectionHolder.add((Object)"jaz");
        CollectionListValueModelAdapterTests.assertEquals((int)6, (int)this.wrappedCollection.size());
        Collection<String> adapterCollection = this.adapterCollection();
        CollectionListValueModelAdapterTests.assertEquals(this.wrappedCollection, adapterCollection);
        CollectionListValueModelAdapterTests.assertEquals(this.wrappedCollection, (Object)CollectionTools.hashBag(synchList.iterator()));
        CollectionListValueModelAdapterTests.assertEquals(this.wrappedCollection, synchCollection);
    }

    public void testRemove() {
        CoordinatedList<String> synchList = new CoordinatedList<String>(this.adapter);
        CoordinatedBag<String> synchCollection = new CoordinatedBag<String>((CollectionValueModel<String>)this.wrappedCollectionHolder);
        this.wrappedCollectionHolder.add((Object)"foo");
        this.wrappedCollectionHolder.add((Object)"bar");
        this.wrappedCollectionHolder.add((Object)"baz");
        this.wrappedCollectionHolder.add((Object)"joo");
        this.wrappedCollectionHolder.add((Object)"jar");
        this.wrappedCollectionHolder.add((Object)"jaz");
        CollectionListValueModelAdapterTests.assertTrue((boolean)this.wrappedCollection.contains("jaz"));
        this.wrappedCollectionHolder.remove((Object)"jaz");
        CollectionListValueModelAdapterTests.assertFalse((boolean)this.wrappedCollection.contains("jaz"));
        this.wrappedCollectionHolder.remove((Object)"foo");
        CollectionListValueModelAdapterTests.assertFalse((boolean)this.wrappedCollection.contains("foo"));
        CollectionListValueModelAdapterTests.assertEquals((int)4, (int)this.wrappedCollection.size());
        Collection<String> adapterCollection = this.adapterCollection();
        CollectionListValueModelAdapterTests.assertEquals(this.wrappedCollection, adapterCollection);
        CollectionListValueModelAdapterTests.assertEquals(this.wrappedCollection, (Object)CollectionTools.hashBag(synchList.iterator()));
        CollectionListValueModelAdapterTests.assertEquals(this.wrappedCollection, synchCollection);
    }

    public void testListSynch() {
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListChangeListener(this){

            @Override
            public void itemsAdded(ListAddEvent e) {
            }

            @Override
            public void itemsRemoved(ListRemoveEvent e) {
            }
        });
        this.wrappedCollectionHolder.add((Object)"foo");
        this.wrappedCollectionHolder.add((Object)"bar");
        this.wrappedCollectionHolder.add((Object)"baz");
        this.wrappedCollectionHolder.add((Object)"joo");
        this.wrappedCollectionHolder.add((Object)"jar");
        this.wrappedCollectionHolder.add((Object)"jaz");
        this.wrappedCollectionHolder.remove((Object)"jaz");
        CollectionListValueModelAdapterTests.assertFalse((boolean)this.wrappedCollection.contains("jaz"));
        this.wrappedCollectionHolder.remove((Object)"foo");
        CollectionListValueModelAdapterTests.assertFalse((boolean)this.wrappedCollection.contains("foo"));
        CollectionListValueModelAdapterTests.assertEquals((int)4, (int)this.wrappedCollection.size());
        Collection<String> adapterCollection = this.adapterCollection();
        CollectionListValueModelAdapterTests.assertEquals(this.wrappedCollection, adapterCollection);
    }

    public void testHasListeners() {
        CollectionListValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyListChangeListeners("list values"));
        CoordinatedList<String> synchList = new CoordinatedList<String>(this.adapter);
        CollectionListValueModelAdapterTests.assertTrue((boolean)((AbstractModel)this.adapter).hasAnyListChangeListeners("list values"));
        this.adapter.removeListChangeListener("list values", synchList);
        CollectionListValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyListChangeListeners("list values"));
        ChangeAdapter cl = new ChangeAdapter();
        this.adapter.addChangeListener((ChangeListener)cl);
        CollectionListValueModelAdapterTests.assertTrue((boolean)((AbstractModel)this.adapter).hasAnyListChangeListeners("list values"));
        this.adapter.removeChangeListener((ChangeListener)cl);
        CollectionListValueModelAdapterTests.assertFalse((boolean)((AbstractModel)this.adapter).hasAnyListChangeListeners("list values"));
    }

    public void testCollectionChangedToEmpty() {
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListChangeListener(this){

            @Override
            public void listCleared(ListClearEvent e) {
            }

            @Override
            public void itemsAdded(ListAddEvent e) {
            }
        });
        this.wrappedCollectionHolder.add((Object)"foo");
        this.wrappedCollectionHolder.add((Object)"bar");
        this.wrappedCollectionHolder.add((Object)"baz");
        JList jList = new JList(new ListModelAdapter(this.adapter));
        this.wrappedCollectionHolder.setValues((Iterable)new HashBag());
        CollectionListValueModelAdapterTests.assertEquals((int)0, (int)jList.getModel().getSize());
    }

    public void testCollectionChangedFromEmpty() {
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListChangeListener(this){

            @Override
            public void itemsAdded(ListAddEvent e) {
            }

            @Override
            public void itemsRemoved(ListRemoveEvent e) {
            }
        });
        JList jList = new JList(new ListModelAdapter(this.adapter));
        HashBag bag = new HashBag();
        bag.add((Object)"foo");
        bag.add((Object)"bar");
        this.wrappedCollectionHolder.setValues((Iterable)bag);
        CollectionListValueModelAdapterTests.assertEquals((int)2, (int)jList.getModel().getSize());
    }

    public void testCollectionChangedFromEmptyToEmpty() {
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListChangeListener(this){

            @Override
            public void itemsAdded(ListAddEvent e) {
            }

            @Override
            public void itemsRemoved(ListRemoveEvent e) {
            }
        });
        JList jList = new JList(new ListModelAdapter(this.adapter));
        HashBag bag = new HashBag();
        this.wrappedCollectionHolder.setValues((Iterable)bag);
        CollectionListValueModelAdapterTests.assertEquals((int)0, (int)jList.getModel().getSize());
    }

    class TestListChangeListener
    implements ListChangeListener {
        TestListChangeListener() {
        }

        public void itemsAdded(ListAddEvent e) {
            CollectionListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void itemsRemoved(ListRemoveEvent e) {
            CollectionListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void itemsReplaced(ListReplaceEvent e) {
            CollectionListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void itemsMoved(ListMoveEvent e) {
            CollectionListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void listCleared(ListClearEvent e) {
            CollectionListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void listChanged(ListChangeEvent e) {
            CollectionListValueModelAdapterTests.fail((String)"unexpected event");
        }
    }
}

