/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FacetType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadFacetComponentTestCase
extends BaseReadTestCase {
    public ReadFacetComponentTestCase(String name) {
        super(name);
    }

    public void testSingleFacet() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFacetComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacetType facet1 = this.getFacet1(edit.getFacesConfig());
            ReadFacetComponentTestCase.assertNotNull((Object)facet1);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ComponentType getComponent1(FacesConfigType facesConfigType) {
        return (ComponentType)FacesConfigModelUtil.findEObjectElementById((List)facesConfigType.getComponent(), "component1");
    }

    private FacetType getFacet1(FacesConfigType facesConfigType) {
        ComponentType component1 = this.getComponent1(facesConfigType);
        ReadFacetComponentTestCase.assertNotNull((Object)component1);
        return (FacetType)FacesConfigModelUtil.findEObjectElementById((List)component1.getFacet(), "componentFacet1");
    }

    public void testDescription() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFacetComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacetType facetType = this.getFacet1(edit.getFacesConfig());
            ReadFacetComponentTestCase.assertNotNull((Object)facetType);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)facetType.getDescription(), "componentFacet1_descripton1");
            ReadFacetComponentTestCase.assertEquals((String)"Facet1 Description", (String)descType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDisplayName() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFacetComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacetType facetType = this.getFacet1(edit.getFacesConfig());
            ReadFacetComponentTestCase.assertNotNull((Object)facetType);
            DisplayNameType displayNameType = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)facetType.getDisplayName(), "componentFacet1_displayName1");
            ReadFacetComponentTestCase.assertEquals((String)"Component Facet 1", (String)displayNameType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testIcon() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFacetComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacetType facetType = this.getFacet1(edit.getFacesConfig());
            ReadFacetComponentTestCase.assertNotNull((Object)facetType);
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)facetType.getIcon(), "componentFacet1_icon1");
            ReadFacetComponentTestCase.assertNotNull((Object)iconType);
            ReadFacetComponentTestCase.assertEquals((String)"facet-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadFacetComponentTestCase.assertEquals((String)"facet-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testFacetName() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFacetComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacetType facet1 = this.getFacet1(edit.getFacesConfig());
            ReadFacetComponentTestCase.assertNotNull((Object)facet1);
            ReadFacetComponentTestCase.assertEquals((String)"facetName_chieb_sieb", (String)facet1.getFacetName().getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

