/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.versionstatistics;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.wtp.releng.tools.versionstatistics.FullJarNameParser;
import org.eclipse.wtp.releng.tools.versionstatistics.VersionedId;
import org.osgi.framework.Version;

public class VersionStats {
    private static final boolean DEBUG = false;
    private static final String EOL = System.getProperty("line.separator");
    private int longest;
    private String longestDir;
    private String longestQualifier;
    private int longestQualifierLength;
    private String longestQualifierFeature;
    private int longestSuffixLength;
    private String longestSuffix;
    private String longestSuffixFeature;
    private SortedMap sortedFeatureDirMap = new TreeMap();
    private SortedMap sortedQualifierMap = new TreeMap();

    public static void main(String[] args) {
        try {
            new VersionStats().getStats();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getStats() throws IOException {
        String filename = "features.outrad.txt";
        this.readdata(filename);
        this.report();
    }

    private void readdata(String filename) throws IOException {
        FileReader featureFile = new FileReader(filename);
        try (BufferedReader featureReader = new BufferedReader(featureFile);){
            while (featureReader.ready()) {
                String line = featureReader.readLine();
                if ((line = line.trim()).length() <= 0) continue;
                String featuredir = line;
                if (featuredir.endsWith(".jar")) {
                    featuredir = line.substring(0, line.length() - ".jar".length());
                }
                this.checkIfLongest(featuredir);
                this.countFeature(featuredir);
                VersionedId versionId = this.computeVersionId(featuredir);
                this.countQualifiers(versionId);
                this.checkIfLongestQualifer(versionId);
                this.checkIfLongestSuffix(versionId);
            }
        }
    }

    private void report() {
        System.out.println();
        System.out.println("Longest feature directory: " + EOL + this.longestDir + " (" + this.longest + ") ");
        System.out.println();
        System.out.println("Longest feature Qualifier: " + EOL + this.longestQualifierFeature + " (" + this.longestQualifier + ")  " + " (" + this.longestQualifierLength + ") ");
        System.out.println();
        System.out.println("Longest feature suffix: " + EOL + this.longestSuffixFeature + " (" + this.longestSuffix + ")  " + " (" + this.longestSuffixLength + ") ");
        this.histogramFeatureDir();
        this.histogramQualifier();
    }

    private void histogramQualifier() {
        System.out.println(String.valueOf(EOL) + EOL + " qualifier length\tcount" + EOL);
        Set qkeys = this.sortedQualifierMap.keySet();
        for (Integer aLength : qkeys) {
            List collection = (List)this.sortedQualifierMap.get(aLength);
            int count = collection.size();
            System.out.println("\t" + aLength + "\t" + count);
            if (aLength < 28) continue;
            for (VersionedId VersionedId2 : collection) {
                System.out.println("   " + VersionedId2.getId());
            }
        }
    }

    private void histogramFeatureDir() {
        System.out.println(String.valueOf(EOL) + EOL + " directory length\tcount" + EOL);
        Set keys = this.sortedFeatureDirMap.keySet();
        for (Integer aLength : keys) {
            List collection = (List)this.sortedFeatureDirMap.get(aLength);
            int count = collection.size();
            System.out.println("\t" + aLength + "\t" + count);
        }
    }

    private void checkIfLongestSuffix(VersionedId version) {
        String qualifier = version.getVersion().getQualifier();
        String suffix = this.guessSuffix(qualifier);
        if (suffix != null && suffix.length() > this.longestSuffixLength) {
            this.longestSuffixLength = suffix.length();
            this.longestSuffix = suffix;
            this.longestSuffixFeature = version.getId();
        }
    }

    private String guessSuffix(String qualifier) {
        int pos = qualifier.indexOf(45);
        String suffix = null;
        if (pos > -1) {
            suffix = qualifier.substring(pos + 1);
            if (suffix.matches("\\d\\d\\d\\d-.*")) {
                suffix = suffix.substring(5);
            } else if (suffix.matches("\\d\\d\\d\\d$")) {
                suffix = suffix.substring(4);
            }
        }
        return suffix;
    }

    private void checkIfLongestQualifer(VersionedId versionId) {
        Version version = versionId.getVersion();
        if (version.getQualifier().length() > this.longestQualifierLength) {
            this.longestQualifierLength = version.getQualifier().length();
            this.longestQualifier = version.getQualifier();
            this.longestQualifierFeature = versionId.getId();
        }
    }

    private void checkIfLongest(String featuredir) {
        if (featuredir.length() > this.longest) {
            this.longest = featuredir.length();
            this.longestDir = featuredir;
        }
    }

    private void countFeature(String featuredir) {
        Integer length = new Integer(featuredir.length());
        ArrayList<String> collection = (ArrayList<String>)this.sortedFeatureDirMap.get(length);
        if (collection == null) {
            collection = new ArrayList<String>();
            this.sortedFeatureDirMap.put(length, collection);
        }
        collection.add(featuredir);
    }

    private void countQualifiers(VersionedId versionId) {
        ArrayList<VersionedId> qcollection;
        String qualifier = versionId.getVersion().getQualifier();
        String suffix = this.guessSuffix(qualifier);
        Integer alength = new Integer(0);
        if (suffix != null) {
            alength = new Integer(suffix.length());
        }
        if ((qcollection = (ArrayList<VersionedId>)this.sortedQualifierMap.get(alength)) == null) {
            qcollection = new ArrayList<VersionedId>();
            this.sortedQualifierMap.put(alength, qcollection);
        }
        qcollection.add(versionId);
    }

    public VersionedId computeVersionId(String spec) {
        FullJarNameParser parser = new FullJarNameParser();
        parser.parse(spec);
        String id = parser.getProjectString();
        String versionString = parser.getVersionString();
        Version version = new Version(versionString);
        return new VersionedId(id, version);
    }
}

