/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.cache;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.CMDocumentLoader;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.tests.util.FileUtil;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GlobalCMDocumentCacheTest
extends TestCase {
    private static final String ZIP_FILE_NAME = "CMDocumentCacheTestProject.zip";
    private static final String PROJECT_NAME = "CMDocumentCacheTestProject";

    protected void setUp() throws Exception {
        super.setUp();
        Location platformLocation = Platform.getInstanceLocation();
        ProjectUnzipUtility unzipUtil = new ProjectUnzipUtility();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", ZIP_FILE_NAME, "projecttestfiles");
        unzipUtil.unzipAndImport(zipFile, platformLocation.getURL().getFile());
        unzipUtil.initJavaProject(PROJECT_NAME);
    }

    public void testGlobalCMDocumentCacheEnabled() {
        this.setGlobalCacheEnabled(true);
        CMDocument globalCMDocumentCacheTest_1 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/GlobalCMDocumentCacheTest1.xml");
        CMDocument globalCMDocumentCacheTest_2 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/GlobalCMDocumentCacheTest2.xml");
        GlobalCMDocumentCacheTest.assertEquals((Object)globalCMDocumentCacheTest_1, (Object)globalCMDocumentCacheTest_2);
        CMDocument localCMDocument_1 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/document1.xml");
        CMDocument localCMDocument_2 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/document2.xml");
        GlobalCMDocumentCacheTest.assertNotSame((Object)localCMDocument_1, (Object)localCMDocument_2);
    }

    public void testGlobalCMDocumentCacheDisabled() {
        this.setGlobalCacheEnabled(false);
        CMDocument globalCMDocumentCacheTest_1 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/GlobalCMDocumentCacheTest1.xml");
        CMDocument globalCMDocumentCacheTest_2 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/GlobalCMDocumentCacheTest2.xml");
        GlobalCMDocumentCacheTest.assertNotSame((Object)globalCMDocumentCacheTest_1, (Object)globalCMDocumentCacheTest_2);
        CMDocument localCMDocument_1 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/document1.xml");
        CMDocument localCMDocument_2 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/document2.xml");
        GlobalCMDocumentCacheTest.assertNotSame((Object)localCMDocument_1, (Object)localCMDocument_2);
    }

    private CMDocument getCMDocumentFromXMLFile(String documentPath) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(documentPath));
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel structuredModel = null;
        CMDocument cmDocument = null;
        try {
            try {
                structuredModel = modelManager.getModelForRead(file);
                IDOMDocument document = ((IDOMModel)structuredModel).getDocument();
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
                CMDocumentManager cmDocumentManager = modelQuery.getCMDocumentManager();
                CMDocumentLoader loader = new CMDocumentLoader((Document)document, cmDocumentManager);
                loader.loadCMDocuments();
                cmDocument = modelQuery.getCorrespondingCMDocument((Node)document.getDocumentElement());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
        return cmDocument;
    }

    private void setGlobalCacheEnabled(boolean value) {
        Preferences pluginPreferences = XMLCorePlugin.getDefault().getPluginPreferences();
        pluginPreferences.setDefault("cmDocumentGlobalCacheEnabled", value);
    }
}

