/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facesconfig.emf.AttributeType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadAttributeValidatorTestCase
extends BaseReadTestCase {
    public ReadAttributeValidatorTestCase(String name) {
        super(name);
    }

    public void testSingleAttribute() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attribute1 = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeValidatorTestCase.assertNotNull((Object)attribute1);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private AttributeType getAttribute1(FacesConfigType facesConfig) {
        ValidatorType validator1 = (ValidatorType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getValidator(), "validator1");
        ReadAttributeValidatorTestCase.assertNotNull((Object)validator1);
        return (AttributeType)FacesConfigModelUtil.findEObjectElementById((List)validator1.getAttribute(), "validator1_attribute");
    }

    public void testDescription() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeValidatorTestCase.assertNotNull((Object)attributeType);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)attributeType.getDescription(), "validator1_attribute_description");
            ReadAttributeValidatorTestCase.assertEquals((String)"validator-attribute-description", (String)descType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDisplayName() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeValidatorTestCase.assertNotNull((Object)attributeType);
            DisplayNameType displayNameType = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)attributeType.getDisplayName(), "validator1_attribute_displayName");
            ReadAttributeValidatorTestCase.assertEquals((String)"validator-attribute-display-name", (String)displayNameType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testIcon() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attrType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeValidatorTestCase.assertNotNull((Object)attrType);
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)attrType.getIcon(), "validator1_attribute_icon");
            ReadAttributeValidatorTestCase.assertNotNull((Object)iconType);
            ReadAttributeValidatorTestCase.assertEquals((String)"validator-attribute-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadAttributeValidatorTestCase.assertEquals((String)"validator-attribute-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAttributeNameAndClass() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attribute1 = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeValidatorTestCase.assertNotNull((Object)attribute1);
            ReadAttributeValidatorTestCase.assertEquals((String)"validator-attribute-name", (String)attribute1.getAttributeName().getTextContent());
            ReadAttributeValidatorTestCase.assertEquals((String)"validator-attribute-class", (String)attribute1.getAttributeClass().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testSuggestedValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeValidatorTestCase.assertEquals((String)"validator-attribute-suggested-value", (String)attributeType.getSuggestedValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDefaultValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeValidatorTestCase.assertEquals((String)"validator-default-value", (String)attributeType.getDefaultValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAttributeExtension() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            if (edit.getFacesConfig() != null) {
                EList comp = edit.getFacesConfig().getComponent();
                ReadAttributeValidatorTestCase.assertTrue((!comp.isEmpty() ? 1 : 0) != 0);
                int i = 0;
                while (i < comp.size()) {
                    ComponentType compType = (ComponentType)comp.get(i);
                    ReadAttributeValidatorTestCase.assertTrue((!compType.getAttribute().isEmpty() ? 1 : 0) != 0);
                    EList attr = compType.getAttribute();
                    int k = 0;
                    while (k < attr.size()) {
                        AttributeType attrType = (AttributeType)attr.get(k);
                        EList ext = attrType.getAttributeExtension();
                        ReadAttributeValidatorTestCase.assertTrue((ext.size() != 0 ? 1 : 0) != 0);
                        ++k;
                    }
                    ++i;
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

