/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.model;

import junit.framework.TestCase;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.html.core.tests.utils.FileUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.css.ElementCSSInlineStyle;

public class BUG124835SetStyleAttributeValueTest
extends TestCase {
    public void testSetAttributeValue() {
        IDOMModel model = FileUtil.createHTMLModel();
        try {
            IDOMDocument doc = model.getDocument();
            Element element = doc.createElement("DIV");
            element.setAttribute("id", "Layer0");
            element.setAttribute("style", "");
            this.setInlineStyle(element, "position", "absolute");
            this.setInlineStyle(element, "z-index", "1");
            this.setInlineStyle(element, "width", "50px");
            this.setInlineStyle(element, "height", "50px");
            this.setInlineStyle(element, "top", "50px");
            this.setInlineStyle(element, "left", "50px");
            BUG124835SetStyleAttributeValueTest.assertEquals((String)"absolute", (String)this.getInlineStyle(element, "position"));
            BUG124835SetStyleAttributeValueTest.assertEquals((String)"1", (String)this.getInlineStyle(element, "z-index"));
            BUG124835SetStyleAttributeValueTest.assertEquals((String)"50px", (String)this.getInlineStyle(element, "width"));
            BUG124835SetStyleAttributeValueTest.assertEquals((String)"50px", (String)this.getInlineStyle(element, "height"));
            BUG124835SetStyleAttributeValueTest.assertEquals((String)"50px", (String)this.getInlineStyle(element, "top"));
            BUG124835SetStyleAttributeValueTest.assertEquals((String)"50px", (String)this.getInlineStyle(element, "left"));
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    private void setInlineStyle(Element element, String name, String value) {
        ICSSStyleDeclaration decl = null;
        try {
            decl = (ICSSStyleDeclaration)((ElementCSSInlineStyle)((Object)element)).getStyle();
        }
        catch (ClassCastException classCastException) {}
        if (decl != null) {
            String priority = decl.getPropertyPriority(name);
            decl.setProperty(name, value, priority);
        }
    }

    private String getInlineStyle(Element element, String name) {
        String value = null;
        ICSSStyleDeclaration decl = null;
        try {
            decl = (ICSSStyleDeclaration)((ElementCSSInlineStyle)((Object)element)).getStyle();
        }
        catch (ClassCastException classCastException) {}
        if (decl != null) {
            value = decl.getPropertyValue(name);
        }
        return value;
    }
}

