/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.misc;

import org.eclipse.wst.html.core.tests.parser.ModelTest;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HTMLTagInfoTest
extends ModelTest {
    public HTMLTagInfoTest(String name) {
        super(name);
    }

    public HTMLTagInfoTest() {
    }

    public static void main(String[] args) {
        new HTMLTagInfoTest().testModel();
    }

    @Override
    public void testModel() {
        IDOMModel model = HTMLTagInfoTest.createHTMLModel();
        try {
            IDOMDocument document = model.getDocument();
            Element html = document.createElement("HTML");
            document.appendChild(html);
            this.checkElementTagInfo(html);
            Element body = document.createElement("BODY");
            html.appendChild(body);
            this.checkElementTagInfo(body);
            Attr onclick = document.createAttribute("onclick");
            body.setAttributeNode(onclick);
            this.checkAttributeTagInfo(body, onclick);
        }
        finally {
            model.releaseFromEdit();
        }
    }

    private void checkElementTagInfo(Element node) {
        CMElementDeclaration elementDecl = this.getCMElementDeclaration(node);
        HTMLTagInfoTest.assertNotNull((String)("Cannot check taginfo because no cm element declaration for " + node.getNodeName()), (Object)elementDecl);
        if (elementDecl != null) {
            String tagInfo = (String)elementDecl.getProperty("tagInfo");
            HTMLTagInfoTest.assertNotNull((String)("No taginfo found for " + elementDecl.getNodeName()), (Object)tagInfo);
        }
    }

    private void checkAttributeTagInfo(Element element, Attr attribute) {
        CMElementDeclaration elementDecl = this.getCMElementDeclaration(element);
        HTMLTagInfoTest.assertNotNull((String)("Cannot check taginfo because no element declaration for " + element.getNodeName()), (Object)elementDecl);
        if (elementDecl != null) {
            CMAttributeDeclaration attDecl = this.getCMAttributeDeclaration(elementDecl, attribute.getName());
            HTMLTagInfoTest.assertNotNull((String)("Cannot check taginfo because no attribute declaration for " + attribute.getName()), (Object)attDecl);
            String tagInfo = (String)attDecl.getProperty("tagInfo");
            HTMLTagInfoTest.assertNull((String)("Unexpected taginfo found for " + attDecl.getNodeName()), (Object)tagInfo);
        }
    }

    private CMAttributeDeclaration getCMAttributeDeclaration(CMElementDeclaration elementDecl, String attName) {
        CMAttributeDeclaration attrDecl = null;
        if (elementDecl != null) {
            CMNamedNodeMap attributes = elementDecl.getAttributes();
            String noprefixName = DOMNamespaceHelper.getUnprefixedName((String)attName);
            if (attributes != null && (attrDecl = (CMAttributeDeclaration)attributes.getNamedItem(noprefixName)) == null) {
                attrDecl = (CMAttributeDeclaration)attributes.getNamedItem(attName);
            }
        }
        return attrDecl;
    }

    private CMElementDeclaration getCMElementDeclaration(Element element) {
        CMElementDeclaration result = null;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        if (modelQuery != null) {
            result = modelQuery.getCMElementDeclaration(element);
        }
        return result;
    }
}

