/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.test;

import junit.framework.TestCase;
import org.eclipse.wst.xml.xpath2.processor.internal.utils.LiteralUtils;

public class LiteralUtilsTest
extends TestCase {
    public void testUnquoteDouble() {
        String original = "\"Henry \"\"Billie The Kid\"\" McCarty\"";
        LiteralUtilsTest.assertEquals((String)"Henry \"Billie The Kid\" McCarty", (String)LiteralUtils.unquote((String)original));
    }

    public void testDoubleFirst() {
        String original = "\"\"\"Billie\"\" is the name\"";
        LiteralUtilsTest.assertEquals((String)"\"Billie\" is the name", (String)LiteralUtils.unquote((String)original));
    }

    public void testDoubleLast() {
        String original = "\"The name is \"\"Billie\"\"\"";
        LiteralUtilsTest.assertEquals((String)"The name is \"Billie\"", (String)LiteralUtils.unquote((String)original));
    }

    public void testUnquoteSingle() {
        String original = "'Don''t shoot the messenger'";
        LiteralUtilsTest.assertEquals((String)"Don't shoot the messenger", (String)LiteralUtils.unquote((String)original));
    }

    public void testSingleFirst() {
        String original = "'''s-Hertogenbosch is in The Netherlands'";
        LiteralUtilsTest.assertEquals((String)"'s-Hertogenbosch is in The Netherlands", (String)LiteralUtils.unquote((String)original));
    }

    public void testSingleLast() {
        String original = "'He''s so tall, over 6'''";
        LiteralUtilsTest.assertEquals((String)"He's so tall, over 6'", (String)LiteralUtils.unquote((String)original));
    }
}

