/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.dom;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMAttributeDeclarationImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMDataTypeImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMElementDeclarationImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNamedNodeMapImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.ModelQueryImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ElementImplTests
extends TestCase {
    private static final String contents = "<elementPrefix:localName attrPrefix:local='lorem' xmlns:elementPrefix='urn:prefix' xmlns:attributePrefix='urn:attribute:prefix' />";
    private static final String decl = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public ElementImplTests() {
    }

    public ElementImplTests(String name) {
        super(name);
    }

    public void testElementImplPrefix() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element documentElement = model.getDocument().getDocumentElement();
        ElementImplTests.assertNotNull((String)"no document element found", (Object)documentElement);
        ElementImplTests.assertEquals((String)"attribute prefix was not as expected", (String)"elementPrefix", (String)documentElement.getPrefix());
    }

    public void testElementImplLocalName() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element documentElement = model.getDocument().getDocumentElement();
        ElementImplTests.assertNotNull((String)"no document element found", (Object)documentElement);
        ElementImplTests.assertEquals((String)"attribute local name was not as expected", (String)"localName", (String)documentElement.getLocalName());
    }

    public void testAttrBasedElementNamespace() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element documentElement = model.getDocument().getDocumentElement();
        ElementImplTests.assertNotNull((String)"no document element found", (Object)documentElement);
        ElementImplTests.assertNotNull((String)"Namespace was not found.", (Object)documentElement.getNamespaceURI());
        String namespace = documentElement.getNamespaceURI();
        ElementImplTests.assertEquals((String)"attribute local name was not as expected", (String)"urn:prefix", (String)namespace);
    }

    public void testNamespaceURIOnCreation() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element element = model.getDocument().createElement("simple");
        ElementImplTests.assertNull((String)"namespace was found", (Object)element.getNamespaceURI());
        Element element2 = model.getDocument().createElementNS("http://lorem.ipsum", "complex");
        ElementImplTests.assertEquals((String)"attribute namespace URI was not as expected", (String)"http://lorem.ipsum", (String)element2.getNamespaceURI());
        Element element3 = model.getDocument().createElementNS(null, "complex");
        ElementImplTests.assertEquals((String)"attribute namespace URI was not as expected", null, (String)element3.getNamespaceURI());
    }

    public void testGetElementsByTagNameNoChildren() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("root");
        document.appendChild(root);
        NodeList children = root.getElementsByTagName("*");
        ElementImplTests.assertEquals((int)0, (int)children.getLength());
    }

    public void testGetElementsByTagNameChildren() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("root");
        document.appendChild(root);
        root.appendChild(document.createElement("child"));
        root.appendChild(document.createElement("child"));
        NodeList children = root.getElementsByTagName("*");
        ElementImplTests.assertEquals((int)2, (int)children.getLength());
    }

    public void testGetElementsByTagNameChildrenBySameName() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("child");
        document.appendChild(root);
        root.appendChild(document.createElement("child"));
        root.appendChild(document.createElement("child"));
        NodeList children = root.getElementsByTagName("child");
        ElementImplTests.assertEquals((int)2, (int)children.getLength());
    }

    public void testGetElementsByTagNameNS() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("test:root");
        root.setAttribute("xmlns:test", "http://test");
        document.appendChild(root);
        root.appendChild(document.createElement("test:child"));
        root.appendChild(document.createElement("test:child"));
        NodeList children = root.getElementsByTagNameNS("http://test", "*");
        ElementImplTests.assertEquals((int)2, (int)children.getLength());
    }

    public void testGetElementsByTagNameNSTestNS() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("test:root");
        root.setAttribute("xmlns:test", "http://test");
        root.setAttribute("xmlns:test2", "http://test2");
        document.appendChild(root);
        root.appendChild(document.createElement("test:child"));
        root.appendChild(document.createElement("test:child"));
        root.appendChild(document.createElement("test2:child"));
        NodeList children = root.getElementsByTagNameNS("http://test", "*");
        ElementImplTests.assertEquals((int)2, (int)children.getLength());
    }

    public void testGetElementsByTagNameNSAnyNS() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("test:root");
        root.setAttribute("xmlns:test", "http://test");
        root.setAttribute("xmlns:test2", "http://test2");
        document.appendChild(root);
        root.appendChild(document.createElement("test:child"));
        root.appendChild(document.createElement("test:child"));
        root.appendChild(document.createElement("test2:child"));
        NodeList children = root.getElementsByTagNameNS("*", "*");
        ElementImplTests.assertEquals((int)3, (int)children.getLength());
    }

    public void testRemoveNonexistantAttrByName() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("test:root");
        root.setAttribute("xmlns:test", "http://test");
        root.setAttribute("xmlns:test2", "http://test2");
        document.appendChild(root);
        boolean success = false;
        try {
            root.removeAttribute(this.getName());
            success = true;
        }
        catch (DOMException ex) {
            ElementImplTests.assertTrue((String)"threw_NOT_FOUND_ERR", (ex.code != 8 ? 1 : 0) != 0);
        }
        ElementImplTests.assertTrue((String)"threw exception", (boolean)success);
    }

    public void testSetAttrWithImpliedDefault() {
        IDOMModel model = null;
        try {
            model = (IDOMModel)this.getModelForRead("testfiles/time.xml");
            if (model != null) {
                IDOMDocument document = model.getDocument();
                Element element = document.getDocumentElement();
                ElementImplTests.assertNotNull((Object)element);
                ElementImplTests.assertEquals((String)"0", (String)element.getAttribute("hour"));
                element.setAttribute("hour", "12");
                ElementImplTests.assertEquals((String)"12", (String)element.getAttribute("hour"));
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public void testRemoveAttrWithImpliedDefault() {
        IDOMModel model = null;
        try {
            model = (IDOMModel)this.getModelForRead("testfiles/time.xml");
            if (model != null) {
                IDOMDocument document = model.getDocument();
                Element element = document.getDocumentElement();
                ElementImplTests.assertNotNull((Object)element);
                ElementImplTests.assertEquals((String)"0", (String)element.getAttribute("hour"));
                element.setAttribute("hour", "12");
                ElementImplTests.assertEquals((String)"12", (String)element.getAttribute("hour"));
                element.removeAttribute("hour");
                ElementImplTests.assertEquals((String)"0", (String)element.getAttribute("hour"));
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public void testOwnerElementWithImpliedDefaultAttribute() {
        IDOMModel model = null;
        try {
            model = (IDOMModel)this.getModelForRead("testfiles/time.xml");
            if (model != null) {
                IDOMDocument document = model.getDocument();
                Element element = document.getDocumentElement();
                ElementImplTests.assertNotNull((Object)element);
                Attr attr = element.getAttributeNode("hour");
                ElementImplTests.assertNull((Object)attr);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public void testCMAttrWithNullImpliedValue() {
        IDOMModel model = null;
        try {
            model = (IDOMModel)this.getModelForRead("testfiles/time.xml");
            if (model != null) {
                IDOMDocument document = model.getDocument();
                document.addAdapter((INodeAdapter)new ModelQueryAdapter(){

                    public boolean isAdapterForType(Object type) {
                        return type.equals(ModelQueryAdapter.class);
                    }

                    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
                    }

                    public CMDocumentCache getCMDocumentCache() {
                        return null;
                    }

                    public URIResolver getIdResolver() {
                        return null;
                    }

                    public ModelQuery getModelQuery() {
                        return new ModelQueryImpl(null){

                            public CMElementDeclaration getCMElementDeclaration(Element element) {
                                CMElementDeclarationImpl decl = new CMElementDeclarationImpl(null, null);
                                CMNamedNodeMapImpl map = (CMNamedNodeMapImpl)decl.getAttributes();
                                map.put((CMNode)new CMAttributeDeclarationImpl("second", 1, (CMDataType)new CMDataTypeImpl("second", null)));
                                return decl;
                            }
                        };
                    }

                    public void release() {
                    }

                    public void setIdResolver(URIResolver newIdResolver) {
                    }
                });
                Element element = document.getDocumentElement();
                ElementImplTests.assertNotNull((Object)element);
                ElementImplTests.assertEquals((String)"", (String)element.getAttribute("second"));
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public IStructuredModel getModelForRead(String path) {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(path);
            if (inStream == null) {
                throw new FileNotFoundException("Can't file resource stream " + path);
            }
            String baseFile = ((Object)((Object)this)).getClass().getResource(path).toString();
            model = modelManager.getModelForRead(baseFile, inStream, new org.eclipse.wst.sse.core.internal.util.URIResolver(baseFile){
                String fBase;
                {
                    this.fBase = string;
                }

                public String getFileBaseLocation() {
                    return this.fBase;
                }

                public String getLocationByURI(String uri) {
                    return this.getLocationByURI(uri, this.fBase);
                }

                public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
                    return this.getLocationByURI(uri);
                }

                public String getLocationByURI(String uri, String baseReference) {
                    int lastSlash = baseReference.lastIndexOf("/");
                    if (lastSlash > 0) {
                        return baseReference.substring(0, lastSlash + 1) + uri;
                    }
                    return baseReference;
                }

                public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
                    return this.getLocationByURI(uri, baseReference);
                }

                public IProject getProject() {
                    return null;
                }

                public IContainer getRootLocation() {
                    return null;
                }

                public InputStream getURIStream(String uri) {
                    return this.getClass().getResourceAsStream(this.getLocationByURI(uri));
                }

                public void setFileBaseLocation(String newLocation) {
                    this.fBase = newLocation;
                }

                public void setProject(IProject newProject) {
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return model;
    }
}

