/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.testutils.project;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.jaxws.testutils.project.ProjectBasedTest;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProjectsUtils;

public abstract class ClassLoadingTest
extends ProjectBasedTest {
    private static final String JAVA_EXT = ".java";
    private static final char SEPARATOR = '#';
    protected IPackageFragment defaultPackage;

    public void createJavaProject(String srcFolder, String defaultPackageName) throws CoreException {
        this.createJavaProject(srcFolder);
        if (defaultPackageName != null) {
            this.defaultPackage = this.getSourceFolder().createPackageFragment(defaultPackageName, true, null);
        }
    }

    protected IType createClass(String sourceFilePath, String className) throws IOException, CoreException {
        if (sourceFilePath == null) {
            throw new NullPointerException("sourceFilePath should not be null.");
        }
        String source = TestProjectsUtils.readSource(((Object)((Object)this)).getClass(), sourceFilePath);
        return this.createClass(this.defaultPackage, className, source);
    }

    protected IType createClass(IPackageFragment pck, String className, String source) throws CoreException {
        if (className == null) {
            throw new NullPointerException("param 'className' should not be null.");
        }
        if (source == null) {
            throw new NullPointerException("param 'source' should not be null.");
        }
        if (this.getTestProject() == null) {
            throw new NullPointerException("project must be created before classes can be added to it");
        }
        return this.getTestProject().createType(pck, String.valueOf(className) + JAVA_EXT, source);
    }

    protected Map<String, IType> createClasses(String sourcesFilePath) throws Exception {
        HashMap<String, IType> types = new HashMap<String, IType>();
        String source = TestProjectsUtils.readSource(((Object)((Object)this)).getClass(), sourcesFilePath);
        int startPos = 0;
        while ((startPos = source.indexOf(35)) > -1) {
            int endPos = source.indexOf(35, startPos + 1);
            if (endPos == -1) {
                endPos = source.length();
            }
            String src = source.substring(startPos + 1, endPos);
            source = source.substring(endPos);
            String className = src.substring(0, src.indexOf(10)).replaceAll("\r", "");
            src = src.substring(src.indexOf(10) + 1);
            types.put(className, this.createClass(this.defaultPackage, className, src));
        }
        return types;
    }
}

