/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.core.internal.ITagRegistryFactoryProvider;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTJSPExternalContext;
import org.eclipse.jst.jsf.designtime.context.IDTExternalContext;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class TestDTJSPExternalContext
extends TestCase {
    private IFile _testJSP1;
    private JSFFacetedTestEnvironment _jsfFactedTestEnvironment;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment(this.getProjectName());
        projectTestEnvironment.createProject(false);
        JDTTestEnvironment jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
        TestFileResource input = new TestFileResource();
        input.load(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/bundle1.resources.data");
        jdtTestEnvironment.addResourceFile("src", (InputStream)new ByteArrayInputStream(input.toBytes()), "bundles", "bundle1.properties");
        IResource res = projectTestEnvironment.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/testdata1.jsp.data", "testdata1.jsp");
        this._testJSP1 = (IFile)res;
        this._jsfFactedTestEnvironment = new JSFFacetedTestEnvironment(projectTestEnvironment);
        this._jsfFactedTestEnvironment.initialize("1.1");
        JSFCoreUtilHelper.injectTestTagRegistryFactoryProvider((ITagRegistryFactoryProvider)JSFCoreUtilHelper.createSimpleRegistryFactory());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        JSFCoreUtilHelper.injectTestTagRegistryFactoryProvider(null);
    }

    public void testDefaultDoGetMapForScopeInt() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP1.getProject());
        Object externalContext = manager.getFacesContext(this._testJSP1).getDTExternalContext((IAdaptable)this._testJSP1);
        Map requestMap = externalContext.getRequestMap();
        Collection<Object> symbols = requestMap.values();
        TestDTJSPExternalContext.assertEquals((int)2, (int)symbols.size());
        this.assertContainsVariable(symbols, "bundle");
        this.assertContainsVariable(symbols, "row");
        externalContext = new TestableDTJSPExternalContext((IAdaptable)this._testJSP1);
        requestMap = externalContext.getRequestMap();
        symbols = requestMap.values();
        TestDTJSPExternalContext.assertEquals((int)1, (int)symbols.size());
        this.assertContainsVariable(symbols, "requestSymbol");
        Map sessionMap = externalContext.getSessionMap();
        symbols = sessionMap.values();
        TestDTJSPExternalContext.assertEquals((int)1, (int)symbols.size());
        this.assertContainsVariable(symbols, "sessionSymbol");
        Map applicationMap = externalContext.getApplicationMap();
        symbols = applicationMap.values();
        TestDTJSPExternalContext.assertEquals((int)1, (int)symbols.size());
        this.assertContainsVariable(symbols, "applicationSymbol");
        Map noneMap = externalContext.getNoneMap();
        symbols = noneMap.values();
        TestDTJSPExternalContext.assertEquals((int)1, (int)symbols.size());
        this.assertContainsVariable(symbols, "noneSymbol");
        externalContext.trace(System.out);
    }

    public void testGetRequestContextPath() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._testJSP1.getProject());
        IDTExternalContext externalContext = manager.getFacesContext(this._testJSP1).getDTExternalContext((IAdaptable)this._testJSP1);
        TestDTJSPExternalContext.assertTrue((boolean)(externalContext instanceof DTJSPExternalContext));
        TestDTJSPExternalContext.assertEquals((String)this.getProjectName(), (String)externalContext.getRequestContextPath());
    }

    private void assertContainsVariable(Collection<ISymbol> variables, String name) {
        for (ISymbol variable : variables) {
            if (!name.equals(variable.getName())) continue;
            TestDTJSPExternalContext.assertTrue((boolean)(variable instanceof IInstanceSymbol));
            return;
        }
        TestDTJSPExternalContext.fail((String)("Expected variable not found: " + name));
    }

    private String getProjectName() {
        return "TestDTJSPExternalContext" + this.getName();
    }

    private class TestableDTJSPExternalContext
    extends DTJSPExternalContext {
        protected TestableDTJSPExternalContext(IAdaptable jspFile) {
            super(jspFile);
        }

        protected Map<String, ISymbol> doGetMapForScope(int scopeMask) {
            switch (scopeMask) {
                case 1: {
                    return this.initRequestMap();
                }
                case 2: {
                    return this.initSessionMap();
                }
                case 4: {
                    return this.initApplicationMap();
                }
                case 8: {
                    return this.initNoneMap();
                }
            }
            throw new IllegalArgumentException();
        }

        private Map<String, ISymbol> initRequestMap() {
            HashMap<String, ISymbol> map = new HashMap<String, ISymbol>();
            IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
            symbol.setName("requestSymbol");
            map.put("requestSymbol", (ISymbol)symbol);
            return map;
        }

        private Map<String, ISymbol> initSessionMap() {
            HashMap<String, ISymbol> map = new HashMap<String, ISymbol>();
            IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
            symbol.setName("sessionSymbol");
            map.put("sessionSymbol", (ISymbol)symbol);
            return map;
        }

        private Map<String, ISymbol> initApplicationMap() {
            HashMap<String, ISymbol> map = new HashMap<String, ISymbol>();
            IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
            symbol.setName("applicationSymbol");
            map.put("applicationSymbol", (ISymbol)symbol);
            return map;
        }

        private Map<String, ISymbol> initNoneMap() {
            HashMap<String, ISymbol> map = new HashMap<String, ISymbol>();
            IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
            symbol.setName("noneSymbol");
            map.put("noneSymbol", (ISymbol)symbol);
            return map;
        }
    }
}

