/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.tests.internal.utility;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectPreferencesTests
extends TestCase {
    public ProjectPreferencesTests(String name) {
        super(name);
    }

    public void testProjectRename() throws Exception {
        String key = "pref";
        String value = "XXXX";
        IProject project1 = this.buildProject("foo");
        this.setPreference(project1, key, value);
        ProjectPreferencesTests.assertEquals((String)value, (String)this.getPreference(project1, key));
        Path dest = new Path("/bar");
        project1.move((IPath)dest, 32, null);
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("bar");
        ProjectPreferencesTests.assertEquals((String)value, (String)this.getPreference(project2, key));
        String pref = this.getPreference(project1, key);
        ProjectPreferencesTests.assertNull((Object)pref);
        dest = new Path("/foo");
        project2.move((IPath)dest, 32, null);
        ProjectPreferencesTests.assertEquals((String)value, (String)this.getPreference(project1, key));
        project2.delete(true, null);
    }

    private IProject buildProject(String projectName) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        project.create(null);
        project.open(null);
        return project;
    }

    private void setPreference(IProject project, String key, String value) throws BackingStoreException {
        IEclipsePreferences prefs = this.getPreferences(project);
        prefs.put(key, value);
        prefs.flush();
    }

    private String getPreference(IProject project, String key) {
        return this.getPreferences(project).get(key, null);
    }

    private IEclipsePreferences getPreferences(IProject project) {
        return this.getPreferences((IScopeContext)new ProjectScope(project));
    }

    private IEclipsePreferences getPreferences(IScopeContext context) {
        return context.getNode("test");
    }
}

