/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.tests.internal.utility;

import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageLoader;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassTools;

public class MessageLoaderTests
extends TestCase {
    public MessageLoaderTests(String name) {
        super(name);
    }

    public void testBuildLocaleSuffixes1() {
        String[] suffixes = this.buildLocaleSuffixes("en", "US", "WIN");
        MessageLoaderTests.assertEquals((int)4, (int)suffixes.length);
        MessageLoaderTests.assertEquals((String)suffixes[0], (String)"_en_US_WIN.properties");
        MessageLoaderTests.assertEquals((String)suffixes[1], (String)"_en_US.properties");
        MessageLoaderTests.assertEquals((String)suffixes[2], (String)"_en.properties");
        MessageLoaderTests.assertEquals((String)suffixes[3], (String)".properties");
    }

    public void testBuildLocaleSuffixes2() {
        String[] suffixes = this.buildLocaleSuffixes("en", "US", "");
        MessageLoaderTests.assertEquals((int)3, (int)suffixes.length);
        MessageLoaderTests.assertEquals((String)suffixes[0], (String)"_en_US.properties");
        MessageLoaderTests.assertEquals((String)suffixes[1], (String)"_en.properties");
        MessageLoaderTests.assertEquals((String)suffixes[2], (String)".properties");
    }

    public void testBuildLocaleSuffixes3() {
        String[] suffixes = this.buildLocaleSuffixes("en", "", "WIN");
        MessageLoaderTests.assertEquals((int)3, (int)suffixes.length);
        MessageLoaderTests.assertEquals((String)suffixes[0], (String)"_en__WIN.properties");
        MessageLoaderTests.assertEquals((String)suffixes[1], (String)"_en.properties");
        MessageLoaderTests.assertEquals((String)suffixes[2], (String)".properties");
    }

    public void testBuildLocaleSuffixes4() {
        String[] suffixes = this.buildLocaleSuffixes("en", "", "");
        MessageLoaderTests.assertEquals((int)2, (int)suffixes.length);
        MessageLoaderTests.assertEquals((String)suffixes[0], (String)"_en.properties");
        MessageLoaderTests.assertEquals((String)suffixes[1], (String)".properties");
    }

    public void testBuildLocaleSuffixes5() {
        String[] suffixes = this.buildLocaleSuffixes("", "US", "WIN");
        MessageLoaderTests.assertEquals((int)3, (int)suffixes.length);
        MessageLoaderTests.assertEquals((String)suffixes[0], (String)"__US_WIN.properties");
        MessageLoaderTests.assertEquals((String)suffixes[1], (String)"__US.properties");
        MessageLoaderTests.assertEquals((String)suffixes[2], (String)".properties");
    }

    public void testBuildLocaleSuffixes6() {
        String[] suffixes = this.buildLocaleSuffixes("", "US", "");
        MessageLoaderTests.assertEquals((int)2, (int)suffixes.length);
        MessageLoaderTests.assertEquals((String)suffixes[0], (String)"__US.properties");
        MessageLoaderTests.assertEquals((String)suffixes[1], (String)".properties");
    }

    public void testBuildLocaleSuffixes7() {
        String[] suffixes = this.buildLocaleSuffixes("", "", "WIN");
        MessageLoaderTests.assertEquals((int)2, (int)suffixes.length);
        MessageLoaderTests.assertEquals((String)suffixes[0], (String)"___WIN.properties");
        MessageLoaderTests.assertEquals((String)suffixes[1], (String)".properties");
    }

    public void testBuildLocaleSuffixes8() {
        String[] suffixes = this.buildLocaleSuffixes("", "", "");
        MessageLoaderTests.assertEquals((int)1, (int)suffixes.length);
        MessageLoaderTests.assertEquals((String)suffixes[0], (String)".properties");
    }

    private String[] buildLocaleSuffixes(String language, String country, String variant) {
        return this.buildLocaleSuffixes(new Locale(language, country, variant));
    }

    private String[] buildLocaleSuffixes(Locale locale) {
        return (String[])ClassTools.execute(ValidationMessageLoader.class, (String)"buildLocaleSuffixes", Locale.class, (Object)locale);
    }

    public void testPropertiesFileNames1() {
        int i;
        String[] names = this.buildPropertiesFileNames("foo");
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        int expectedSize = 1;
        if (language.length() != 0) {
            ++expectedSize;
        }
        if (country.length() != 0) {
            ++expectedSize;
        }
        if (variant.length() != 0) {
            ++expectedSize;
        }
        MessageLoaderTests.assertEquals((int)expectedSize, (int)names.length);
        String[] expected = (String[])ArrayTools.fill((Object[])new String[expectedSize], (Object)"foo");
        if (expectedSize > 1) {
            i = 0;
            while (i < expectedSize - 1) {
                expected[i] = String.valueOf(expected[i]) + '_' + language;
                ++i;
            }
        }
        if (expectedSize > 2) {
            i = 0;
            while (i < expectedSize - 2) {
                expected[i] = String.valueOf(expected[i]) + '_' + country;
                ++i;
            }
        }
        if (expectedSize > 3) {
            i = 0;
            while (i < expectedSize - 3) {
                expected[i] = String.valueOf(expected[i]) + '_' + variant;
                ++i;
            }
        }
    }

    private String[] buildPropertiesFileNames(String bundleName) {
        return (String[])ClassTools.execute(ValidationMessageLoader.class, (String)"buildPropertiesFileNames", String.class, (Object)bundleName);
    }
}

