/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.describing;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingTest;

public class ASTRewritingGroupNodeTest
extends ASTRewritingTest {
    private static final Class THIS = ASTRewritingGroupNodeTest.class;

    public ASTRewritingGroupNodeTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test setUpTest(Test someTest) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite("one test");
        suite.addTest(someTest);
        return suite;
    }

    public static Test suite() {
        return ASTRewritingGroupNodeTest.allTests();
    }

    public void testCollapsedTargetNodes() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo(o) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        FunctionDeclaration methodDecl = ASTRewritingGroupNodeTest.findMethodDeclaration(astRoot, "foo");
        ReturnStatement returnStatement = (ReturnStatement)methodDecl.getBody().statements().get(0);
        FunctionInvocation newMethodInv1 = ast.newFunctionInvocation();
        newMethodInv1.setName(ast.newSimpleName("foo1"));
        ExpressionStatement st1 = ast.newExpressionStatement((Expression)newMethodInv1);
        FunctionInvocation newMethodInv2 = ast.newFunctionInvocation();
        newMethodInv2.setName(ast.newSimpleName("foo2"));
        ExpressionStatement st2 = ast.newExpressionStatement((Expression)newMethodInv2);
        ASTNode placeholder = rewrite.createGroupNode((ASTNode[])new Statement[]{st1, st2});
        rewrite.replace((ASTNode)returnStatement, placeholder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo(o) {\n");
        buf.append("        foo1();\n");
        buf.append("        foo2();\n");
        buf.append("    }\n");
        String expected = buf.toString();
        ASTRewritingGroupNodeTest.assertEqualString(preview, expected);
    }

    public void testCollapsedTargetNodes2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo( o) {\n");
        buf.append("        {\n");
        buf.append("            return;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        FunctionDeclaration methodDecl = ASTRewritingGroupNodeTest.findMethodDeclaration(astRoot, "foo");
        Statement statement = (Statement)methodDecl.getBody().statements().get(0);
        FunctionInvocation newMethodInv1 = ast.newFunctionInvocation();
        newMethodInv1.setName(ast.newSimpleName("foo1"));
        ExpressionStatement st1 = ast.newExpressionStatement((Expression)newMethodInv1);
        FunctionInvocation newMethodInv2 = ast.newFunctionInvocation();
        newMethodInv2.setName(ast.newSimpleName("foo2"));
        ExpressionStatement st2 = ast.newExpressionStatement((Expression)newMethodInv2);
        ReturnStatement st3 = (ReturnStatement)rewrite.createCopyTarget((ASTNode)((Block)statement).statements().get(0));
        ASTNode placeholder = rewrite.createGroupNode((ASTNode[])new Statement[]{st1, st2, st3});
        rewrite.replace((ASTNode)statement, placeholder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo( o) {\n");
        buf.append("        foo1();\n");
        buf.append("        foo2();\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        String expected = buf.toString();
        ASTRewritingGroupNodeTest.assertEqualString(preview, expected);
    }
}

