/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;

public class ExistenceTests
extends ModifyingResourceTests {
    public ExistenceTests(String name) {
        super(name);
    }

    public static Test suite() {
        return ExistenceTests.buildModelTestSuite(ExistenceTests.class);
    }

    protected void assertCorrespondingResourceFails(IJavaScriptElement element) {
        boolean gotException;
        block2: {
            gotException = false;
            try {
                element.getCorrespondingResource();
            }
            catch (JavaScriptModelException e) {
                if (!e.isDoesNotExist()) break block2;
                gotException = true;
            }
        }
        ExistenceTests.assertTrue((String)"Should not be able to get corresponding resource", (boolean)gotException);
    }

    protected void assertOpenFails(String expectedMessage, IOpenable openable) {
        String message = "";
        try {
            openable.open(null);
        }
        catch (JavaScriptModelException e) {
            message = e.getMessage();
        }
        if (!expectedMessage.equals(message)) {
            System.out.print(Util.displayString((String)message, (int)3));
            System.out.println(",");
        }
        ExistenceTests.assertEquals((String)expectedMessage, (String)message);
    }

    protected void assertUnderlyingResourceFails(IJavaScriptElement element) {
        boolean gotException;
        block2: {
            gotException = false;
            try {
                element.getUnderlyingResource();
            }
            catch (JavaScriptModelException e) {
                if (!e.isDoesNotExist()) break block2;
                gotException = true;
            }
        }
        ExistenceTests.assertTrue((String)"Should not be able to get underlying resource", (boolean)gotException);
    }

    public void testBinaryMethodAfterNonExistingMember() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[0], new String[0]);
            IClassFile classFile = project.getPackageFragmentRoot(this.getSystemJsPathString()).getPackageFragment("").getClassFile("system.js");
            classFile.open(null);
            IType type = classFile.getType();
            type.getFunction("foo", new String[0]).exists();
            ExistenceTests.assertTrue((String)"Object.toString() should exist", (boolean)type.getFunction("toString", new String[0]).exists());
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClassFileInBinary() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"});
            this.createFile("P/bin/X.class", "");
            IClassFile classFile = this.getClassFile("P/bin/X.class");
            ExistenceTests.assertTrue((!classFile.exists() ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClassFileInLibrary() throws CoreException {
        try {
            this.createJavaProject("P", new String[0], new String[]{"lib"});
            this.createFile("P/lib/X.class", "");
            IClassFile classFile = this.getClassFile("P/lib/X.class");
            ExistenceTests.assertTrue((boolean)classFile.exists());
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClassFileInLibraryInOtherProject() throws CoreException {
        try {
            this.createJavaProject("P2", new String[0]);
            this.createFolder("P2/lib");
            String path = "P2/lib/X.class";
            IFile file = this.createFile(path, "");
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[0], new String[]{"/P2/lib"});
            IClassFile nonExistingFile = this.getClassFile(path);
            ExistenceTests.assertFalse((String)("File '" + path + "' should not exist in P2!"), (boolean)nonExistingFile.exists());
            IJavaScriptElement element = JavaScriptCore.create((IFolder)this.getFolder("/P2/lib"));
            ExistenceTests.assertTrue((String)"folder '/P2/lib' should be found in P1!", (boolean)element.exists());
            IClassFile existingFile = (IClassFile)JavaScriptCore.create((IResource)file, (IJavaScriptProject)p1);
            ExistenceTests.assertTrue((String)("File '" + path + "' should exist in P1!"), (boolean)existingFile.exists());
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testJarFile() throws Exception {
        try {
            IJavaScriptProject p2 = this.createJavaProject("P2");
            String[] pathsAndContents = new String[]{"test/X.js", "package test;\npublic class X {\n}"};
            this.addLibrary(p2, "lib.jar", "libsrc.zip", pathsAndContents, "1.5");
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[0], new String[]{"/P2/lib.jar"});
            IPackageFragmentRoot root2 = this.getPackageFragmentRoot("/P2/lib.jar");
            ExistenceTests.assertTrue((boolean)root2.exists());
            ExistenceTests.assertEquals((Object)p1.getPackageFragmentRoots()[0], (Object)root2);
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testClassFileInSource1() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"});
            this.createFile("P/src/X.class", "");
            IClassFile classFile = this.getClassFile("P/src/X.class");
            ExistenceTests.assertTrue((String)"Class file should not exist", (!classFile.exists() ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testClassFileInSource2() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"});
            this.createFile("P/src/X.class", "");
            IClassFile classFile = this.getClassFile("P/src/X.class");
            this.assertOpenFails("Operation not supported for specified element type(s):src [in P]", (IOpenable)classFile);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testCompilationUnitInLibrary1() throws CoreException {
        try {
            this.createJavaProject("P", new String[0], new String[]{"lib"});
            this.createFile("P/lib/X.js", "public class X {}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/lib/X.js");
            ExistenceTests.assertTrue((String)"Ccompilation unit should not exist", (!cu.exists() ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testCompilationUnitInLibrary2() throws CoreException {
        try {
            this.createJavaProject("P", new String[0], new String[]{"lib"});
            this.createFile("P/lib/X.js", "public class X {}");
            IJavaScriptUnit cu = this.getCompilationUnit("P/lib/X.js");
            this.assertOpenFails("Operation not supported for specified element type(s):lib [in P]", (IOpenable)cu);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testMethodWithInvalidParameter() throws CoreException {
        try {
            this.createJavaProject("P");
            this.createFile("P/X.js", "public class X {}");
            IFunction method = this.getCompilationUnit("P/X.js").getType("X").getFunction("foo", new String[]{"~12345@"});
            ExistenceTests.assertTrue((String)"Methodr should not exist", (!method.exists() ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testNonExistingClassFile1() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, new String[]{"lib"});
            IClassFile classFile = this.getClassFile("/P/lib/X.class");
            this.assertOpenFails("X.class [in <default> [in lib [in P]]] does not exist", (IOpenable)classFile);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testNonExistingClassFile2() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, new String[0]);
            IClassFile classFile = this.getClassFile("/P/lib/X.class");
            this.assertOpenFails("lib [in P] is not on its project's build path", (IOpenable)classFile);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testNonExistingCompilationUnit() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"});
            IJavaScriptUnit cu = this.getCompilationUnit("/P/src/X.js");
            this.assertOpenFails("X.java [in <default> [in src [in P]]] does not exist", (IOpenable)cu);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testNonExistingPackageFragment1() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"});
            IPackageFragment pkg = this.getPackage("/P/src/x");
            this.assertOpenFails("x [in src [in P]] does not exist", (IOpenable)pkg);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testNonExistingPackageFragment2() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[0]);
            IFolder folder = this.createFolder("/P/src/x");
            IPackageFragment pkg = project.getPackageFragmentRoot((IResource)folder).getPackageFragment("x");
            this.assertOpenFails("src/x [in P] is not on its project's build path", (IOpenable)pkg);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testNonExistingPackageFragment3() throws CoreException {
        try {
            this.createJavaProject("P");
            this.createFolder("/P/pack");
            IPackageFragment pkg = this.getPackage("/P/pack");
            this.editFile("/P/.classpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry excluding=\"pack/\" kind=\"src\" path=\"\"/>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>");
            ExistenceTests.assertFalse((String)"pack should not exist", (boolean)pkg.exists());
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testNonJavaProject() throws CoreException {
        try {
            this.createProject("P");
            IProject project = this.getProject("P");
            IJavaScriptProject javaProject = JavaScriptCore.create((IProject)project);
            ExistenceTests.assertTrue((String)"Simple project should not exist", (!javaProject.exists() ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testPkgFragmentRootNotInClasspath() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IFolder folder = this.createFolder("/P/otherRoot");
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)folder);
            ExistenceTests.assertTrue((String)"Root should not exist", (!root.exists() ? 1 : 0) != 0);
            this.assertOpenFails("otherRoot [in P] is not on its project's build path", (IOpenable)root);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testCorrespondingResourceNonExistingClassFile() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, new String[]{"lib"});
            IClassFile classFile = this.getClassFile("/P/lib/X.class");
            this.assertCorrespondingResourceFails((IJavaScriptElement)classFile);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testCorrespondingResourceNonExistingCompilationUnit() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"});
            IJavaScriptUnit compilationUnit = this.getCompilationUnit("/P/src/X.js");
            this.assertCorrespondingResourceFails((IJavaScriptElement)compilationUnit);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testCorrespondingResourceNonExistingJarPkgFragmentRoot() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IPackageFragmentRoot root = project.getPackageFragmentRoot("/nonExisting.jar");
            this.assertCorrespondingResourceFails((IJavaScriptElement)root);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testCorrespondingResourceNonExistingPkgFragment() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"});
            IPackageFragment pkg = this.getPackage("/P/src/nonExisting");
            this.assertCorrespondingResourceFails((IJavaScriptElement)pkg);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testCorrespondingResourceNonExistingPkgFragmentRoot() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IFolder folder = this.createFolder("/P/nonExistingRoot");
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)folder);
            this.assertCorrespondingResourceFails((IJavaScriptElement)root);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testCorrespondingResourceNonExistingProject() {
        IProject nonExistingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("NonExisting");
        IJavaScriptProject javaProject = JavaScriptCore.create((IProject)nonExistingProject);
        this.assertCorrespondingResourceFails((IJavaScriptElement)javaProject);
    }

    public void testCorrespondingResourceNonExistingType() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"});
            this.createFile("/P/src/X.js", "public class X{\n}");
            IType type = this.getCompilationUnit("/P/src/X.js").getType("NonExisting");
            this.assertCorrespondingResourceFails((IJavaScriptElement)type);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testUnderlyingResourceNonExistingClassFile() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, new String[]{"lib"});
            IClassFile classFile = this.getClassFile("/P/lib/X.js");
            this.assertUnderlyingResourceFails((IJavaScriptElement)classFile);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testUnderlyingResourceNonExistingCompilationUnit() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"});
            IJavaScriptUnit compilationUnit = this.getCompilationUnit("/P/src/X.js");
            this.assertUnderlyingResourceFails((IJavaScriptElement)compilationUnit);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testUnderlyingResourceNonExistingPkgFragment() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"});
            IPackageFragment pkg = this.getPackage("/P/src/nonExisting");
            this.assertUnderlyingResourceFails((IJavaScriptElement)pkg);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testUnderlyingResourceNonExistingPkgFragmentRoot() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            IFolder folder = this.createFolder("/P/nonExistingRoot");
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)folder);
            this.assertUnderlyingResourceFails((IJavaScriptElement)root);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testUnderlyingResourceNonExistingProject() {
        IProject nonExistingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("NonExisting");
        IJavaScriptProject javaProject = JavaScriptCore.create((IProject)nonExistingProject);
        this.assertUnderlyingResourceFails((IJavaScriptElement)javaProject);
    }

    public void testUnderlyingResourceNonExistingType() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"});
            this.createFile("/P/src/X.js", "function X(){\n}");
            IType type = this.getCompilationUnit("/P/src/X.js").getType("NonExisting");
            this.assertUnderlyingResourceFails((IJavaScriptElement)type);
        }
        finally {
            this.deleteProject("P");
        }
    }
}

