/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.List;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;

class DefaultJavaElementComparator
implements Comparator {
    private static final int STATIC_TYPE_CATEGORY = 0;
    private static final int STATIC_FIELD_CATEGORY = 1;
    private static final int STATIC_INITIALIZER_CATEGORY = 2;
    private static final int STATIC_METHOD_CATEGORY = 3;
    private static final int TYPE_CATEGORY = 4;
    private static final int FIELD_CATEGORY = 5;
    private static final int INITIALIZER_CATEGORY = 6;
    private static final int CONSTRUCTOR_CATEGORY = 7;
    private static final int METHOD_CATEGORY = 8;
    private Collator collator;
    private int[] categories;

    public DefaultJavaElementComparator() {
        this.categories = new int[]{1, 2, 3, 7, 6, 4, 5, 8, 9};
        this.collator = Collator.getInstance();
    }

    public DefaultJavaElementComparator(int staticTypeCategory, int staticFieldCategory, int staticInitializerCategory, int staticMethodCategory, int typeCategory, int fieldCategory, int initializerCategory, int constructorCategory, int methodCategory) {
        this.categories = new int[]{staticTypeCategory, staticFieldCategory, staticInitializerCategory, staticMethodCategory, typeCategory, fieldCategory, initializerCategory, constructorCategory, methodCategory};
        this.collator = Collator.getInstance();
    }

    private int getCategory(BodyDeclaration node) {
        switch (node.getNodeType()) {
            case 31: {
                FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
                if (methodDeclaration.isConstructor()) {
                    return this.categories[7];
                }
                if (Flags.isStatic((int)methodDeclaration.getModifiers())) {
                    return this.categories[3];
                }
                return this.categories[8];
            }
            case 23: {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
                if (Flags.isStatic((int)fieldDeclaration.getModifiers())) {
                    return this.categories[1];
                }
                return this.categories[5];
            }
            case 55: {
                AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)node;
                if (Flags.isStatic((int)abstractTypeDeclaration.getModifiers())) {
                    return this.categories[0];
                }
                return this.categories[4];
            }
            case 28: {
                Initializer initializer = (Initializer)node;
                if (Flags.isStatic((int)initializer.getModifiers())) {
                    return this.categories[2];
                }
                return this.categories[6];
            }
        }
        return 0;
    }

    public int compare(Object o1, Object o2) {
        int compare;
        int category2;
        if (!(o1 instanceof BodyDeclaration) && !(o2 instanceof BodyDeclaration)) {
            throw new ClassCastException();
        }
        BodyDeclaration node1 = (BodyDeclaration)o1;
        BodyDeclaration node2 = (BodyDeclaration)o2;
        int category1 = this.getCategory(node1);
        if (category1 != (category2 = this.getCategory(node2))) {
            return category1 - category2;
        }
        if (o1 == o2) {
            return 0;
        }
        String node1Signature = this.buildSignature(node1);
        String node2Signature = this.buildSignature(node2);
        if (node1Signature.length() != 0 && node2Signature.length() != 0 && (compare = this.collator.compare(node1Signature, node2Signature)) != 0) {
            return compare;
        }
        int sourceStart1 = (Integer)node1.getProperty("relativeOrder");
        int sourceStart2 = (Integer)node2.getProperty("relativeOrder");
        return sourceStart1 - sourceStart2;
    }

    private String buildSignature(BodyDeclaration node) {
        switch (node.getNodeType()) {
            case 31: {
                FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
                StringBuffer buffer = new StringBuffer();
                buffer.append(methodDeclaration.getName().getIdentifier());
                List parameters = methodDeclaration.parameters();
                int length1 = parameters.size();
                int i = 0;
                while (i < length1) {
                    SingleVariableDeclaration parameter = (SingleVariableDeclaration)parameters.get(i);
                    buffer.append(parameter.getName().getIdentifier());
                    Type type = parameter.getType();
                    buffer.append(this.buildSignature(type));
                    ++i;
                }
                return String.valueOf(buffer);
            }
            case 23: {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
                return ((VariableDeclarationFragment)fieldDeclaration.fragments().get(0)).getName().getIdentifier();
            }
            case 28: {
                return ((Integer)node.getProperty("relativeOrder")).toString();
            }
            case 55: {
                AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)node;
                return abstractTypeDeclaration.getName().getIdentifier();
            }
        }
        return null;
    }

    private String buildSignature(Type type) {
        switch (type.getNodeType()) {
            case 39: {
                PrimitiveType.Code code = ((PrimitiveType)type).getPrimitiveTypeCode();
                return code.toString();
            }
            case 5: {
                ArrayType arrayType = (ArrayType)type;
                StringBuffer buffer = new StringBuffer();
                buffer.append(this.buildSignature(arrayType.getElementType()));
                int dimensions = arrayType.getDimensions();
                int j = 0;
                while (j < dimensions) {
                    buffer.append("[]");
                    ++j;
                }
                return buffer.toString();
            }
            case 43: {
                SimpleType simpleType = (SimpleType)type;
                return this.buildSignature(simpleType.getName());
            }
        }
        return null;
    }

    private String buildSignature(Name name) {
        if (name.isSimpleName()) {
            return ((SimpleName)name).getIdentifier();
        }
        QualifiedName qualifiedName = (QualifiedName)name;
        return String.valueOf(this.buildSignature(qualifiedName.getQualifier())) + "." + this.buildSignature((Name)qualifiedName.getName());
    }
}

