/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.BufferChangedEvent;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IBufferChangedListener;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class BufferTests
extends ModifyingResourceTests
implements IBufferChangedListener {
    protected ArrayList events = null;

    public BufferTests(String name) {
        super(name);
    }

    public void bufferChanged(BufferChangedEvent bufferChangedEvent) {
        this.events.add(bufferChangedEvent);
    }

    protected IBuffer createBuffer(String path, String content) throws CoreException {
        BufferTests.waitUntilIndexesReady();
        this.createFile(path, content);
        IJavaScriptUnit cu = this.getCompilationUnit(path);
        IBuffer buffer = cu.getBuffer();
        buffer.addBufferChangedListener((IBufferChangedListener)this);
        this.events = new ArrayList();
        return buffer;
    }

    protected void deleteBuffer(IBuffer buffer) throws CoreException {
        buffer.removeBufferChangedListener((IBufferChangedListener)this);
        IResource resource = buffer.getUnderlyingResource();
        if (resource != null) {
            this.deleteResource(resource);
        }
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        try {
            this.createJavaProject("P", new String[]{""});
            this.createFolder("P/x/y");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
        this.deleteProject("P");
    }

    public static Test suite() {
        return BufferTests.buildModelTestSuite(BufferTests.class);
    }

    public void testAppend() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};");
        try {
            int oldLength = buffer.getLength();
            buffer.append("\nvar a = new A();");
            this.assertBufferEvent(oldLength, 0, "\nvar a = new A();");
            this.assertSourceEquals("unexpected buffer contents", "function A() {\n};\nvar a = new A();", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testClose() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};");
        try {
            buffer.close();
            this.assertBufferEvent(0, 0, null);
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testGetUnderlyingResource() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};");
        IJavaScriptUnit copy = null;
        try {
            IFile file = this.getFile("P/x/y/A.js");
            BufferTests.assertEquals((String)"Unexpected underlying resource", (Object)file, (Object)buffer.getUnderlyingResource());
            copy = this.getCompilationUnit("P/x/y/A.js").getWorkingCopy(null);
            BufferTests.assertEquals((String)"Unexpected underlying resource 2", (Object)file, (Object)copy.getBuffer().getUnderlyingResource());
        }
        finally {
            this.deleteBuffer(buffer);
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }

    public void testDeleteBeginning() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};\nvar a = new A();");
        try {
            buffer.replace(0, 18, "");
            this.assertBufferEvent(0, 18, null);
            this.assertSourceEquals("unexpected buffer contents", "var a = new A();", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testDeleteMiddle() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};\nvar a = new A();\nvar a1 = new A();");
        try {
            buffer.replace(18, 17, "");
            this.assertBufferEvent(18, 17, null);
            this.assertSourceEquals("unexpected buffer contents", "function A() {\n};\nvar a1 = new A();", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testDeleteEnd() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};\nvar a = new A();");
        try {
            buffer.replace(17, 17, "");
            this.assertBufferEvent(17, 17, null);
            this.assertSourceEquals("unexpected buffer contents", "function A() {\n};", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testGetChar() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};");
        try {
            BufferTests.assertEquals((String)"Unexpected char at position 9", (char)'A', (char)buffer.getChar(9));
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testGetChar2() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};");
        buffer.close();
        try {
            BufferTests.assertEquals((String)"Unexpected char at position 9", (char)'\u0000', (char)buffer.getChar(9));
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testGetLength() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};");
        try {
            BufferTests.assertEquals((String)"Unexpected length", (int)17, (int)buffer.getLength());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testGetText() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};");
        try {
            this.assertSourceEquals("Unexpected text (1)", "f", buffer.getText(0, 1));
            this.assertSourceEquals("Unexpected text (2)", "A()", buffer.getText(9, 3));
            this.assertSourceEquals("Unexpected text (3)", "", buffer.getText(12, 0));
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testInsertBeginning() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};");
        try {
            buffer.replace(0, 0, "/* copyright mycompany */\n");
            this.assertBufferEvent(0, 0, "/* copyright mycompany */\n");
            this.assertSourceEquals("unexpected buffer contents", "/* copyright mycompany */\nfunction A() {\n};", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testReplaceBeginning() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};");
        try {
            buffer.replace(0, 12, "function B()");
            this.assertBufferEvent(0, 12, "function B()");
            this.assertSourceEquals("unexpected buffer contents", "function B() {\n};", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testReplaceMiddle() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};");
        try {
            buffer.replace(9, 3, "B( )");
            this.assertBufferEvent(9, 3, "B( )");
            this.assertSourceEquals("unexpected buffer contents", "function B( ) {\n};", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testReplaceEnd() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};");
        try {
            int end = buffer.getLength();
            buffer.replace(end - 1, 1, ";\n");
            this.assertBufferEvent(end - 1, 1, ";\n");
            this.assertSourceEquals("unexpected buffer contents", "function A() {\n};\n", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testInsertMiddle() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A() {\n};");
        try {
            buffer.replace(15, 0, "// comment\n");
            this.assertBufferEvent(15, 0, "// comment\n");
            this.assertSourceEquals("unexpected buffer contents", "function A() {\n// comment\n};", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testInsertEnd() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.js", "function A(){\n};");
        try {
            int end = buffer.getLength();
            buffer.replace(end, 0, "\nfunction B(){\n};");
            this.assertBufferEvent(end, 0, "\nfunction B(){\n};");
            this.assertSourceEquals("unexpected buffer contents", "function A(){\n};\nfunction B(){\n};", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    protected void assertBufferEvent(int offset, int length, String text) {
        BufferTests.assertTrue((String)"events should not be null", (this.events != null ? 1 : 0) != 0);
        BufferTests.assertTrue((String)"events should not be empty", (!this.events.isEmpty() ? 1 : 0) != 0);
        BufferChangedEvent event = (BufferChangedEvent)this.events.get(0);
        BufferTests.assertEquals((String)"unexpected offset", (int)offset, (int)event.getOffset());
        BufferTests.assertEquals((String)"unexpected length", (int)length, (int)event.getLength());
        if (text == null) {
            BufferTests.assertTrue((String)"text should be null", (event.getText() == null ? 1 : 0) != 0);
        } else {
            this.assertSourceEquals("unexpected text", text, event.getText());
        }
    }

    protected void assertBufferEvents(String expected) {
        StringBuffer buffer = new StringBuffer();
        if (this.events == null) {
            buffer.append("<null>");
        } else {
            int i = 0;
            int length = this.events.size();
            while (i < length) {
                BufferChangedEvent event = (BufferChangedEvent)this.events.get(i);
                buffer.append('(');
                buffer.append(event.getOffset());
                buffer.append(", ");
                buffer.append(event.getLength());
                buffer.append(") ");
                buffer.append(event.getText());
                if (i < length - 1) {
                    buffer.append("\n");
                }
                ++i;
            }
        }
        this.assertSourceEquals("Unexpected buffer events", expected, buffer.toString());
    }
}

