/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.transformer.DisabledTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class GraphIteratorTests
extends TestCase {
    Collection<GraphNode> nodes = new ArrayList<GraphNode>();
    private static final TransformerAdapter<GraphNode, Iterator<? extends GraphNode>> CHILDREN_TRANSFORMER = new ChildrenTransformer();

    public GraphIteratorTests(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testHasNext() {
        Iterator<GraphNode> iterator = this.buildGraphIterator();
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        GraphIteratorTests.assertEquals((int)this.nodes.size(), (int)i);
    }

    public void testNext() {
        Iterator<GraphNode> iterator = this.buildGraphIterator();
        while (iterator.hasNext()) {
            GraphIteratorTests.assertTrue((String)"bogus element", (boolean)this.nodes.contains(iterator.next()));
        }
    }

    public void testNoSuchElementException() {
        Iterator<GraphNode> iterator = this.buildGraphIterator();
        boolean exCaught = false;
        while (iterator.hasNext()) {
            iterator.next();
        }
        try {
            iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        GraphIteratorTests.assertTrue((String)"NoSuchElementException not thrown", (boolean)exCaught);
    }

    public void testSize() {
        int actualSize;
        Iterator<GraphNode> iterator = this.buildGraphIterator();
        int iteratorSize = IteratorTools.size(iterator);
        GraphIteratorTests.assertTrue((String)"Too few items in iterator.", (iteratorSize >= (actualSize = this.nodes.size()) ? 1 : 0) != 0);
        GraphIteratorTests.assertTrue((String)"Too many items in iterator.", (iteratorSize <= actualSize ? 1 : 0) != 0);
    }

    public void testInvalidGraphIterator() {
        boolean exCaught = false;
        try {
            Iterator iterator = IteratorTools.graphIterator((Object)this.buildGraphRoot(), (Transformer)DisabledTransformer.instance());
            GraphNode gn = (GraphNode)iterator.next();
            GraphIteratorTests.fail((String)("invalid graph node: " + gn));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        GraphIteratorTests.assertTrue((String)"NoSuchElementException not thrown", (boolean)exCaught);
    }

    private Iterator<GraphNode> buildGraphIterator() {
        return IteratorTools.graphIterator((Object)this.buildGraphRoot(), CHILDREN_TRANSFORMER);
    }

    private GraphNode buildGraphRoot() {
        GraphNode ncNode = new GraphNode("North Carolina");
        GraphNode vaNode = new GraphNode("Virginia");
        GraphNode scNode = new GraphNode("South Carolina");
        GraphNode gaNode = new GraphNode("Georgia");
        GraphNode flNode = new GraphNode("Florida");
        GraphNode alNode = new GraphNode("Alabama");
        GraphNode msNode = new GraphNode("Mississippi");
        GraphNode tnNode = new GraphNode("Tennessee");
        ncNode.setNeighbors(new GraphNode[]{vaNode, scNode, gaNode, tnNode});
        vaNode.setNeighbors(new GraphNode[]{ncNode, tnNode});
        scNode.setNeighbors(new GraphNode[]{ncNode, gaNode});
        gaNode.setNeighbors(new GraphNode[]{ncNode, scNode, flNode, alNode, tnNode});
        flNode.setNeighbors(new GraphNode[]{gaNode});
        alNode.setNeighbors(new GraphNode[]{gaNode, msNode, tnNode});
        msNode.setNeighbors(new GraphNode[]{alNode, tnNode});
        tnNode.setNeighbors(new GraphNode[]{vaNode, ncNode, gaNode, alNode, msNode});
        return ncNode;
    }

    static class ChildrenTransformer
    extends TransformerAdapter<GraphNode, Iterator<? extends GraphNode>> {
        ChildrenTransformer() {
        }

        public Iterator<GraphNode> transform(GraphNode node) {
            return node.neighbors();
        }
    }

    public class GraphNode {
        private String name;
        private Collection<GraphNode> neighbors = new ArrayList<GraphNode>();

        public GraphNode(String name) {
            GraphIteratorTests.this.nodes.add(this);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void setNeighbors(GraphNode[] neighbors) {
            this.neighbors = ListTools.arrayList((Object[])neighbors);
        }

        public Iterator<GraphNode> neighbors() {
            return this.neighbors.iterator();
        }

        public int neighborsSize() {
            return this.neighbors.size();
        }

        public String toString() {
            return "GraphNode(" + this.name + ")";
        }
    }
}

