/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.web.core.internal.PathUtils;

public class PathUtilsTests
extends TestCase {
    public PathUtilsTests() {
        super("Path Utils Tests");
    }

    public void testOneSegmentParentWithOneSegmentPattern_SegmentCountTest_0() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("foo", "foo", 1);
    }

    public void testOneSegmentParentWithOneSegmentPattern_SegmentCountTest_1() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo", "foo", 1);
    }

    public void testOneSegmentParentWithOneSegmentPattern_SegmentCountTest_2() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo", "foo", 1);
    }

    public void testOneSegmentParentWithOneSegmentPattern_SegmentCountTest_3() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("foo", "/foo", 1);
    }

    public void testOneSegmentParentWithOneSegmentPattern_SegmentCountTest_4() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo", "/foo", 1);
    }

    public void testOneSegmentParentWithTwoSegmentPattern_SegmentCountTest_0() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("foo/bar", "foo", 1);
    }

    public void testOneSegmentParentWithTwoSegmentPattern_SegmentCountTest_1() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/bar", "foo", 1);
    }

    public void testOneSegmentParentWithTwoSegmentPattern_SegmentCountTest_2() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/bar", "foo", 1);
    }

    public void testOneSegmentParentWithTwoSegmentPattern_SegmentCountTest_3() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("foo/bar", "/foo", 1);
    }

    public void testOneSegmentParentWithTwoSegmentPattern_SegmentCountTest_4() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/bar", "/foo", 1);
    }

    public void testOneSegmentParentWithTwoSegmentPattern_SegmentCountTest_5() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("foo/bar/", "foo", 1);
    }

    public void testOneSegmentParentWithTwoSegmentPattern_SegmentCountTest_6() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/bar/", "foo", 1);
    }

    public void testOneSegmentParentWithTwoSegmentPattern_SegmentCountTest_7() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/bar/", "foo", 1);
    }

    public void testOneSegmentParentWithTwoSegmentPattern_SegmentCountTest_8() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("foo/bar/", "/foo", 1);
    }

    public void testOneSegmentParentWithTwoSegmentPattern_SegmentCountTest_9() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/bar/", "/foo", 1);
    }

    public void testOneSegmentParentWithTwoSegmentPattern_SegmentCountTest_10() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/bar/", "/boo", 0);
    }

    public void testTwoSegmentParentWithThreeSegmentPattern_SegmentCountTest_0() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/bar/blarg", "/foo/bar", 2);
    }

    public void testStar_SegmentCountTest_0() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/*/blarg", "foo/bar", 2);
    }

    public void testStar_SegmentCountTest_1() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/*", "foo", 1);
    }

    public void testStar_SegmentCountTest_2() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/*", "foo/blarg", 2);
    }

    public void testStar_SegmentCountTest_3() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/*", "foo", 1);
    }

    public void testStarStar_SegmentCountTest_0() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/**", "foo", 1);
    }

    public void testStarStar_SegmentCountTest_1() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/**", "foo/bar", 2);
    }

    public void testStarStar_SegmentCountTest_2() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/**", "foo/bar/blarg", 3);
    }

    public void testStarStar_SegmentCountTest_3() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/**/blarg", "foo/bar/blarg", 3);
    }

    public void testStarStar_SegmentCountTest_4() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/**/blarg", "foo/bar/boo/blarg", 3);
    }

    public void testStarStar_SegmentCountTest_5() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("/foo/**/blarg/nerg", "foo/bar/boo/blarg", 3);
    }

    public void testQuestionMark_SegmentCountTest_0() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("foo?bar", "/fooZbar", 1);
    }

    public void testQuestionMark_SegmentCountTest_1() {
        PathUtilsTests.runCountPatternSegmentsThatMatchParentTest("foo?bar", "/foobar", 0);
    }

    public void testOneSegmentParentWithOneSegmentPattern_TransformPatternTest_0() {
        PathUtilsTests.runMakePatternRelativeToParentTest("foo", "foo", null);
    }

    public void testOneSegmentParentWithOneSegmentPattern_TransformPatternTest_1() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo", "foo", null);
    }

    public void testOneSegmentParentWithOneSegmentPattern_TransformPatternTest_2() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo", "foo", null);
    }

    public void testOneSegmentParentWithOneSegmentPattern_TransformPatternTest_3() {
        PathUtilsTests.runMakePatternRelativeToParentTest("foo", "foo", null);
    }

    public void testOneSegmentParentWithOneSegmentPattern_TransformPatternTest_4() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo", "foo", null);
    }

    public void testOneSegmentParentWithTwoSegmentPattern_TransformPatternTest_0() {
        PathUtilsTests.runMakePatternRelativeToParentTest("foo/bar", "foo", "bar/");
    }

    public void testOneSegmentParentWithTwoSegmentPattern_TransformPatternTest_1() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/bar", "foo", "bar/");
    }

    public void testOneSegmentParentWithTwoSegmentPattern_TransformPatternTest_2() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/bar", "foo", "bar/");
    }

    public void testOneSegmentParentWithTwoSegmentPattern_TransformPatternTest_3() {
        PathUtilsTests.runMakePatternRelativeToParentTest("foo/bar", "/foo", "bar/");
    }

    public void testOneSegmentParentWithTwoSegmentPattern_TransformPatternTest_4() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/bar", "/foo", "bar/");
    }

    public void testOneSegmentParentWithTwoSegmentPattern_TransformPatternTest_5() {
        PathUtilsTests.runMakePatternRelativeToParentTest("foo/bar/", "foo", "bar/");
    }

    public void testOneSegmentParentWithTwoSegmentPattern_TransformPatternTest_6() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/bar/", "foo", "bar/");
    }

    public void testOneSegmentParentWithTwoSegmentPattern_TransformPatternTest_7() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/bar/", "foo", "bar/");
    }

    public void testOneSegmentParentWithTwoSegmentPattern_TransformPatternTest_8() {
        PathUtilsTests.runMakePatternRelativeToParentTest("foo/bar/", "/foo", "bar/");
    }

    public void testOneSegmentParentWithTwoSegmentPattern_TransformPatternTest_9() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/bar/", "/foo", "bar/");
    }

    public void testOneSegmentParentWithTwoSegmentPattern_TransformPatternTest_10() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/bar/", "/boo", null);
    }

    public void testTwoSegmentParentWithThreeSegmentPattern_TransformPatternTest_0() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/bar/blarg", "/foo/bar", "blarg/");
    }

    public void testStar_TransformPatternTest_0() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/*/blarg", "foo/bar", "blarg/");
    }

    public void testStar_TransformPatternTest_1() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/*", "foo", "*/");
    }

    public void testStar_TransformPatternTest_2() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/*", "foo/blarg/", null);
    }

    public void testStar_TransformPatternTest_3() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/*", "foo", "*/");
    }

    public void testStarStar_TransformPatternTest_0() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/**", "foo", "**/");
    }

    public void testStarStar_TransformPatternTest_1() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/**", "foo/bar/", null);
    }

    public void testStarStar_TransformPatternTest_2() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/**", "foo/bar/blarg/", null);
    }

    public void testStarStar_TransformPatternTest_3() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/**/blarg", "foo/bar/blarg/", null);
    }

    public void testStarStar_TransformPatternTest_4() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/**/blarg", "foo/bar/boo/blarg/", null);
    }

    public void testStarStar_TransformPatternTest_5() {
        PathUtilsTests.runMakePatternRelativeToParentTest("/foo/**/blarg/nerg", "foo/bar/boo/blarg", "nerg/");
    }

    public void testQuestionMark_TransformPatternTest_0() {
        PathUtilsTests.runMakePatternRelativeToParentTest("foo?bar", "/fooZbar", null);
    }

    public void testQuestionMark_TransformPatternTest_1() {
        PathUtilsTests.runMakePatternRelativeToParentTest("foo?bar", "/foobar", null);
    }

    public void testQuestionMark_TransformPatternTest_2() {
        PathUtilsTests.runMakePatternRelativeToParentTest("foo?bar/awesome", "/fooZbar", "awesome/");
    }

    public void testQuestionMark_TransformPatternTest_3() {
        PathUtilsTests.runMakePatternRelativeToParentTest("foo?bar/awesome", "/foobar", null);
    }

    private static void runCountPatternSegmentsThatMatchParentTest(String pattern, String parentPath, int expectedMatchedSegments) {
        int matchedSegments = PathUtils.countPatternSegmentsThatMatchParent((IPath)new Path(pattern), (IPath)new Path(parentPath));
        Assert.assertEquals((String)"Number of matched path segments does not equal expected.", (int)expectedMatchedSegments, (int)matchedSegments);
    }

    private static void runMakePatternRelativeToParentTest(String pattern, String parent, String expected) {
        IPath transformedPattern = PathUtils.makePatternRelativeToParent((IPath)new Path(pattern), (IPath)new Path(parent));
        Path expectedPath = null;
        if (expected != null) {
            expectedPath = new Path(expected);
        }
        Assert.assertEquals((String)"Transformed pattern does not match expected.", expectedPath, (Object)transformedPattern);
    }
}

