/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.describing;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingTest;

public class ASTRewritingTrackingTest
extends ASTRewritingTest {
    private static final Class THIS = ASTRewritingTrackingTest.class;

    public ASTRewritingTrackingTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test setUpTest(Test someTest) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite("one test");
        suite.addTest(someTest);
        return suite;
    }

    public static Test suite() {
        return ASTRewritingTrackingTest.allTests();
    }

    public void testNamesWithDelete() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("public class C {\n");
        buf.append("\n");
        buf.append("    public int x1;\n");
        buf.append("\n");
        buf.append("    public void foo(String s, int i) {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("            i--;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ITrackedNodePosition> positions = new ArrayList<ITrackedNodePosition>();
        TypeDeclaration typeC = ASTRewritingTrackingTest.findTypeDeclaration(astRoot, "C");
        ITrackedNodePosition position = rewrite.track((ASTNode)typeC.getName());
        names.add("C");
        positions.add(position);
        List decls = typeC.bodyDeclarations();
        FunctionDeclaration method = (FunctionDeclaration)decls.get(1);
        ITrackedNodePosition position2 = rewrite.track((ASTNode)method.getName());
        names.add("foo");
        positions.add(position2);
        FieldDeclaration field = (FieldDeclaration)decls.get(0);
        rewrite.remove((ASTNode)field, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("public class C {\n");
        buf.append("\n");
        buf.append("    public void foo(String s, int i) {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("            i--;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        String expected = buf.toString();
        ASTRewritingTrackingTest.assertEqualString(preview, expected);
        this.assertCorrectTracking(names, positions, expected);
    }

    private void assertCorrectTracking(List names, List positions, String expected) {
        int i = 0;
        while (i < names.size()) {
            String name = (String)names.get(i);
            ITrackedNodePosition pos = (ITrackedNodePosition)positions.get(i);
            String string = expected.substring(pos.getStartPosition(), pos.getStartPosition() + pos.getLength());
            ASTRewritingTrackingTest.assertEqualString(string, name);
            ++i;
        }
    }

    public void testNamesWithInsert() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("\n");
        buf.append("    public int x1;\n");
        buf.append("\n");
        buf.append("    public void foo(String s, int i) {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("            i--;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ITrackedNodePosition> positions = new ArrayList<ITrackedNodePosition>();
        TypeDeclaration typeC = ASTRewritingTrackingTest.findTypeDeclaration(astRoot, "C");
        ITrackedNodePosition position = rewrite.track((ASTNode)typeC.getName());
        names.add("C");
        positions.add(position);
        List decls = typeC.bodyDeclarations();
        FunctionDeclaration method = (FunctionDeclaration)decls.get(1);
        position = rewrite.track((ASTNode)method.getName());
        names.add("foo");
        positions.add(position);
        FieldDeclaration field = (FieldDeclaration)decls.get(0);
        List fragments = field.fragments();
        VariableDeclarationFragment frag1 = (VariableDeclarationFragment)fragments.get(0);
        position = rewrite.track((ASTNode)frag1.getName());
        names.add("x1");
        positions.add(position);
        VariableDeclarationFragment newFrag = ast.newVariableDeclarationFragment();
        newFrag.setName(ast.newSimpleName("newVariable"));
        newFrag.setExtraDimensions(2);
        rewrite.getListRewrite((ASTNode)field, FieldDeclaration.FRAGMENTS_PROPERTY).insertFirst((ASTNode)newFrag, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("\n");
        buf.append("    public int newVariable[][], x1;\n");
        buf.append("\n");
        buf.append("    public void foo(String s, int i) {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("            i--;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        String expected = buf.toString();
        ASTRewritingTrackingTest.assertEqualString(preview, expected);
        this.assertCorrectTracking(names, positions, expected);
    }

    public void testNamesWithReplace() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("\n");
        buf.append("    public int x1;\n");
        buf.append("\n");
        buf.append("    public void foo(String s, int i) {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("            ++i;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ITrackedNodePosition> positions = new ArrayList<ITrackedNodePosition>();
        TypeDeclaration typeC = ASTRewritingTrackingTest.findTypeDeclaration(astRoot, "C");
        SimpleName newName = ast.newSimpleName("XX");
        rewrite.replace((ASTNode)typeC.getName(), (ASTNode)newName, null);
        ITrackedNodePosition position = rewrite.track((ASTNode)newName);
        names.add("XX");
        positions.add(position);
        List decls = typeC.bodyDeclarations();
        FunctionDeclaration method = (FunctionDeclaration)decls.get(1);
        position = rewrite.track((ASTNode)method.getName());
        names.add("foo");
        positions.add(position);
        WhileStatement whileStatement = (WhileStatement)method.getBody().statements().get(0);
        PrefixExpression prefixExpression = (PrefixExpression)((ExpressionStatement)((Block)whileStatement.getBody()).statements().get(0)).getExpression();
        position = rewrite.track((ASTNode)prefixExpression.getOperand());
        names.add("i");
        positions.add(position);
        FieldDeclaration field = (FieldDeclaration)decls.get(0);
        List fragments = field.fragments();
        VariableDeclarationFragment frag1 = (VariableDeclarationFragment)fragments.get(0);
        position = rewrite.track((ASTNode)frag1.getName());
        names.add("x1");
        positions.add(position);
        int newModifiers = 138;
        rewrite.set((ASTNode)field, (StructuralPropertyDescriptor)FieldDeclaration.MODIFIERS_PROPERTY, (Object)newModifiers, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class XX {\n");
        buf.append("\n");
        buf.append("    private static transient int x1;\n");
        buf.append("\n");
        buf.append("    public void foo(String s, int i) {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("            ++i;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        String expected = buf.toString();
        ASTRewritingTrackingTest.assertEqualString(preview, expected);
        this.assertCorrectTracking(names, positions, expected);
    }

    public void testNamesWithMove1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("\n");
        buf.append("    public int x1;\n");
        buf.append("\n");
        buf.append("    public void foo(String s, int i) {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("            ++i;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ITrackedNodePosition> positions = new ArrayList<ITrackedNodePosition>();
        TypeDeclaration typeC = ASTRewritingTrackingTest.findTypeDeclaration(astRoot, "C");
        ITrackedNodePosition position = rewrite.track((ASTNode)typeC.getName());
        names.add("C");
        positions.add(position);
        List decls = typeC.bodyDeclarations();
        FunctionDeclaration method = (FunctionDeclaration)decls.get(1);
        position = rewrite.track((ASTNode)method.getName());
        names.add("foo");
        positions.add(position);
        WhileStatement whileStatement = (WhileStatement)method.getBody().statements().get(0);
        PrefixExpression prefixExpression = (PrefixExpression)((ExpressionStatement)((Block)whileStatement.getBody()).statements().get(0)).getExpression();
        position = rewrite.track((ASTNode)prefixExpression.getOperand());
        names.add("i");
        positions.add(position);
        FieldDeclaration field = (FieldDeclaration)decls.get(0);
        List fragments = field.fragments();
        VariableDeclarationFragment frag1 = (VariableDeclarationFragment)fragments.get(0);
        position = rewrite.track((ASTNode)frag1.getName());
        names.add("x1");
        positions.add(position);
        ASTNode placeHolder = rewrite.createMoveTarget((ASTNode)method);
        rewrite.getListRewrite((ASTNode)typeC, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst(placeHolder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("\n");
        buf.append("    public void foo(String s, int i) {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("            ++i;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    public int x1;\n");
        buf.append("}\n");
        String expected = buf.toString();
        ASTRewritingTrackingTest.assertEqualString(preview, expected);
        this.assertCorrectTracking(names, positions, expected);
    }

    public void testNamesWithMove2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("    public void foo(String s, int i) {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("            ++i;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ITrackedNodePosition> positions = new ArrayList<ITrackedNodePosition>();
        TypeDeclaration typeC = ASTRewritingTrackingTest.findTypeDeclaration(astRoot, "C");
        ITrackedNodePosition position = rewrite.track((ASTNode)typeC.getName());
        names.add("C");
        positions.add(position);
        List decls = typeC.bodyDeclarations();
        FunctionDeclaration method = (FunctionDeclaration)decls.get(0);
        position = rewrite.track((ASTNode)method.getName());
        names.add("foo");
        positions.add(position);
        WhileStatement whileStatement = (WhileStatement)method.getBody().statements().get(0);
        PrefixExpression prefixExpression = (PrefixExpression)((ExpressionStatement)((Block)whileStatement.getBody()).statements().get(0)).getExpression();
        position = rewrite.track((ASTNode)prefixExpression.getOperand());
        names.add("i");
        positions.add(position);
        ASTNode placeHolder = rewrite.createMoveTarget((ASTNode)whileStatement);
        TryStatement tryStatement = ast.newTryStatement();
        tryStatement.getBody().statements().add(placeHolder);
        tryStatement.setFinally(ast.newBlock());
        rewrite.replace((ASTNode)whileStatement, (ASTNode)tryStatement, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("    public void foo(String s, int i) {\n");
        buf.append("        try {\n");
        buf.append("            while (i == 0) {\n");
        buf.append("                ++i;\n");
        buf.append("            }\n");
        buf.append("        } finally {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        String expected = buf.toString();
        ASTRewritingTrackingTest.assertEqualString(preview, expected);
        this.assertCorrectTracking(names, positions, expected);
    }

    public void testNamesWithMove3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("\n");
        buf.append("    public int x1;\n");
        buf.append("\n");
        buf.append("    public void foo(String s, int i) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ITrackedNodePosition> positions = new ArrayList<ITrackedNodePosition>();
        TypeDeclaration typeC = ASTRewritingTrackingTest.findTypeDeclaration(astRoot, "C");
        ITrackedNodePosition position = rewrite.track((ASTNode)typeC.getName());
        names.add("C");
        positions.add(position);
        List decls = typeC.bodyDeclarations();
        FunctionDeclaration method = (FunctionDeclaration)decls.get(1);
        position = rewrite.track((ASTNode)method.getName());
        names.add("foo");
        positions.add(position);
        ASTNode placeHolder = rewrite.createMoveTarget((ASTNode)method);
        rewrite.getListRewrite((ASTNode)typeC, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst(placeHolder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("\n");
        buf.append("    public void foo(String s, int i) {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    public int x1;\n");
        buf.append("}\n");
        String expected = buf.toString();
        ASTRewritingTrackingTest.assertEqualString(preview, expected);
        this.assertCorrectTracking(names, positions, expected);
    }

    public void testNamesWithPlaceholder() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("    public String foo(Object s) {\n");
        buf.append("        return s;\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ITrackedNodePosition> positions = new ArrayList<ITrackedNodePosition>();
        TypeDeclaration typeC = ASTRewritingTrackingTest.findTypeDeclaration(astRoot, "C");
        ITrackedNodePosition position = rewrite.track((ASTNode)typeC.getName());
        names.add("C");
        positions.add(position);
        List decls = typeC.bodyDeclarations();
        FunctionDeclaration method = (FunctionDeclaration)decls.get(0);
        position = rewrite.track((ASTNode)method.getName());
        names.add("foo");
        positions.add(position);
        ReturnStatement cfr_ignored_0 = (ReturnStatement)method.getBody().statements().get(0);
        names.add("String");
        positions.add(position);
        names.add("s");
        positions.add(position);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("    public String foo(Object s) {\n");
        buf.append("        return (String) s;\n");
        buf.append("    }\n");
        buf.append("}\n");
        String expected = buf.toString();
        ASTRewritingTrackingTest.assertEqualString(preview, expected);
        this.assertCorrectTracking(names, positions, expected);
    }
}

