/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class TypeResolveTests
extends ModifyingResourceTests {
    IJavaScriptUnit cu;

    public TypeResolveTests(String name) {
        super(name);
    }

    private IType getType(IType[] types, String sourceTypeName) throws JavaScriptModelException {
        int i = 0;
        while (i < types.length) {
            IType sourceType = types[i];
            if (sourceType.getTypeQualifiedName().equals(sourceTypeName)) {
                return sourceType;
            }
            if ((sourceType = this.getType(sourceType.getTypes(), sourceTypeName)) != null) {
                return sourceType;
            }
            ++i;
        }
        return null;
    }

    private IType getType(String sourceTypeName) throws JavaScriptModelException {
        return this.getType(this.cu.getTypes(), sourceTypeName);
    }

    private String[][] resolveType(String typeName, String sourceTypeName) throws JavaScriptModelException {
        IType sourceType = this.getType(sourceTypeName);
        TypeResolveTests.assertTrue((String)("Type " + sourceTypeName + " was not found"), (sourceType != null ? 1 : 0) != 0);
        return sourceType.resolveType(typeName);
    }

    private String resultToString(String[][] result) {
        StringBuffer toString = new StringBuffer();
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                String[] qualifiedName = result[i];
                String packageName = qualifiedName[0];
                if (packageName.length() > 0) {
                    toString.append(packageName);
                    toString.append(".");
                }
                toString.append(qualifiedName[1]);
                if (i < result.length - 1) {
                    toString.append("\n");
                }
                ++i;
            }
        }
        return toString.toString();
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setUpJavaProject("TypeResolve");
        this.cu = this.getCompilationUnit("TypeResolve", "src", "p", "TypeResolve.js");
    }

    public static Test suite() {
        return TypeResolveTests.buildModelTestSuite(TypeResolveTests.class);
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.deleteProject("TypeResolve");
        super.tearDownSuite();
    }

    public void testResolveInSecondaryType() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/TypeResolve/src/p3/B.js").getType("Test");
        String[][] types = type.resolveType("B");
        TypeResolveTests.assertEquals((String)"Unexpected result", (String)"p3.B", (String)this.resultToString(types));
    }

    public void testResolveMemberTypeInInner() throws JavaScriptModelException {
        String[][] types = this.resolveType("B", "TypeResolve$A$B$D");
        TypeResolveTests.assertEquals((String)"Unexpected result", (String)"p.TypeResolve.A.B", (String)this.resultToString(types));
    }

    public void testResolveParameterizedType() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"}, new String[]{"JCL15_LIB"}, "bin", "1.5");
            this.createFile("/P/src/X.js", "public class X<T> {\n  X<String> field;\n}");
            IType type = this.getCompilationUnit("/P/src/X.js").getType("X");
            String[][] types = type.resolveType("X<String>");
            TypeResolveTests.assertEquals((String)"Unexpected result", (String)"X", (String)this.resultToString(types));
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testResolveSiblingTypeInInner() throws JavaScriptModelException {
        String[][] types = this.resolveType("C", "TypeResolve$A$B");
        TypeResolveTests.assertEquals((String)"Unexpected result", (String)"p.TypeResolve.A.C", (String)this.resultToString(types));
    }

    public void testResolveTypeInInner() throws JavaScriptModelException {
        String[][] types = this.resolveType("X", "TypeResolve$A");
        TypeResolveTests.assertEquals((String)"Unexpected result", (String)"p1.X", (String)this.resultToString(types));
    }

    public void testResolveTypeInInner2() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/TypeResolve/src/p5/A.js").getType("A").getFunction("foo", new String[0]).getType("Local", 1);
        String[][] types = type.resolveType("Object");
        TypeResolveTests.assertEquals((String)"Unexpected result", (String)"java.lang.Object", (String)this.resultToString(types));
    }

    public void testResolveTypeInJavaLang() throws JavaScriptModelException {
        String[][] types = this.resolveType("String", "TypeResolve");
        TypeResolveTests.assertEquals((String)"Unexpected result", (String)"java.lang.String", (String)this.resultToString(types));
    }

    public void testResolveTypeWithNoImports() throws JavaScriptModelException {
        String[][] types = this.resolveType("Vector", "TypeResolve");
        TypeResolveTests.assertEquals((String)"Unexpected result", (String)"", (String)this.resultToString(types));
    }

    public void testResolveTypeWithOnDemandImport() throws JavaScriptModelException {
        String[][] types = this.resolveType("Y", "TypeResolve");
        TypeResolveTests.assertEquals((String)"Unexpected result", (String)"p2.Y", (String)this.resultToString(types));
    }

    public void testResolveTypeWithTypeImport() throws JavaScriptModelException {
        String[][] types = this.resolveType("X", "TypeResolve");
        TypeResolveTests.assertEquals((String)"Unexpected result", (String)"p1.X", (String)this.resultToString(types));
    }

    public void testResolveString() throws JavaScriptModelException {
        String[][] types = this.resolveType("String", "TypeResolve");
        TypeResolveTests.assertEquals((String)"Unexpected result", (String)"java.lang.String", (String)this.resultToString(types));
    }

    public void testResolveInnerType1() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/TypeResolve/src/p4/B.js").getType("B");
        String[][] types = type.resolveType("A.Inner");
        TypeResolveTests.assertEquals((String)"Unexpected result", (String)"p4.A.Inner", (String)this.resultToString(types));
    }

    public void testResolveInnerType2() throws JavaScriptModelException {
        IType type = this.getCompilationUnit("/TypeResolve/src/p4/B.js").getType("B");
        String[][] types = type.resolveType("p4.A.Inner");
        TypeResolveTests.assertEquals((String)"Unexpected result", (String)"p4.A.Inner", (String)this.resultToString(types));
    }
}

