/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.internal.core.hierarchy.RegionBasedTypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;

public class TypeHierarchySerializationTests
extends AbstractJavaModelTests {
    private static final String PROJECTNAME = "TypeHierarchySerialization";
    IJavaScriptProject project;

    public TypeHierarchySerializationTests(String name) {
        super(name);
    }

    public static Test suite() {
        return TypeHierarchySerializationTests.buildModelTestSuite(TypeHierarchySerializationTests.class);
    }

    private static void compare(String focus, ITypeHierarchy stored, ITypeHierarchy loaded) {
        if (stored instanceof RegionBasedTypeHierarchy) {
            TypeHierarchySerializationTests.assertTrue((String)("[" + focus + "] hierarchies are not the same"), (boolean)(loaded instanceof RegionBasedTypeHierarchy));
            TypeHierarchySerializationTests.compareRegionBasedTypeHierarchy(focus, (RegionBasedTypeHierarchy)stored, (RegionBasedTypeHierarchy)loaded);
        } else if (stored instanceof TypeHierarchy) {
            TypeHierarchySerializationTests.assertTrue((String)("[" + focus + "] hierarchies are not the same"), (boolean)(loaded instanceof TypeHierarchy));
            TypeHierarchySerializationTests.compareTypeHierarchy(focus, (TypeHierarchy)stored, (TypeHierarchy)loaded);
        }
    }

    private static void compareRegionBasedTypeHierarchy(String focus, RegionBasedTypeHierarchy stored, RegionBasedTypeHierarchy loaded) {
        TypeHierarchySerializationTests.compareTypeHierarchy(focus, (TypeHierarchy)stored, (TypeHierarchy)loaded);
    }

    private static void compareTypeHierarchy(String focus, TypeHierarchy stored, TypeHierarchy loaded) {
        IType type1 = stored.getType();
        IType type2 = loaded.getType();
        TypeHierarchySerializationTests.assertEquals((String)("[" + focus + "] focus are not the same"), (Object)type1, (Object)type2);
        Object[] allClasses1 = stored.getAllClasses();
        Object[] allClasses2 = loaded.getAllClasses();
        TypeHierarchySerializationTests.compare("[" + focus + "] all classes are not the same", allClasses1, allClasses2);
        Object[] rootClasses1 = stored.getRootClasses();
        Object[] rootClasses2 = loaded.getRootClasses();
        TypeHierarchySerializationTests.compare("[" + focus + "] all roots are not the same", rootClasses1, rootClasses2);
        Object[] missingTypes1 = stored.missingTypes.toArray();
        Object[] missingTypes2 = loaded.missingTypes.toArray();
        TypeHierarchySerializationTests.compare("[" + focus + "] all missing types are not the same", missingTypes1, missingTypes2);
        int i = 0;
        while (i < allClasses1.length) {
            Object aType = allClasses1[i];
            int cachedFlags1 = stored.getCachedFlags((IType)aType);
            int cachedFlags2 = loaded.getCachedFlags((IType)aType);
            TypeHierarchySerializationTests.assertEquals((String)("[" + focus + "] flags are not the same for " + aType.getFullyQualifiedName()), (int)cachedFlags1, (int)cachedFlags2);
            IType superclass1 = stored.getSuperclass((IType)aType);
            IType superclass2 = loaded.getSuperclass((IType)aType);
            TypeHierarchySerializationTests.assertEquals((String)("[" + focus + "] superclass are not the same for " + aType.getFullyQualifiedName()), (Object)superclass1, (Object)superclass2);
            Object[] subclasses1 = stored.getSubclasses((IType)aType);
            Object[] subclasses2 = loaded.getSubclasses((IType)aType);
            TypeHierarchySerializationTests.compare("[" + focus + "] all subclasses are not the same for " + aType.getFullyQualifiedName(), subclasses1, subclasses2);
            ++i;
        }
    }

    private static void compare(String msg, Object[] types1, Object[] types2) {
        if (types1 == null) {
            TypeHierarchySerializationTests.assertTrue((String)msg, (types2 == null ? 1 : 0) != 0);
        } else {
            TypeHierarchySerializationTests.assertTrue((String)msg, (types2 != null ? 1 : 0) != 0);
            TypeHierarchySerializationTests.assertTrue((String)msg, (types1.length == types2.length ? 1 : 0) != 0);
            int i = 0;
            while (i < types1.length) {
                boolean found = false;
                int j = 0;
                while (j < types2.length) {
                    if (types1[i] == null && types1[j] == null) {
                        found = true;
                    } else if (types1[i] != null && types1[i].equals(types2[j])) {
                        found = true;
                    }
                    ++j;
                }
                TypeHierarchySerializationTests.assertTrue((String)msg, (boolean)found);
                ++i;
            }
        }
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.project = this.setUpJavaProject(PROJECTNAME);
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.deleteProject(PROJECTNAME);
        super.tearDownSuite();
    }

    private static void testFocusHierarchy(IType type, IJavaScriptProject project) throws JavaScriptModelException {
        ITypeHierarchy h1 = type.newTypeHierarchy(project, null);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        h1.store((OutputStream)outputStream, null);
        byte[] bytes = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ITypeHierarchy h2 = type.loadTypeHierachy((InputStream)inputStream, null);
        TypeHierarchySerializationTests.compare(type.getElementName(), h1, h2);
        h2.refresh(null);
        TypeHierarchySerializationTests.compare(type.getElementName(), h1, h2);
    }

    public void test001() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(PROJECTNAME, "src", "p1", "X.js");
        IType type = cu.getType("X");
        TypeHierarchySerializationTests.testFocusHierarchy(type, this.project);
    }

    public void test002() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(PROJECTNAME, "src", "p1", "Y.js");
        IType type = cu.getType("Y");
        TypeHierarchySerializationTests.testFocusHierarchy(type, this.project);
    }

    public void test003() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(PROJECTNAME, "src", "p1", "Z.js");
        IType type = cu.getType("Z");
        TypeHierarchySerializationTests.testFocusHierarchy(type, this.project);
    }
}

