/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.core.JavaElement;

public class RootManipulationsTests
extends ModifyingResourceTests {
    public RootManipulationsTests(String name) {
        super(name);
    }

    protected void assertJavaProject(String expected, IJavaScriptProject project) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        this.populate(buffer, (IJavaScriptElement)project, 0);
        String actual = buffer.toString();
        if (!expected.equals(actual)) {
            System.out.println(Util.displayString((String)actual, (int)3));
        }
        RootManipulationsTests.assertEquals((String)expected, (String)actual);
    }

    protected void copy(IPackageFragmentRoot root, IPath destination) throws JavaScriptModelException {
        this.copy(root, destination, null);
    }

    protected void copy(IPackageFragmentRoot root, IPath destination, IIncludePathEntry sibling) throws JavaScriptModelException {
        root.copy(destination, 0, 8, sibling, null);
    }

    protected void delete(IPackageFragmentRoot root) throws JavaScriptModelException {
        root.delete(0, 6, null);
    }

    protected void move(IPackageFragmentRoot root, IPath destination) throws JavaScriptModelException {
        this.move(root, destination, null);
    }

    protected void move(IPackageFragmentRoot root, IPath destination, IIncludePathEntry sibling) throws JavaScriptModelException {
        root.move(destination, 0, 14, sibling, null);
    }

    protected void populate(StringBuffer buffer, IJavaScriptElement element, int indent) throws CoreException {
        if (!(element instanceof IParent) || !(element instanceof IOpenable)) {
            return;
        }
        if (buffer.length() != 0) {
            buffer.append("\n");
        }
        int i = 0;
        while (i < indent) {
            buffer.append("\t");
            ++i;
        }
        buffer.append(((JavaElement)element).toDebugString());
        IParent parent = (IParent)element;
        IJavaScriptElement[] children = null;
        try {
            children = parent.getChildren();
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        if (children != null) {
            int i2 = 0;
            int length = children.length;
            while (i2 < length) {
                this.populate(buffer, children[i2], indent + 1);
                ++i2;
            }
        }
        Object[] nonJavaResources = null;
        try {
            if (element instanceof IJavaScriptProject) {
                nonJavaResources = ((IJavaScriptProject)element).getNonJavaScriptResources();
            } else if (element instanceof IPackageFragmentRoot) {
                nonJavaResources = ((IPackageFragmentRoot)element).getNonJavaScriptResources();
            } else if (element instanceof IPackageFragment) {
                nonJavaResources = ((IPackageFragment)element).getNonJavaScriptResources();
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        if (nonJavaResources != null) {
            int i3 = 0;
            int length = nonJavaResources.length;
            while (i3 < length) {
                this.populate(buffer, nonJavaResources[i3], indent + 1);
                ++i3;
            }
        }
    }

    protected void populate(StringBuffer buffer, Object nonJavaResource, int indent) {
        if (buffer.length() != 0) {
            buffer.append("\n");
        }
        int i = 0;
        while (i < indent) {
            buffer.append("\t");
            ++i;
        }
        buffer.append(nonJavaResource);
    }

    public static Test suite() {
        return RootManipulationsTests.buildModelTestSuite(RootManipulationsTests.class);
    }

    public void testCopySourceFolder1() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{"src"});
            this.createJavaProject("P2", new String[0]);
            this.createFolder("/P1/src/p");
            this.createFile("/P1/src/p/X.js", "package p;\npublic class X {\n}");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/src");
            this.startDeltas();
            this.copy(root, (IPath)new Path("/P2/src"));
            this.assertDeltas("Unexpected delta", "P2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[+]: {}\n\tResourceDelta(/P2/.classpath)[*]");
            IJavaScriptUnit cu = this.getCompilationUnit("/P2/src/p/X.js");
            RootManipulationsTests.assertTrue((String)"Destination cu should exist", (boolean)cu.exists());
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testCopySourceFolder2() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{"src"});
            this.createJavaProject("P2", new String[0]);
            this.createFolder("/P1/src/p");
            this.createFile("/P1/src/p/X.js", "package p;\npublic class X {\n}");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/src");
            this.startDeltas();
            this.copy(root, (IPath)new Path("/P2/src2"));
            this.assertDeltas("Unexpected delta", "P2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc2[+]: {}\n\tResourceDelta(/P2/.classpath)[*]");
            IJavaScriptUnit cu = this.getCompilationUnit("/P2/src2/p/X.js");
            RootManipulationsTests.assertTrue((String)"Destination cu should exist", (boolean)cu.exists());
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testCopySourceFolder3() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[0]);
            p1.setRawIncludepath(this.createClasspath(new String[]{"/P1/src1", "src2/**", "/P1/src1/src2", ""}, false, true), null);
            this.createJavaProject("P2", new String[0]);
            this.createFolder("/P1/src1/p");
            this.createFile("/P1/src1/p/X.js", "package p;\npublic class X {\n}");
            this.createFolder("/P1/src1/src2/q");
            this.createFile("/P1/src1/src2/q/Y.js", "package q;\npublic class Y {\n}");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/src1");
            this.startDeltas();
            this.copy(root, (IPath)new Path("/P2/src1"));
            this.assertDeltas("Unexpected delta", "P2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc1[+]: {}\n\tResourceDelta(/P2/.classpath)[*]");
            IJavaScriptUnit cu = this.getCompilationUnit("/P2/src1/p/X.js");
            RootManipulationsTests.assertTrue((String)"Destination cu should exist", (boolean)cu.exists());
            cu = this.getCompilationUnit("/P2/src1/src2/q/Y.js");
            RootManipulationsTests.assertTrue((String)"Nested cu should not exist", (!cu.exists() ? 1 : 0) != 0);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testCopySourceFolder4() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{"src"});
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{"src1", "src2"});
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/src");
            IIncludePathEntry sibling = JavaScriptCore.newSourceEntry((IPath)new Path("/P2/src1"));
            this.startDeltas();
            this.copy(root, (IPath)new Path("/P2/src"), sibling);
            this.assertDeltas("Unexpected delta (1)", "P2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[+]: {}\n\tsrc1[*]: {REORDERED}\n\tsrc2[*]: {REORDERED}\n\tResourceDelta(/P2/.classpath)[*]");
            this.assertElementsEqual("Unexpected roots of P2 after insertion first", "src [in P2]\nsrc1 [in P2]\nsrc2 [in P2]", (IJavaScriptElement[])p2.getPackageFragmentRoots());
            sibling = JavaScriptCore.newSourceEntry((IPath)new Path("/P2/src2"));
            this.startDeltas();
            this.copy(root, (IPath)new Path("/P2/src3"), sibling);
            this.assertDeltas("Unexpected delta (2)", "P2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc2[*]: {REORDERED}\n\tsrc3[+]: {}\n\tResourceDelta(/P2/.classpath)[*]");
            this.assertElementsEqual("Unexpected roots of P2 after insertion in the middle", "src [in P2]\nsrc1 [in P2]\nsrc3 [in P2]\nsrc2 [in P2]", (IJavaScriptElement[])p2.getPackageFragmentRoots());
            this.startDeltas();
            this.copy(root, (IPath)new Path("/P2/src4"), null);
            this.assertDeltas("Unexpected delta (3)", "P2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc4[+]: {}\n\tResourceDelta(/P2/.classpath)[*]");
            this.assertElementsEqual("Unexpected roots of P2 after insertion last", "src [in P2]\nsrc1 [in P2]\nsrc3 [in P2]\nsrc2 [in P2]\nsrc4 [in P2]", (IJavaScriptElement[])p2.getPackageFragmentRoots());
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testCopySourceFolder5() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{"src"});
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{"src"});
            this.createFolder("/P1/src/p");
            this.createFile("/P1/src/p/X.js", "package p;\npublic class X {\n}");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/src");
            this.startDeltas();
            root.copy((IPath)new Path("/P2/src"), 0, 16, null, null);
            this.assertDeltas("Unexpected delta", "P2[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\tp[+]: {}");
            this.assertJavaProject("P2\n\tsrc\n\t\t<default>\n\t\tp\n\t\t\tX.java\n\tL/P2/.classpath\n\tL/P2/.project", p2);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testCopySourceFolder6() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            this.createFolder("/P/src/p");
            this.createFile("/P/src/p/X.js", "package p;\npublic class X {\n}");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
            this.startDeltas();
            root.copy((IPath)new Path("/P/src1"), 2, 24, null, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc1[+]: {}\n\tResourceDelta(/P/.classpath)[*]");
            this.assertJavaProject("P\n\tsrc\n\t\t<default>\n\t\tp\n\t\t\tX.java\n\tsrc1\n\t\t<default>\n\t\tp\n\t\t\tX.java\n\tL/P/.classpath\n\tL/P/.project", project);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testFailCopySourceFolder1() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{"src"});
            this.createJavaProject("P2", new String[]{"src"});
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/src");
            try {
                root.copy((IPath)new Path("/P2/src"), 0, 8, null, null);
            }
            catch (JavaScriptModelException e) {
                RootManipulationsTests.assertEquals((String)"/P2/src already exists in target", (String)e.getMessage());
                this.deleteProject("P1");
                this.deleteProject("P2");
                return;
            }
            RootManipulationsTests.assertTrue((String)"Should throw a JavaScriptModelException", (boolean)false);
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testFailCopySourceFolder2() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{"src"});
            this.createJavaProject("P2", new String[]{"src"});
            this.deleteFolder("/P2/src");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/src");
            try {
                root.copy((IPath)new Path("/P2/src"), 0, 8, null, null);
            }
            catch (JavaScriptModelException e) {
                RootManipulationsTests.assertEquals((String)"/P2/src already exists in target", (String)e.getMessage());
                this.deleteProject("P1");
                this.deleteProject("P2");
                return;
            }
            RootManipulationsTests.assertTrue((String)"Should throw a JavaScriptModelException", (boolean)false);
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testDeleteJarFile1() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"}, new String[]{"/P/myLib.jar"});
            this.createFile("/P/myLib.jar", "");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/myLib.jar");
            this.startDeltas();
            this.delete(root);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tmyLib.jar[-]: {}\n\tResourceDelta(/P/.classpath)[*]");
            this.assertJavaProject("P\n\tsrc\n\t\t<default>\n\tL/P/.classpath\n\tL/P/.project", project);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testDeleteJarFile3() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"}, new String[]{this.getSystemJsPathString()});
            IPackageFragmentRoot root = project.getPackageFragmentRoot(this.getSystemJsPathString());
            this.startDeltas();
            this.delete(root);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\t" + this.getSystemJsPathString() + "[*]: {REMOVED FROM CLASSPATH}\n" + "\tResourceDelta(/P/.classpath)[*]");
            this.assertJavaProject("P\n\tsrc\n\t\t<default>\n\tL/P/.classpath\n\tL/P/.project", project);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testDeleteJarFile2() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{"src"}, new String[]{"/P1/myLib.jar"});
            this.createFile("/P1/myLib.jar", "");
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{"src"}, new String[]{"/P1/myLib.jar"});
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/myLib.jar");
            this.startDeltas();
            this.delete(root);
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tmyLib.jar[-]: {}\n\tResourceDelta(/P1/.classpath)[*]\nP2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\t/P1/myLib.jar[-]: {}\n\tResourceDelta(/P2/.classpath)[*]");
            this.assertJavaProject("P1\n\tsrc\n\t\t<default>\n\tL/P1/.classpath\n\tL/P1/.project", p1);
            this.assertJavaProject("P2\n\tsrc\n\t\t<default>\n\tL/P2/.classpath\n\tL/P2/.project", p2);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testDeleteSourceFolder1() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            this.createFolder("/P/src/p");
            this.createFile("/P/src/p/X.js", "package p;\npublic class X {\n}");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src");
            this.startDeltas();
            this.delete(root);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[-]: {}\n\tResourceDelta(/P/.classpath)[*]");
            this.assertJavaProject("P\n\tL/P/.classpath\n\tL/P/.project", project);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testDeleteSourceFolder2() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[0]);
            project.setRawIncludepath(this.createClasspath(new String[]{"/P/src1", "src2/**", "/P/src1/src2", ""}, false, true), null);
            IFolder folder = this.createFolder("/P/src1/p");
            IFile file = this.createFile("/P/src1/p/X.js", "package p;\npublic class X {\n}");
            this.createFolder("/P/src1/src2/q");
            this.createFile("/P/src1/src2/q/Y.js", "package q;\npublic class Y {\n}");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src1");
            this.startDeltas();
            this.delete(root);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc1[*]: {REMOVED FROM CLASSPATH}\n\tsrc1/src2[*]: {REORDERED}\n\tResourceDelta(/P/.classpath)[*]\n\tResourceDelta(/P/src1)[*]");
            this.assertJavaProject("P\n\tsrc1/src2\n\t\t<default>\n\t\tq\n\t\t\tY.java\n\tL/P/.classpath\n\tL/P/.project\n\tF/P/src1", project);
            RootManipulationsTests.assertTrue((String)"Original package folder should not exist", (!folder.exists() ? 1 : 0) != 0);
            RootManipulationsTests.assertTrue((String)"Original cu file should not exist", (!file.exists() ? 1 : 0) != 0);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testMoveSourceFolder1() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{"src"});
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[0]);
            this.createFolder("/P1/src/p");
            this.createFile("/P1/src/p/X.js", "package p;\npublic class X {\n}");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/src");
            this.startDeltas();
            this.move(root, (IPath)new Path("/P2/src"));
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[-]: {MOVED_TO(src [in P2])}\n\tResourceDelta(/P1/.classpath)[*]\nP2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[+]: {MOVED_FROM(src [in P1])}\n\tResourceDelta(/P2/.classpath)[*]");
            this.assertJavaProject("P1\n\tL/P1/.classpath\n\tL/P1/.project", p1);
            this.assertJavaProject("P2\n\tsrc\n\t\t<default>\n\t\tp\n\t\t\tX.java\n\tL/P2/.classpath\n\tL/P2/.project", p2);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testMoveSourceFolder2() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{"src"});
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[0]);
            this.createFolder("/P1/src/p");
            this.createFile("/P1/src/p/X.js", "package p;\npublic class X {\n}");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/src");
            this.startDeltas();
            this.move(root, (IPath)new Path("/P2/src2"));
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[-]: {MOVED_TO(src2 [in P2])}\n\tResourceDelta(/P1/.classpath)[*]\nP2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc2[+]: {MOVED_FROM(src [in P1])}\n\tResourceDelta(/P2/.classpath)[*]");
            this.assertJavaProject("P1\n\tL/P1/.classpath\n\tL/P1/.project", p1);
            this.assertJavaProject("P2\n\tsrc2\n\t\t<default>\n\t\tp\n\t\t\tX.java\n\tL/P2/.classpath\n\tL/P2/.project", p2);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testMoveSourceFolder3() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[0]);
            p1.setRawIncludepath(this.createClasspath(new String[]{"/P1/src1", "src2/**", "/P1/src1/src2", ""}, false, true), null);
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[0]);
            this.createFolder("/P1/src1/p");
            this.createFile("/P1/src1/p/X.js", "package p;\npublic class X {\n}");
            this.createFolder("/P1/src1/src2/q");
            this.createFile("/P1/src1/src2/q/Y.js", "package q;\npublic class Y {\n}");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/src1");
            this.startDeltas();
            this.move(root, (IPath)new Path("/P2/src1"));
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc1[*]: {REMOVED FROM CLASSPATH}\n\tsrc1/src2[*]: {REORDERED}\n\tResourceDelta(/P1/.classpath)[*]\n\tResourceDelta(/P1/src1)[*]\nP2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc1[+]: {}\n\tResourceDelta(/P2/.classpath)[*]");
            this.assertJavaProject("P1\n\tsrc1/src2\n\t\t<default>\n\t\tq\n\t\t\tY.java\n\tL/P1/.classpath\n\tL/P1/.project\n\tF/P1/src1", p1);
            this.assertJavaProject("P2\n\tsrc1\n\t\t<default>\n\t\tp\n\t\t\tX.java\n\tL/P2/.classpath\n\tL/P2/.project", p2);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testMoveSourceFolder4() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{"src"});
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{"src1", "src2"});
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/src");
            IIncludePathEntry sibling = JavaScriptCore.newSourceEntry((IPath)new Path("/P2/src1"));
            this.startDeltas();
            this.move(root, (IPath)new Path("/P2/src"), sibling);
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[-]: {MOVED_TO(src [in P2])}\n\tResourceDelta(/P1/.classpath)[*]\nP2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[+]: {MOVED_FROM(src [in P1])}\n\tsrc1[*]: {REORDERED}\n\tsrc2[*]: {REORDERED}\n\tResourceDelta(/P2/.classpath)[*]");
            this.assertJavaProject("P1\n\tL/P1/.classpath\n\tL/P1/.project", p1);
            this.assertJavaProject("P2\n\tsrc\n\t\t<default>\n\tsrc1\n\t\t<default>\n\tsrc2\n\t\t<default>\n\tL/P2/.classpath\n\tL/P2/.project", p2);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testMoveSourceFolder5() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{"src"});
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{"src1", "src2"});
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/src");
            IIncludePathEntry sibling = JavaScriptCore.newSourceEntry((IPath)new Path("/P2/src2"));
            this.startDeltas();
            this.move(root, (IPath)new Path("/P2/src"), sibling);
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[-]: {MOVED_TO(src [in P2])}\n\tResourceDelta(/P1/.classpath)[*]\nP2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[+]: {MOVED_FROM(src [in P1])}\n\tsrc2[*]: {REORDERED}\n\tResourceDelta(/P2/.classpath)[*]");
            this.assertJavaProject("P1\n\tL/P1/.classpath\n\tL/P1/.project", p1);
            this.assertJavaProject("P2\n\tsrc1\n\t\t<default>\n\tsrc\n\t\t<default>\n\tsrc2\n\t\t<default>\n\tL/P2/.classpath\n\tL/P2/.project", p2);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testMoveSourceFolder6() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{"src"});
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{"src1", "src2"});
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/src");
            this.startDeltas();
            this.move(root, (IPath)new Path("/P2/src"), null);
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[-]: {MOVED_TO(src [in P2])}\n\tResourceDelta(/P1/.classpath)[*]\nP2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc[+]: {MOVED_FROM(src [in P1])}\n\tResourceDelta(/P2/.classpath)[*]");
            this.assertJavaProject("P1\n\tL/P1/.classpath\n\tL/P1/.project", p1);
            this.assertJavaProject("P2\n\tsrc1\n\t\t<default>\n\tsrc2\n\t\t<default>\n\tsrc\n\t\t<default>\n\tL/P2/.classpath\n\tL/P2/.project", p2);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testRenameSourceFolder1() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src1"});
            this.createFolder("/P/src1/p");
            this.createFile("/P/src1/p/X.js", "package p;\npublic class X {\n}");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src1");
            this.startDeltas();
            this.move(root, (IPath)new Path("/P/src2"));
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc1[-]: {MOVED_TO(src2 [in P])}\n\tsrc2[+]: {MOVED_FROM(src1 [in P])}\n\tResourceDelta(/P/.classpath)[*]");
            this.assertJavaProject("P\n\tsrc2\n\t\t<default>\n\t\tp\n\t\t\tX.java\n\tL/P/.classpath\n\tL/P/.project", project);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testRenameSourceFolder3() throws CoreException {
        try {
            this.createJavaProject("P");
            this.editFile("/P/.classpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry excluding=\"src1/\" kind=\"src\" path=\"\"/>\n\t<classpathentry kind=\"src\" path=\"src1\"/>\n</classpath>");
            this.createFolder("/P/src1");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src1");
            this.startDeltas();
            this.move(root, (IPath)new Path("/P/src2"));
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\t<project root>[*]: {ADDED TO CLASSPATH | REMOVED FROM CLASSPATH}\n\tsrc1[-]: {MOVED_TO(src2 [in P])}\n\tsrc2[+]: {MOVED_FROM(src1 [in P])}\n\tResourceDelta(/P/.classpath)[*]");
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testRenameSourceFolder4() throws CoreException {
        try {
            this.createJavaProject("P");
            this.editFile("/P/.classpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry excluding=\"src1/**\" kind=\"src\" path=\"\"/>\n\t<classpathentry kind=\"src\" path=\"src1\"/>\n</classpath>");
            this.createFolder("/P/src1");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src1");
            this.startDeltas();
            this.move(root, (IPath)new Path("/P/src2"));
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tsrc2[+]: {MOVED_FROM(<default> [in src1 [in P]])}\n\tsrc1[-]: {MOVED_TO(src2 [in <project root> [in P]])}");
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testRenameSourceFolder2() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src1", "src2", "src3"});
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/src1");
            this.startDeltas();
            this.move(root, (IPath)new Path("/P/src4"));
            this.assertDeltas("Unexpected delta after renaming src1", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc1[-]: {MOVED_TO(src4 [in P])}\n\tsrc4[+]: {MOVED_FROM(src1 [in P])}\n\tResourceDelta(/P/.classpath)[*]");
            this.assertJavaProject("P\n\tsrc4\n\t\t<default>\n\tsrc2\n\t\t<default>\n\tsrc3\n\t\t<default>\n\tL/P/.classpath\n\tL/P/.project", project);
            root = this.getPackageFragmentRoot("/P/src2");
            this.clearDeltas();
            this.move(root, (IPath)new Path("/P/src5"));
            this.assertDeltas("Unexpected delta after renaming src2", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc2[-]: {MOVED_TO(src5 [in P])}\n\tsrc5[+]: {MOVED_FROM(src2 [in P])}\n\tResourceDelta(/P/.classpath)[*]");
            this.assertJavaProject("P\n\tsrc4\n\t\t<default>\n\tsrc5\n\t\t<default>\n\tsrc3\n\t\t<default>\n\tL/P/.classpath\n\tL/P/.project", project);
            root = this.getPackageFragmentRoot("/P/src3");
            this.clearDeltas();
            this.move(root, (IPath)new Path("/P/src6"));
            this.assertDeltas("Unexpected delta after renaming src3", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tsrc3[-]: {MOVED_TO(src6 [in P])}\n\tsrc6[+]: {MOVED_FROM(src3 [in P])}\n\tResourceDelta(/P/.classpath)[*]");
            this.assertJavaProject("P\n\tsrc4\n\t\t<default>\n\tsrc5\n\t\t<default>\n\tsrc6\n\t\t<default>\n\tL/P/.classpath\n\tL/P/.project", project);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testRenameJarFile1() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"}, new String[]{"/P/myLib.jar"});
            this.createFile("/P/myLib.jar", "");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/myLib.jar");
            this.startDeltas();
            this.move(root, (IPath)new Path("/P/myLib2.jar"));
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tmyLib.jar[-]: {MOVED_TO(myLib2.jar [in P])}\n\tmyLib2.jar[+]: {MOVED_FROM(myLib.jar [in P])}\n\tResourceDelta(/P/.classpath)[*]");
            this.assertJavaProject("P\n\tsrc\n\t\t<default>\n\tmyLib2.jar\n\tL/P/.classpath\n\tL/P/.project", project);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }

    public void testRenameJarFile2() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[]{"src"}, new String[]{"/P1/myLib.jar"});
            this.createFile("/P1/myLib.jar", "");
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{"src"}, new String[]{"/P1/myLib.jar"});
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P1/myLib.jar");
            this.startDeltas();
            this.move(root, (IPath)new Path("/P1/myLib2.jar"));
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tmyLib.jar[-]: {MOVED_TO(myLib2.jar [in P1])}\n\tmyLib2.jar[+]: {MOVED_FROM(myLib.jar [in P1])}\n\tResourceDelta(/P1/.classpath)[*]\nP2[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\t/P1/myLib.jar[-]: {MOVED_TO(myLib2.jar [in P1])}\n\t/P1/myLib2.jar[+]: {MOVED_FROM(myLib.jar [in P1])}\n\tResourceDelta(/P2/.classpath)[*]");
            this.assertJavaProject("P1\n\tsrc\n\t\t<default>\n\tmyLib2.jar\n\tL/P1/.classpath\n\tL/P1/.project", p1);
            this.assertJavaProject("P2\n\tsrc\n\t\t<default>\n\t/P1/myLib2.jar\n\tL/P2/.classpath\n\tL/P2/.project", p2);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testRenameJarFile3() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"}, new String[]{"/P/myLib1.jar", "/P/myLib2.jar"});
            this.createFile("/P/myLib1.jar", "");
            this.createFile("/P/myLib2.jar", "");
            IPackageFragmentRoot root = this.getPackageFragmentRoot("/P/myLib1.jar");
            this.startDeltas();
            root.move((IPath)new Path("/P/myLib2.jar"), 0, 26, null, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN | CONTENT | CLASSPATH CHANGED}\n\tmyLib1.jar[-]: {MOVED_TO(myLib2.jar [in P])}\n\tmyLib2.jar[*]: {CONTENT | REORDERED | ARCHIVE CONTENT CHANGED}\n\tResourceDelta(/P/.classpath)[*]");
            this.assertJavaProject("P\n\tsrc\n\t\t<default>\n\tmyLib2.jar\n\tL/P/.classpath\n\tL/P/.project", project);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P");
        }
    }
}

