/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.junit.Assert;
import org.junit.Test;

public class StringLiteralTest {
    @Test
    public void testBasic1() {
        this.testFromEscape("", "\"\"");
    }

    @Test
    public void testBasic2() {
        this.testFromEscape("", "''");
    }

    @Test
    public void testBasic3() {
        this.testFromEscape("a", "'a'");
    }

    @Test
    public void testBasic4() {
        this.testFromEscape("\"", "\"\\\"\"");
    }

    @Test
    public void testBasic5() {
        this.testFromEscape("'", "'\\''");
    }

    @Test
    public void testBasic6() {
        this.testFromEscape("a", "\"a\"");
    }

    @Test
    public void testBasic7() {
        this.testFromEscape("\"", "'\"'");
    }

    @Test
    public void testHexEscape1() {
        this.testFromEscape("X", "\"\\x58\"");
    }

    @Test
    public void testHexEscape2() {
        this.testFromEscape("XY", "\"\\x58Y\"");
    }

    @Test
    public void testHexEscape3() {
        this.testFromEscape("YX", "\"Y\\x58\"");
    }

    public void testHexEscape4() {
        this.testFromEscape("X9", "\"\\x589\"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHexEscape5() {
        this.testFromEscape("X", "\"\\x5\"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHexEscape6() {
        this.testFromEscape("X", "\"\\x\"");
    }

    @Test
    public void testUnicodeNew1() {
        this.testFromEscape("X", "\"\\u{58}\"");
    }

    @Test
    public void testUnicodeNew2() {
        this.testFromEscape("X", "\"\\u{058}\"");
    }

    @Test
    public void testUnicodeNew3() {
        this.testFromEscape("X", "\"\\u{0058}\"");
    }

    @Test
    public void testUnicodeNew4() {
        this.testFromEscape("XX", "\"\\u{0058}X\"");
    }

    @Test
    public void testUnicodeNew5() {
        this.testFromEscape("XX", "\"X\\u{0058}\"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnicodeNew6() {
        this.testFromEscape("X", "\"\\u{0058\"");
    }

    @Test
    public void testUnicode1() {
        this.testFromEscape("X", "\"\\u0058\"");
    }

    @Test
    public void testUnicode2() {
        this.testFromEscape("XX", "\"\\u0058X\"");
    }

    @Test
    public void testUnicode3() {
        this.testFromEscape("XX", "\"X\\u0058\"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnicode4() {
        this.testFromEscape("X", "\"\\u058\"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnicode5() {
        this.testFromEscape("X", "\"\\u58\"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnicode6() {
        this.testFromEscape("X", "\"\\u8\"");
    }

    @Test
    public void testOctal1() {
        this.testFromEscape("X", "\"\\130\"");
    }

    @Test
    public void testOctal2() {
        this.testFromEscape("YX", "\"Y\\130\"");
    }

    @Test
    public void testOctal3() {
        this.testFromEscape("XY", "\"\\130Y\"");
    }

    @Test
    public void testOctal4() {
        this.testFromEscape("\u00ff", "\"\\377\"");
    }

    @Test
    public void testOctal5() {
        this.testFromEscape("\u001f8", "\"\\378\"");
    }

    @Test
    public void testOctal6() {
        this.testFromEscape(" 1", "\"\\401\"");
    }

    @Test
    public void testOctal7() {
        this.testFromEscape("1 1", "\"1\\401\"");
    }

    @Test
    public void testOctal8() {
        this.testFromEscape("W", "\"\\W\"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOctal9() {
        this.testFromEscape("\\", "\"\\\"");
    }

    @Test
    public void testFromLiteral1() {
        this.testFromLiteral("\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\n\r\t\u000b\f\u2028\u2029", "\"\\0\\1\\2\\3\\4\\5\\6\\7\\b\\n\\r\\t\\v\\f\\u2028\\u2029\"");
    }

    @Test
    public void testAllInOneFromEscape() {
        this.testFromEscape("\u0000\b\n\r\t\u000b\f\\\"'\u2028\u2029\u65e5\u672c", "\"\\0\\b\\n\\r\\t\\v\\f\\\\\\\"'\\u2028\\u2029\u65e5\u672c\"");
    }

    private void testFromEscape(String literalValue, String escapedValue) {
        StringLiteral sl = AST.newAST((int)3).newStringLiteral();
        sl.setEscapedValue(escapedValue);
        Assert.assertEquals((Object)literalValue, (Object)sl.getLiteralValue());
    }

    private void testFromLiteral(String literalValue, String escapedValue) {
        StringLiteral sl = AST.newAST((int)3).newStringLiteral();
        sl.setLiteralValue(literalValue);
        Assert.assertEquals((Object)escapedValue, (Object)sl.getEscapedValue());
    }
}

