/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.ActionListenerType;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultLocaleType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultRenderKitIdType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.LocaleConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.MessageBundleType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationHandlerType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyResolverType;
import org.eclipse.jst.jsf.facesconfig.emf.StateManagerType;
import org.eclipse.jst.jsf.facesconfig.emf.SupportedLocaleType;
import org.eclipse.jst.jsf.facesconfig.emf.VariableResolverType;
import org.eclipse.jst.jsf.facesconfig.emf.ViewHandlerType;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.BaseWriteTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteApplicationTestCase
extends BaseWriteTestCase {
    private static final String SUPPORTED_LOCALE_TYPE = "supported-locale-type";
    private static final String DEFAULT_LOCALE = "default-locale";
    private static final String actionListener = "action-listener";
    private static final String variableResolver = "variable-resolver";
    private static final String defaultRenderKitId = "default-render-kit-id";
    private static final String messageBundle = "message-bundle";
    private static final String navigationHandler = "navigation-handler";
    private static final String viewHandler = "view-handler";
    private static final String stateManager = "state-manager";
    private static final String propertyResolver = "property-resolver";
    private static final String APPLICATION_ID = "application-id";

    public WriteApplicationTestCase(String name) {
        super(name);
    }

    public void testWriteApplication() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteApplicationTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            ApplicationType newApplication = facesConfigFactory.createApplicationType();
            newApplication.setId(APPLICATION_ID);
            ActionListenerType actionList = facesConfigFactory.createActionListenerType();
            actionList.setTextContent(actionListener);
            newApplication.getActionListener().add((Object)actionList);
            VariableResolverType variableResolverType = facesConfigFactory.createVariableResolverType();
            variableResolverType.setTextContent(variableResolver);
            newApplication.getVariableResolver().add((Object)variableResolverType);
            DefaultRenderKitIdType renderKitIdType = facesConfigFactory.createDefaultRenderKitIdType();
            renderKitIdType.setTextContent(defaultRenderKitId);
            newApplication.getDefaultRenderKitId().add((Object)renderKitIdType);
            MessageBundleType messageBundleType = facesConfigFactory.createMessageBundleType();
            messageBundleType.setTextContent(messageBundle);
            newApplication.getMessageBundle().add((Object)messageBundleType);
            NavigationHandlerType navigationHandlerType = facesConfigFactory.createNavigationHandlerType();
            navigationHandlerType.setTextContent(navigationHandler);
            newApplication.getNavigationHandler().add((Object)navigationHandlerType);
            ViewHandlerType viewHandlerType = facesConfigFactory.createViewHandlerType();
            viewHandlerType.setTextContent(viewHandler);
            newApplication.getViewHandler().add((Object)viewHandlerType);
            StateManagerType stateManagerType = facesConfigFactory.createStateManagerType();
            stateManagerType.setTextContent(stateManager);
            newApplication.getStateManager().add((Object)stateManagerType);
            PropertyResolverType propertyResolverType = facesConfigFactory.createPropertyResolverType();
            propertyResolverType.setTextContent(propertyResolver);
            newApplication.getPropertyResolver().add((Object)propertyResolverType);
            LocaleConfigType localConfigType = facesConfigFactory.createLocaleConfigType();
            DefaultLocaleType defaultLocaleType = facesConfigFactory.createDefaultLocaleType();
            defaultLocaleType.setTextContent(DEFAULT_LOCALE);
            localConfigType.setDefaultLocale(defaultLocaleType);
            SupportedLocaleType supportedLocalType = facesConfigFactory.createSupportedLocaleType();
            supportedLocalType.setTextContent(SUPPORTED_LOCALE_TYPE);
            localConfigType.getSupportedLocale().add((Object)supportedLocalType);
            newApplication.getLocaleConfig().add((Object)localConfigType);
            edit.getFacesConfig().getApplication().add((Object)newApplication);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteApplicationTestCase.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteApplicationTestCase.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application = (ApplicationType)FacesConfigModelUtil.findEObjectElementById((List)edit.getFacesConfig().getApplication(), APPLICATION_ID);
            WriteApplicationTestCase.assertEquals((int)1, (int)application.getActionListener().size());
            WriteApplicationTestCase.assertEquals((String)actionListener, (String)((ActionListenerType)application.getActionListener().get(0)).getTextContent());
            WriteApplicationTestCase.assertEquals((int)1, (int)application.getVariableResolver().size());
            WriteApplicationTestCase.assertEquals((String)variableResolver, (String)((VariableResolverType)application.getVariableResolver().get(0)).getTextContent());
            WriteApplicationTestCase.assertEquals((int)1, (int)application.getDefaultRenderKitId().size());
            WriteApplicationTestCase.assertEquals((String)defaultRenderKitId, (String)((DefaultRenderKitIdType)application.getDefaultRenderKitId().get(0)).getTextContent());
            WriteApplicationTestCase.assertEquals((int)1, (int)application.getMessageBundle().size());
            WriteApplicationTestCase.assertEquals((String)messageBundle, (String)((MessageBundleType)application.getMessageBundle().get(0)).getTextContent());
            WriteApplicationTestCase.assertEquals((int)1, (int)application.getNavigationHandler().size());
            WriteApplicationTestCase.assertEquals((String)navigationHandler, (String)((NavigationHandlerType)application.getNavigationHandler().get(0)).getTextContent());
            WriteApplicationTestCase.assertEquals((int)1, (int)application.getViewHandler().size());
            WriteApplicationTestCase.assertEquals((String)viewHandler, (String)((ViewHandlerType)application.getViewHandler().get(0)).getTextContent());
            WriteApplicationTestCase.assertEquals((int)1, (int)application.getStateManager().size());
            WriteApplicationTestCase.assertEquals((String)stateManager, (String)((StateManagerType)application.getStateManager().get(0)).getTextContent());
            WriteApplicationTestCase.assertEquals((int)1, (int)application.getPropertyResolver().size());
            WriteApplicationTestCase.assertEquals((String)propertyResolver, (String)((PropertyResolverType)application.getPropertyResolver().get(0)).getTextContent());
            WriteApplicationTestCase.assertEquals((int)1, (int)application.getLocaleConfig().size());
            LocaleConfigType localConfigType = (LocaleConfigType)application.getLocaleConfig().get(0);
            WriteApplicationTestCase.assertEquals((String)DEFAULT_LOCALE, (String)localConfigType.getDefaultLocale().getTextContent());
            WriteApplicationTestCase.assertEquals((int)1, (int)localConfigType.getSupportedLocale().size());
            WriteApplicationTestCase.assertEquals((String)SUPPORTED_LOCALE_TYPE, (String)((SupportedLocaleType)localConfigType.getSupportedLocale().get(0)).getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

