/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationFactoryType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesContextFactoryType;
import org.eclipse.jst.jsf.facesconfig.emf.FactoryType;
import org.eclipse.jst.jsf.facesconfig.emf.LifecycleFactoryType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitFactoryType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadFactoryTestCase
extends BaseReadTestCase {
    public ReadFactoryTestCase(String name) {
        super(name);
    }

    public void testEmptyFactory() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFactoryTestCase.assertNotNull((Object)edit.getFacesConfig());
            ReadFactoryTestCase.assertEquals((int)1, (int)edit.getFacesConfig().getFactory().size());
            ReadFactoryTestCase.assertNotNull((Object)this.getFactoryType1(edit.getFacesConfig()));
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    FactoryType getFactoryType1(FacesConfigType facesConfig) {
        return (FactoryType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getFactory(), "factory1");
    }

    public void testApplicationFactory() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFactoryTestCase.assertNotNull((Object)edit.getFacesConfig());
            FactoryType factoryType1 = this.getFactoryType1(edit.getFacesConfig());
            ReadFactoryTestCase.assertNotNull((Object)factoryType1);
            ApplicationFactoryType applicationFactoryType1 = (ApplicationFactoryType)FacesConfigModelUtil.findEObjectElementById((List)factoryType1.getApplicationFactory(), "applicationFactory1");
            ReadFactoryTestCase.assertNotNull((Object)applicationFactoryType1);
            ReadFactoryTestCase.assertEquals((String)"application-factory", (String)applicationFactoryType1.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testFacesContextFactory() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFactoryTestCase.assertNotNull((Object)edit.getFacesConfig());
            FactoryType factoryType1 = this.getFactoryType1(edit.getFacesConfig());
            ReadFactoryTestCase.assertNotNull((Object)factoryType1);
            FacesContextFactoryType facesContextFactoryType1 = (FacesContextFactoryType)FacesConfigModelUtil.findEObjectElementById((List)factoryType1.getFacesContextFactory(), "facesContextFactory1");
            ReadFactoryTestCase.assertNotNull((Object)facesContextFactoryType1);
            ReadFactoryTestCase.assertEquals((String)"faces-context-factory", (String)facesContextFactoryType1.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testLifeCycleFactory() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFactoryTestCase.assertNotNull((Object)edit.getFacesConfig());
            FactoryType factoryType1 = this.getFactoryType1(edit.getFacesConfig());
            ReadFactoryTestCase.assertNotNull((Object)factoryType1);
            LifecycleFactoryType lifecycleFactoryType1 = (LifecycleFactoryType)FacesConfigModelUtil.findEObjectElementById((List)factoryType1.getLifecycleFactory(), "lifecycleFactory1");
            ReadFactoryTestCase.assertNotNull((Object)lifecycleFactoryType1);
            ReadFactoryTestCase.assertEquals((String)"lifecycle-factory", (String)lifecycleFactoryType1.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testRenderkitFactory() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadFactoryTestCase.assertNotNull((Object)edit.getFacesConfig());
            FactoryType factoryType1 = this.getFactoryType1(edit.getFacesConfig());
            ReadFactoryTestCase.assertNotNull((Object)factoryType1);
            RenderKitFactoryType renderKitFactoryType1 = (RenderKitFactoryType)FacesConfigModelUtil.findEObjectElementById((List)factoryType1.getRenderKitFactory(), "renderKitFactory1");
            ReadFactoryTestCase.assertNotNull((Object)renderKitFactoryType1);
            ReadFactoryTestCase.assertEquals((String)"render-kit-factory", (String)renderKitFactoryType1.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

