/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.queue;

import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.queue.LinkedQueue;
import org.eclipse.jpt.common.utility.internal.queue.QueueTools;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.queue.QueueTests;

public class LinkedQueueTests
extends QueueTests {
    public LinkedQueueTests(String name) {
        super(name);
    }

    @Override
    Queue<String> buildQueue() {
        return QueueTools.linkedQueue();
    }

    public void testConstructorInt_IAE() {
        boolean exCaught = false;
        try {
            LinkedQueue queue = QueueTools.linkedQueue((int)-3);
            LinkedQueueTests.fail((String)("bogus queue: " + queue));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        LinkedQueueTests.assertTrue((boolean)exCaught);
    }

    public void testSize() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        String third = "third";
        LinkedQueueTests.assertEquals((int)0, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        LinkedQueueTests.assertEquals((int)2, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
        queue.enqueue((Object)third);
        LinkedQueueTests.assertEquals((int)3, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
        queue.dequeue();
        LinkedQueueTests.assertEquals((int)2, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
        queue.dequeue();
        queue.dequeue();
        LinkedQueueTests.assertEquals((int)0, (int)((Integer)ObjectTools.execute(queue, (String)"size")));
    }

    public void testBuildElements() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        String third = "third";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        queue.enqueue((Object)third);
        Object[] elements = new Object[]{first, second, third};
        LinkedQueueTests.assertTrue((boolean)Arrays.equals(elements, (Object[])ObjectTools.execute(queue, (String)"buildElements")));
    }

    public void testNodeCache_max() {
        LinkedQueue queue = new LinkedQueue(2);
        String first = "first";
        String second = "second";
        String third = "third";
        String fourth = "fourth";
        String fifth = "fifth";
        Object factory = ObjectTools.get((Object)queue, (String)"nodeFactory");
        this.verifyNodeCache(0, factory);
        queue.enqueue((Object)first);
        this.verifyNodeCache(0, factory);
        queue.enqueue((Object)second);
        queue.enqueue((Object)third);
        queue.enqueue((Object)fourth);
        queue.enqueue((Object)fifth);
        this.verifyNodeCache(0, factory);
        LinkedQueueTests.assertNull((Object)ObjectTools.get((Object)factory, (String)"cacheHead"));
        queue.dequeue();
        this.verifyNodeCache(1, factory);
        queue.dequeue();
        this.verifyNodeCache(2, factory);
        queue.dequeue();
        this.verifyNodeCache(2, factory);
        queue.dequeue();
        this.verifyNodeCache(2, factory);
        queue.dequeue();
        this.verifyNodeCache(2, factory);
        queue.enqueue((Object)first);
        this.verifyNodeCache(1, factory);
        queue.enqueue((Object)second);
        this.verifyNodeCache(0, factory);
        queue.enqueue((Object)third);
        this.verifyNodeCache(0, factory);
    }

    public void testNodeCache_unlimited() {
        LinkedQueue queue = new LinkedQueue(-1);
        String first = "first";
        String second = "second";
        String third = "third";
        String fourth = "fourth";
        String fifth = "fifth";
        Object factory = ObjectTools.get((Object)queue, (String)"nodeFactory");
        this.verifyNodeCache(0, factory);
        queue.enqueue((Object)first);
        this.verifyNodeCache(0, factory);
        queue.enqueue((Object)second);
        queue.enqueue((Object)third);
        queue.enqueue((Object)fourth);
        queue.enqueue((Object)fifth);
        this.verifyNodeCache(0, factory);
        LinkedQueueTests.assertNull((Object)ObjectTools.get((Object)factory, (String)"cacheHead"));
        queue.dequeue();
        this.verifyNodeCache(1, factory);
        queue.dequeue();
        this.verifyNodeCache(2, factory);
        queue.dequeue();
        this.verifyNodeCache(3, factory);
        queue.dequeue();
        this.verifyNodeCache(4, factory);
        queue.dequeue();
        this.verifyNodeCache(5, factory);
        queue.enqueue((Object)first);
        this.verifyNodeCache(4, factory);
        queue.enqueue((Object)second);
        this.verifyNodeCache(3, factory);
        queue.enqueue((Object)third);
        this.verifyNodeCache(2, factory);
        queue.enqueue((Object)fourth);
        this.verifyNodeCache(1, factory);
        queue.enqueue((Object)fifth);
        this.verifyNodeCache(0, factory);
    }

    public void verifyNodeCache(int size, Object factory) {
        LinkedQueueTests.assertEquals((int)size, (int)((Integer)ObjectTools.get((Object)factory, (String)"cacheSize")));
        int nodeCount = 0;
        Object node = ObjectTools.get((Object)factory, (String)"cacheHead");
        while (node != null) {
            ++nodeCount;
            node = ObjectTools.get((Object)node, (String)"next");
        }
        LinkedQueueTests.assertEquals((int)size, (int)nodeCount);
    }

    public void testNodeToString() {
        LinkedQueue queue = QueueTools.linkedQueue();
        String first = "first";
        String second = "second";
        String third = "third";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        queue.enqueue((Object)third);
        Object head = ObjectTools.get((Object)queue, (String)"head");
        LinkedQueueTests.assertTrue((boolean)head.toString().startsWith("LinkedQueue.Node"));
        LinkedQueueTests.assertTrue((boolean)head.toString().endsWith("(first)"));
    }

    public void testSimpleNodeFactoryToString() {
        LinkedQueue queue = QueueTools.linkedQueue();
        Object factory = ObjectTools.get((Object)queue, (String)"nodeFactory");
        LinkedQueueTests.assertEquals((String)"LinkedQueue.SimpleNodeFactory", (String)factory.toString());
    }

    public void testCachingNodeFactoryToString() {
        LinkedQueue queue = QueueTools.linkedQueue((int)20);
        Object factory = ObjectTools.get((Object)queue, (String)"nodeFactory");
        LinkedQueueTests.assertTrue((boolean)factory.toString().startsWith("LinkedQueue.CachingNodeFactory"));
        LinkedQueueTests.assertTrue((boolean)factory.toString().endsWith("(0)"));
    }

    public void testClone_caching() throws Exception {
        LinkedQueue original = QueueTools.linkedQueue((int)20);
        original.enqueue((Object)"first");
        LinkedQueue clone = original.clone();
        LinkedQueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        LinkedQueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        LinkedQueueTests.assertNotSame((Object)original, (Object)clone);
        LinkedQueueTests.assertTrue((boolean)original.isEmpty());
        LinkedQueueTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueue((Object)"second");
        LinkedQueueTests.assertFalse((boolean)original.isEmpty());
        LinkedQueueTests.assertTrue((boolean)clone.isEmpty());
        Object factory = ObjectTools.get((Object)original, (String)"nodeFactory");
        LinkedQueueTests.assertTrue((boolean)factory.toString().startsWith("LinkedQueue.CachingNodeFactory"));
    }

    public void testSerialization_caching() throws Exception {
        LinkedQueue original = QueueTools.linkedQueue((int)20);
        original.enqueue((Object)"first");
        Queue clone = (Queue)TestTools.serialize(original);
        LinkedQueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        LinkedQueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        LinkedQueueTests.assertNotSame((Object)original, (Object)clone);
        LinkedQueueTests.assertTrue((boolean)original.isEmpty());
        LinkedQueueTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueue((Object)"second");
        LinkedQueueTests.assertFalse((boolean)original.isEmpty());
        LinkedQueueTests.assertTrue((boolean)clone.isEmpty());
        Object factory = ObjectTools.get((Object)original, (String)"nodeFactory");
        LinkedQueueTests.assertTrue((boolean)factory.toString().startsWith("LinkedQueue.CachingNodeFactory"));
    }
}

