/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.factory;

import java.util.ArrayList;
import java.util.RandomAccess;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.factory.Factory;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.exception.CollectingExceptionHandler;
import org.eclipse.jpt.common.utility.internal.factory.FactoryTools;
import org.eclipse.jpt.common.utility.internal.factory.FactoryWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

public class FactoryTests
extends TestCase {
    public FactoryTests(String name) {
        super(name);
    }

    public void testIteratorFactory() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("zero");
        list.add("one");
        list.add("two");
        list.add("three");
        Factory factory = FactoryTools.adapt(list);
        int i = 0;
        while (i < list.size()) {
            FactoryTests.assertEquals((String)((String)factory.create()), (String)((String)list.get(i)));
            ++i;
        }
        FactoryTests.assertNotNull((Object)factory.toString());
    }

    public void testFactoryWrapper() {
        Factory factory1 = FactoryTools.staticFactory((Object)"foo");
        Factory factory2 = FactoryTools.staticFactory((Object)"bar");
        FactoryWrapper wrapper = FactoryTools.wrap((Factory)factory1);
        FactoryTests.assertEquals((String)((String)wrapper.create()), (String)"foo");
        wrapper.setFactory(factory2);
        FactoryTests.assertEquals((String)((String)wrapper.create()), (String)"bar");
        wrapper.setFactory(factory1);
        FactoryTests.assertEquals((String)((String)wrapper.create()), (String)"foo");
        FactoryTests.assertNotNull((Object)wrapper.toString());
    }

    public void testCastingFactory() {
        ArrayList list = new ArrayList();
        Factory factory1 = FactoryTools.staticFactory(list);
        Factory factory2 = FactoryTools.cast((Factory)factory1);
        RandomAccess ra = (RandomAccess)factory2.create();
        FactoryTests.assertEquals(list, (Object)ra);
        FactoryTests.assertNotNull((Object)factory2.toString());
    }

    public void testDowncastingFactory() {
        ArrayList list = new ArrayList();
        Factory factory1 = FactoryTools.staticFactory(list);
        Factory factory2 = FactoryTools.downcast((Factory)factory1);
        ArrayList actual = (ArrayList)factory2.create();
        FactoryTests.assertEquals(list, (Object)actual);
        FactoryTests.assertNotNull((Object)factory2.toString());
    }

    public void testUpcastingFactory() {
        ArrayList list = new ArrayList();
        Factory factory1 = FactoryTools.staticFactory(list);
        Factory factory2 = FactoryTools.upcast((Factory)factory1);
        Object actual = factory2.create();
        FactoryTests.assertEquals(list, (Object)actual);
        FactoryTests.assertNotNull((Object)factory2.toString());
    }

    public void testSafeFactory() {
        CollectingExceptionHandler exHandler = new CollectingExceptionHandler();
        Factory factory1 = FactoryTools.disabledFactory();
        String foo = "foo";
        Factory factory2 = FactoryTools.safe((Factory)factory1, (ExceptionHandler)exHandler, (Object)foo);
        String actual = (String)factory2.create();
        FactoryTests.assertEquals((String)foo, (String)actual);
        FactoryTests.assertEquals((int)1, (int)IterableTools.size((Iterable)exHandler.getExceptions()));
        FactoryTests.assertTrue((boolean)(IterableTools.first((Iterable)exHandler.getExceptions()) instanceof UnsupportedOperationException));
        FactoryTests.assertNotNull((Object)factory2.toString());
    }

    public void testCloneFactory() {
        StringRef ref = new StringRef("foo");
        Factory factory = FactoryTools.cloneFactory((Cloneable)ref);
        StringRef clone = (StringRef)factory.create();
        FactoryTests.assertEquals((Object)ref, (Object)clone);
        FactoryTests.assertNotSame((Object)ref, (Object)clone);
        FactoryTests.assertNotNull((Object)factory.toString());
    }

    public void testInstantiationFactory() {
        StringRef ref1 = new StringRef();
        Factory factory = FactoryTools.instantiationFactory(StringRef.class);
        StringRef ref2 = (StringRef)factory.create();
        FactoryTests.assertEquals((Object)ref1, (Object)ref2);
        FactoryTests.assertNotSame((Object)ref1, (Object)ref2);
        FactoryTests.assertNotNull((Object)factory.toString());
    }

    public void testInstantiationFactory_Args() {
        StringRef ref1 = new StringRef("foo");
        Factory factory = FactoryTools.instantiationFactory(StringRef.class, String.class, (Object)"foo");
        StringRef ref2 = (StringRef)factory.create();
        FactoryTests.assertEquals((Object)ref1, (Object)ref2);
        FactoryTests.assertNotSame((Object)ref1, (Object)ref2);
        FactoryTests.assertNotNull((Object)factory.toString());
    }

    public void testStaticFieldFactory() {
        Factory factory = FactoryTools.get(StringRef.class, (String)"DEFAULT");
        String s = (String)factory.create();
        FactoryTests.assertEquals((String)"", (String)s);
        FactoryTests.assertNotNull((Object)factory.toString());
    }

    public void testStaticMethodFactory() {
        Factory factory = FactoryTools.execute(StringRef.class, (String)"defaultString");
        String s = (String)factory.create();
        FactoryTests.assertEquals((String)"", (String)s);
        FactoryTests.assertNotNull((Object)factory.toString());
    }

    public void testDisabledFactory() {
        Factory factory = FactoryTools.disabledFactory();
        boolean exCaught = false;
        try {
            String s = (String)factory.create();
            FactoryTests.fail((String)("bogus value: " + s));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        FactoryTests.assertTrue((boolean)exCaught);
        FactoryTests.assertNotNull((Object)factory.toString());
    }

    public void testNullFactory() {
        Factory factory = FactoryTools.nullFactory();
        String s = (String)factory.create();
        FactoryTests.assertNull((Object)s);
        FactoryTests.assertNotNull((Object)factory.toString());
    }

    public void testStaticFactory() {
        Factory factory = FactoryTools.staticFactory((Object)"foo");
        String s = (String)factory.create();
        FactoryTests.assertEquals((String)"foo", (String)s);
        s = (String)factory.create();
        FactoryTests.assertEquals((String)"foo", (String)s);
        FactoryTests.assertNotNull((Object)factory.toString());
    }

    public static class StringRef
    implements Cloneable {
        private final String string;
        private static final String DEFAULT = "";

        public static String defaultString() {
            return DEFAULT;
        }

        public StringRef() {
            this(DEFAULT);
        }

        public StringRef(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.string = string;
        }

        public String getString() {
            return this.string;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StringRef)) {
                return false;
            }
            return this.string.equals(((StringRef)obj).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)this.string);
        }
    }
}

