/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.document;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.Position;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.tests.util.FileUtil;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;

public class TestStructuredDocument
extends TestCase {
    private boolean isSetup = false;
    private final String fProjectName = "DOCUMENT-LOADER";
    private final String fZipFileName = "xml-document-loader-tests.zip";

    public TestStructuredDocument() {
        super("TestStructuredDocument");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isSetup) {
            this.doSetup();
            this.isSetup = true;
        }
    }

    private void doSetup() throws Exception {
        Location platformLocation = Platform.getInstanceLocation();
        ProjectUnzipUtility unzipUtil = new ProjectUnzipUtility();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", "xml-document-loader-tests.zip", "projecttestfiles");
        unzipUtil.unzipAndImport(zipFile, platformLocation.getURL().getFile());
        unzipUtil.initJavaProject("DOCUMENT-LOADER");
    }

    IStructuredModel getTestModel() throws IOException, CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("DOCUMENT-LOADER");
        IFile iFile = (IFile)project.findMember("/files/simple.xml");
        IStructuredModel model = null;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        model = modelManager.getModelForEdit(iFile);
        return model;
    }

    public void testDocumentChangingListener() throws BadLocationException, IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            TestListener listener = new TestListener();
            sDoc.addDocumentChangingListener((IStructuredDocumentListener)listener);
            String text = sDoc.get();
            sDoc.replace(0, text.length(), text);
            sDoc.removeDocumentChangingListener((IStructuredDocumentListener)listener);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testReadOnly() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            String text = sDoc.get();
            sDoc.clearReadOnly(0, text.length());
            TestStructuredDocument.assertFalse((boolean)sDoc.containsReadOnly(0, text.length()));
            sDoc.makeReadOnly(0, 10);
            TestStructuredDocument.assertTrue((boolean)sDoc.containsReadOnly(9, 1));
            TestStructuredDocument.assertTrue((boolean)sDoc.containsReadOnly(0, text.length()));
            sDoc.clearReadOnly(0, text.length());
            TestStructuredDocument.assertFalse((boolean)sDoc.containsReadOnly(0, text.length()));
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetRegionAtCharacterOffset() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            IStructuredDocumentRegion r = sDoc.getRegionAtCharacterOffset(0);
            TestStructuredDocument.assertNotNull((String)"couldn't get region at offset: 0", (Object)r);
            r = sDoc.getRegionAtCharacterOffset(sDoc.getLength());
            TestStructuredDocument.assertNotNull((String)("couldn't get region at offset: " + sDoc.getLength()), (Object)r);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetRegionList() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            IStructuredDocumentRegionList regions = sDoc.getRegionList();
            TestStructuredDocument.assertNotNull((String)"couldn't get region list", (Object)regions);
            TestStructuredDocument.assertEquals((int)17, (int)regions.getLength());
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetText() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            String text = sDoc.getText();
            String expectedText = "<?xml version=\"1.0\"?>\r\n<list>\r\n\t<item1 attr1=\"attr1\" attr2=\"attr2\" attr3=\"attr3\">\r\n\t\tone\r\n\t</item1>\r\n\t<item2 attr1=\"attr1\" attr2=\"attr2\" attr3=\"attr3\" >\r\n\t\ttwo\r\n\t</item2>\r\n\t<item3 attr1=\"attr1\" attr2=\"attr2\" attr3=\"attr3\">\r\n\t\tthree\r\n\t</item3>\r\n</list>";
            TestStructuredDocument.assertEquals((String)expectedText, (String)text);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testNewInstance() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            IStructuredDocument newDoc = sDoc.newInstance();
            TestStructuredDocument.assertNotSame((String)"document instances should be different", (Object)sDoc, (Object)newDoc);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testReplace() throws BadLocationException, IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            long modificationStamp = -1L;
            if (sDoc instanceof IDocumentExtension4) {
                modificationStamp = ((IDocumentExtension4)sDoc).getModificationStamp();
            }
            sDoc.replace(0, sDoc.getLength(), "replaced");
            String text = sDoc.getText();
            TestStructuredDocument.assertEquals((String)"replaced", (String)text);
            if (modificationStamp > -1L) {
                TestStructuredDocument.assertTrue((String)"replace text modification stamp failed", (modificationStamp != ((IDocumentExtension4)sDoc).getModificationStamp() ? 1 : 0) != 0);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testReplaceWithModificationStamp() throws BadLocationException, IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            if (sDoc instanceof IDocumentExtension4) {
                IDocumentExtension4 ext4 = (IDocumentExtension4)sDoc;
                long modificationStamp = ext4.getModificationStamp() + 1L;
                ext4.replace(0, sDoc.getLength(), "replaced", modificationStamp);
                String text = sDoc.getText();
                TestStructuredDocument.assertEquals((String)"replaced", (String)text);
                TestStructuredDocument.assertTrue((String)"replace text modification stamp failed", (modificationStamp == ((IDocumentExtension4)sDoc).getModificationStamp() ? 1 : 0) != 0);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testReplaceText() throws BadLocationException, IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            long modificationStamp = -1L;
            if (sDoc instanceof IDocumentExtension4) {
                modificationStamp = ((IDocumentExtension4)sDoc).getModificationStamp();
            }
            sDoc.replaceText((Object)this, 0, sDoc.getLength(), "replaced");
            String text = sDoc.getText();
            TestStructuredDocument.assertEquals((String)"replaced", (String)text);
            if (modificationStamp > -1L) {
                TestStructuredDocument.assertTrue((String)"replace text modification stamp failed", (modificationStamp != ((IDocumentExtension4)sDoc).getModificationStamp() ? 1 : 0) != 0);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testOverrideReadOnlyReplaceText() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            sDoc.makeReadOnly(0, 1);
            long modificationStamp = -1L;
            if (sDoc instanceof IDocumentExtension4) {
                modificationStamp = ((IDocumentExtension4)sDoc).getModificationStamp();
            }
            sDoc.replaceText((Object)this, 0, sDoc.getLength(), "replaced");
            TestStructuredDocument.assertNotSame((String)"text should not have been replacable (read only)", (Object)"replaced", (Object)sDoc.getText());
            if (modificationStamp > -1L) {
                TestStructuredDocument.assertTrue((String)"replace text modification stamp (read only) failed", (modificationStamp != ((IDocumentExtension4)sDoc).getModificationStamp() ? 1 : 0) != 0);
            }
            modificationStamp = -1L;
            if (sDoc instanceof IDocumentExtension4) {
                modificationStamp = ((IDocumentExtension4)sDoc).getModificationStamp() + 1L;
            }
            sDoc.replaceText((Object)this, 0, sDoc.getLength(), "replaced", true);
            TestStructuredDocument.assertEquals((String)"text should have been forced replaced", (String)"replaced", (String)sDoc.getText());
            if (modificationStamp > -1L) {
                TestStructuredDocument.assertTrue((String)"replace text modification stamp failed", (modificationStamp != ((IDocumentExtension4)sDoc).getModificationStamp() ? 1 : 0) != 0);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testSet() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            long modificationStamp = -1L;
            if (sDoc instanceof IDocumentExtension4) {
                modificationStamp = ((IDocumentExtension4)sDoc).getModificationStamp();
            }
            sDoc.set("set text");
            TestStructuredDocument.assertEquals((String)"set text failed", (String)"set text", (String)sDoc.getText());
            if (modificationStamp > -1L) {
                TestStructuredDocument.assertTrue((String)"set text modification stamp failed", (modificationStamp != ((IDocumentExtension4)sDoc).getModificationStamp() ? 1 : 0) != 0);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testSetWithModificationStamp() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            if (sDoc instanceof IDocumentExtension4) {
                IDocumentExtension4 ext4 = (IDocumentExtension4)sDoc;
                long modificationStamp = ext4.getModificationStamp() + 1L;
                ext4.set("set text", modificationStamp);
                TestStructuredDocument.assertEquals((String)"set text failed", (String)"set text", (String)sDoc.getText());
                TestStructuredDocument.assertTrue((String)"set text modification stamp failed", (modificationStamp == ((IDocumentExtension4)sDoc).getModificationStamp() ? 1 : 0) != 0);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testSetText() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            long modificationStamp = -1L;
            if (sDoc instanceof IDocumentExtension4) {
                modificationStamp = ((IDocumentExtension4)sDoc).getModificationStamp();
            }
            sDoc.setText((Object)this, "set text");
            TestStructuredDocument.assertEquals((String)"set text failed", (String)"set text", (String)sDoc.getText());
            if (modificationStamp > -1L) {
                TestStructuredDocument.assertTrue((String)"set text modification stamp failed", (modificationStamp != ((IDocumentExtension4)sDoc).getModificationStamp() ? 1 : 0) != 0);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetEncodingMemento() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = null;
            sDoc = model.getStructuredDocument();
            EncodingMemento memento = sDoc.getEncodingMemento();
            TestStructuredDocument.assertNotNull((String)"couldn't get encoding memento", (Object)memento);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetDetectedLineDelimiter() throws IOException, CoreException, BadLocationException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            String delim = sDoc.getLineDelimiter();
            TestStructuredDocument.assertEquals((String)"wrong preferred line delmiter", (String)"\r\n", (String)delim);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testSetEncodingMemento() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            EncodingMemento memento = new EncodingMemento();
            sDoc.setEncodingMemento(memento);
            EncodingMemento gottenMemento = sDoc.getEncodingMemento();
            TestStructuredDocument.assertEquals((String)"mementos don't match", (Object)memento, (Object)gottenMemento);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    void setDetectedLineDelimiter() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            sDoc.setPreferredLineDelimiter("\n");
            String delim = sDoc.getPreferredLineDelimiter();
            TestStructuredDocument.assertEquals((String)"set line delimiter failed", (String)"\n", (String)delim);
            sDoc.setPreferredLineDelimiter("\r\n");
            delim = sDoc.getPreferredLineDelimiter();
            TestStructuredDocument.assertEquals((String)"set line delimiter failed", (String)"\r\n", (String)delim);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testStringMatches() {
    }

    public void testCreatePosition() throws BadPositionCategoryException, BadLocationException, IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument sDoc = model.getStructuredDocument();
            Position p = new Position(0, 10);
            String[] categories = sDoc.getPositionCategories();
            int i = 0;
            while (i < categories.length) {
                sDoc.addPosition(categories[i], p);
                ++i;
            }
            int found = 0;
            int i2 = 0;
            while (i2 < categories.length) {
                Position[] positions = sDoc.getPositions(categories[i2]);
                int j = 0;
                while (j < positions.length) {
                    if (positions[j] == p) {
                        ++found;
                    }
                    ++j;
                }
                ++i2;
            }
            TestStructuredDocument.assertEquals((String)"wrong number of positions", (int)categories.length, (int)found);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testReadOnlyTag() throws CoreException, IOException {
        IStructuredModel model = this.getTestModel();
        try {
            IDOMNode node = (IDOMNode)model.getIndexedRegion(23);
            TestStructuredDocument.assertNotNull((String)"couldn't get node", (Object)node);
            node.setChildEditable(false);
            IStructuredDocument document = model.getStructuredDocument();
            TestStructuredDocument.assertTrue((boolean)document.containsReadOnly(80, 0));
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    class TestListener
    implements IStructuredDocumentListener {
        boolean newModelCalled = false;
        boolean noChangeCalled = false;
        boolean nodesReplacedCalled = false;
        boolean regionChangedCalled = false;
        boolean regionsReplacedCalled = false;

        TestListener() {
        }

        public void newModel(NewDocumentEvent structuredDocumentEvent) {
            this.newModelCalled = true;
        }

        public void noChange(NoChangeEvent structuredDocumentEvent) {
            this.noChangeCalled = true;
        }

        public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
            this.nodesReplacedCalled = true;
        }

        public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
            this.regionChangedCalled = true;
        }

        public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
            this.regionsReplacedCalled = true;
        }
    }
}

