/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.modelintegration.util;

import org.easymock.EasyMock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;

public class ModelIntegrationUtilTest {
    @Test
    public void getMOINNoResourceFolderTest() {
        IProject project = (IProject)EasyMock.createMock(IProject.class);
        EasyMock.expect((Object)project.getProjectRelativePath()).andStubReturn((Object)new Path("src"));
        EasyMock.replay((Object[])new Object[]{project});
        IPath p = ModelIntegrationUtil.getEMFResourceFolderPath((IProject)project);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)2L, (long)p.segmentCount());
        Assert.assertEquals((Object)p.segment(0), (Object)"src");
    }

    @Test
    public void getMOINSrcResourceFolderTest() {
        IProject project = (IProject)EasyMock.createMock(IProject.class);
        BasicInternalEList rr = new BasicInternalEList(String.class);
        rr.add((Object)"src");
        EasyMock.expect((Object)project.getProjectRelativePath()).andStubReturn((Object)new Path("src"));
        EasyMock.replay((Object[])new Object[]{project});
        IPath p = ModelIntegrationUtil.getEMFResourceFolderPath((IProject)project);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)2L, (long)p.segmentCount());
        Assert.assertEquals((Object)p.segment(0), (Object)"src");
    }

    @Test
    public void copyExistingXMIContentAndDeleteFileTest() throws Exception {
        Bundle b = (Bundle)EasyMock.createMock(Bundle.class);
        BundleContext bc = (BundleContext)EasyMock.createMock(BundleContext.class);
        EasyMock.expect((Object)bc.getBundle()).andStubReturn((Object)b);
        EasyMock.expect((Object)b.getSymbolicName()).andStubReturn((Object)"jpa_editor");
        bc.addBundleListener((BundleListener)EasyMock.isA(BundleListener.class));
        EasyMock.replay((Object[])new Object[]{bc, b});
        JPADiagramEditorPlugin p = new JPADiagramEditorPlugin();
        p.start(bc);
        IPreferenceStore store = JPADiagramEditorPlugin.getDefault().getPreferenceStore();
        store.putValue("org.eclipse.jpt.jpadiagrameditor.ui.diagramfolder", "diagrams");
        store.getString("org.eclipse.jpt.jpadiagrameditor.ui.diagramfolder");
        JPACreateFactory factory = JPACreateFactory.instance();
        JpaProject jpaProject = factory.createJPAProject("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)jpaProject);
        ModelIntegrationUtil.copyExistingXMIContentAndDeleteFile((IProject)jpaProject.getProject(), (String)"diagram_name", null);
    }
}

