/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.tomcat.tests;

import java.io.File;
import java.util.List;
import junit.framework.Test;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleImportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;

public class WebImportOperationTomcatTest
extends ModuleImportOperationTest {
    private static final String TESTS_PATH = String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "TestData" + File.separatorChar + "WARImportTests";
    protected boolean dataModelShouldBeValid = true;

    public WebImportOperationTomcatTest() {
        super("WebImportOperationTomcatTests");
    }

    public WebImportOperationTomcatTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SimpleTestSuite(WebImportOperationTomcatTest.class);
    }

    protected IDataModel getModelInstance() {
        return null;
    }

    protected List getImportableArchiveFileNames() {
        return ProjectUtility.getWarsInDirectory((Plugin)HeadlessTestsPlugin.getDefault(), (String)TESTS_PATH);
    }

    public void setServerTargetProperty(IDataModel dataModel) {
    }

    public void testAllImportTestCases() throws Exception {
        List projects = this.getImportableArchiveFileNames();
        int i = 0;
        while (i < projects.size()) {
            String jarName = projects.get(i).toString();
            String projectName = jarName.substring(jarName.lastIndexOf(File.separator) + 1, jarName.length() - 4);
            this.testImport(projectName, jarName);
            ++i;
        }
    }

    public void testImportTestCase_0() throws Exception {
        this.importIndex(0);
    }

    public void testImportTestCase_1() throws Exception {
        this.importIndex(1);
    }

    public void testImportTestCase_2() throws Exception {
        this.importIndex(2);
    }

    public void testImportTestCase_3() throws Exception {
        this.importIndex(3);
    }

    public void testImportTestCase_4() throws Exception {
        this.importIndex(4);
    }

    public void testImportTestCase_5() throws Exception {
        this.importIndex(5);
    }

    public void testImportTestCase_6() throws Exception {
        this.importIndex(6);
    }

    public void testImportTestCase_7() throws Exception {
        this.importIndex(7);
    }

    public void testImportTestCase_8() throws Exception {
        this.importIndex(8);
    }

    public void testImportTestCase_9() throws Exception {
        this.importIndex(9);
    }

    private void importIndex(int index) throws Exception {
        List projects = this.getImportableArchiveFileNames();
        if (index < projects.size()) {
            String jarName = projects.get(index).toString();
            String projectName = jarName.substring(jarName.lastIndexOf(File.separator) + 1, jarName.length() - 4);
            this.testImport(projectName, jarName);
        }
    }

    public void testImportTestCase_rest() throws Exception {
        List projects = this.getImportableArchiveFileNames();
        int i = 10;
        while (i < projects.size()) {
            String jarName = projects.get(i).toString();
            String projectName = jarName.substring(jarName.lastIndexOf(File.separator) + 1, jarName.length() - 4);
            this.testImport(projectName, jarName);
            ++i;
        }
    }

    public void testImport(String projectName, String filename) throws Exception {
        IDataModel dataModel = this.getModelInstance();
        dataModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)filename);
        dataModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", (Object)projectName);
        if (this.dataModelShouldBeValid) {
            WebImportOperationTomcatTest.runAndVerify((IDataModel)dataModel);
        } else {
            WebImportOperationTomcatTest.verifyInvalidDataModel((IDataModel)dataModel);
        }
    }

    protected IDataModel getExportDataModel(String projectName, String destination, boolean exportSource, boolean runBuild, boolean overwriteExisting) {
        return null;
    }

    protected IDataModel getImportDataModel(String filePath, String projectName, IDataModel creationModel, boolean closeArchiveOnDispose) {
        return null;
    }

    protected String getModuleExtension() {
        return null;
    }
}

